/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.VersionInfo;
import io.strimzi.test.TestUtils;
import io.strimzi.test.interfaces.TestSeparator;
import io.strimzi.test.k8s.KubeClusterResource;
import java.io.File;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class AbstractCrdIT
implements TestSeparator {
    protected KubeClusterResource cluster = KubeClusterResource.getInstance();

    protected void assumeKube1_16Plus() {
        VersionInfo version = new DefaultKubernetesClient().getVersion();
        Assumptions.assumeTrue(("1".equals(version.getMajor()) && Integer.parseInt(version.getMinor().split("\\D")[0]) >= 16 ? 1 : 0) != 0);
    }

    private <T extends CustomResource> T loadResource(Class<T> resourceClass, String resource) {
        String ssStr = TestUtils.readResource(resourceClass, (String)resource);
        MatcherAssert.assertThat((String)("Class path resource " + resource + " was missing"), (Object)ssStr, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        return (T)((CustomResource)TestUtils.fromYaml((String)resource, resourceClass, (boolean)false));
    }

    protected <T extends CustomResource> void loadCustomResourceToYaml(Class<T> resourceClass, String resource) {
        T model = this.loadResource(resourceClass, resource);
        TestUtils.toYamlString(model);
    }

    protected <T extends CustomResource> void createDeleteCustomResource(String resourceName) {
        File resourceFile = new File(this.getClass().getResource(resourceName).getPath());
        this.createDelete(resourceFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDelete(File resourceFile) {
        RuntimeException creationException = null;
        RuntimeException deletionException = null;
        try {
            try {
                KubeClusterResource.cmdKubeClient().create(resourceFile, false);
            }
            catch (RuntimeException t) {
                creationException = t;
            }
        }
        catch (Throwable throwable) {
            try {
                KubeClusterResource.cmdKubeClient().delete(new File[]{resourceFile});
            }
            catch (RuntimeException t) {
                deletionException = t;
            }
            throw throwable;
        }
        try {
            KubeClusterResource.cmdKubeClient().delete(new File[]{resourceFile});
        }
        catch (RuntimeException t) {
            deletionException = t;
        }
        if (creationException != null) {
            if (deletionException != null) {
                creationException.addSuppressed(deletionException);
            }
            throw creationException;
        }
        if (deletionException != null) {
            throw deletionException;
        }
    }

    protected <T extends CustomResource> void createScaleDelete(Class<T> resourceClass, String resource) {
        T model = this.loadResource(resourceClass, resource);
        String modelKind = model.getKind();
        String modelName = model.getMetadata().getName();
        String modelStr = TestUtils.toYamlString(model);
        this.createScaleDelete(modelKind, modelName, modelStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createScaleDelete(String kind, String name, String ssStr) {
        RuntimeException creationOrScaleException = null;
        RuntimeException deletionException = null;
        try {
            try {
                KubeClusterResource.cmdKubeClient().applyContent(ssStr);
                KubeClusterResource.cmdKubeClient().scaleByName(kind, name, 10);
            }
            catch (RuntimeException t) {
                creationOrScaleException = t;
            }
        }
        finally {
            try {
                KubeClusterResource.cmdKubeClient().deleteContent(ssStr);
            }
            catch (RuntimeException t) {
                deletionException = t;
            }
        }
        if (creationOrScaleException != null) {
            if (deletionException != null) {
                creationOrScaleException.addSuppressed(deletionException);
            }
            throw creationOrScaleException;
        }
        if (deletionException != null) {
            throw deletionException;
        }
    }

    protected void assertMissingRequiredPropertiesMessage(String message, String ... requiredProperties) {
        for (String requiredProperty : requiredProperties) {
            MatcherAssert.assertThat((String)("Could not find" + requiredProperty + " in message: " + message), (Object)message, (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.containsStringIgnoringCase((String)(requiredProperty + " in body is required")), CoreMatchers.containsStringIgnoringCase((String)(requiredProperty + ": Required value")), CoreMatchers.containsStringIgnoringCase((String)("missing required field \"" + requiredProperty + "\""))}));
        }
    }

    @BeforeEach
    public void setupTests() {
        this.cluster.cluster();
    }
}

