package io.strimzi.api.kafka.model.tracing;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class JaegerTracingBuilder extends JaegerTracingFluentImpl<JaegerTracingBuilder> implements VisitableBuilder<JaegerTracing,JaegerTracingBuilder> {

    JaegerTracingFluent<?> fluent;
    Boolean validationEnabled;

    public JaegerTracingBuilder() {
        this(true);
    }

    public JaegerTracingBuilder(Boolean validationEnabled) {
        this(new JaegerTracing(), validationEnabled);
    }

    public JaegerTracingBuilder(JaegerTracingFluent<?> fluent) {
        this(fluent, true);
    }

    public JaegerTracingBuilder(JaegerTracingFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new JaegerTracing(), validationEnabled);
    }

    public JaegerTracingBuilder(JaegerTracingFluent<?> fluent,JaegerTracing instance) {
        this(fluent, instance, true);
    }

    public JaegerTracingBuilder(JaegerTracingFluent<?> fluent,JaegerTracing instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        this.validationEnabled = validationEnabled; 
    }

    public JaegerTracingBuilder(JaegerTracing instance) {
        this(instance,true);
    }

    public JaegerTracingBuilder(JaegerTracing instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.validationEnabled = validationEnabled; 
    }

    public JaegerTracing build() {
        JaegerTracing buildable = new JaegerTracing();
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        JaegerTracingBuilder that = (JaegerTracingBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
