package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;

public class ZookeeperClusterTemplateFluentImpl<A extends ZookeeperClusterTemplateFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ZookeeperClusterTemplateFluent<A> {

    private StatefulSetTemplateBuilder statefulset;
    private PodTemplateBuilder pod;
    private InternalServiceTemplateBuilder clientService;
    private InternalServiceTemplateBuilder nodesService;
    private ResourceTemplateBuilder persistentVolumeClaim;
    private PodDisruptionBudgetTemplateBuilder podDisruptionBudget;
    private ContainerTemplateBuilder zookeeperContainer;
    private ContainerTemplateBuilder tlsSidecarContainer;

    public ZookeeperClusterTemplateFluentImpl() {
    }

    public ZookeeperClusterTemplateFluentImpl(ZookeeperClusterTemplate instance) {
        this.withStatefulset(instance.getStatefulset());
        
        this.withPod(instance.getPod());
        
        this.withClientService(instance.getClientService());
        
        this.withNodesService(instance.getNodesService());
        
        this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
        
        this.withPodDisruptionBudget(instance.getPodDisruptionBudget());
        
        this.withZookeeperContainer(instance.getZookeeperContainer());
        
        this.withTlsSidecarContainer(instance.getTlsSidecarContainer());
    }

    
/**
 * This method has been deprecated, please use method buildStatefulset instead.
 * @return The buildable object.
 */
@Deprecated public StatefulSetTemplate getStatefulset() {
        return this.statefulset!=null?this.statefulset.build():null;
    }

    public StatefulSetTemplate buildStatefulset() {
        return this.statefulset!=null?this.statefulset.build():null;
    }

    public A withStatefulset(StatefulSetTemplate statefulset) {
        _visitables.get("statefulset").remove(this.statefulset);
        if (statefulset!=null){ this.statefulset= new StatefulSetTemplateBuilder(statefulset); _visitables.get("statefulset").add(this.statefulset);} return (A) this;
    }

    public Boolean hasStatefulset() {
        return this.statefulset != null;
    }

    public ZookeeperClusterTemplateFluent.StatefulsetNested<A> withNewStatefulset() {
        return new StatefulsetNestedImpl();
    }

    public ZookeeperClusterTemplateFluent.StatefulsetNested<A> withNewStatefulsetLike(StatefulSetTemplate item) {
        return new StatefulsetNestedImpl(item);
    }

    public ZookeeperClusterTemplateFluent.StatefulsetNested<A> editStatefulset() {
        return withNewStatefulsetLike(getStatefulset());
    }

    public ZookeeperClusterTemplateFluent.StatefulsetNested<A> editOrNewStatefulset() {
        return withNewStatefulsetLike(getStatefulset() != null ? getStatefulset(): new StatefulSetTemplateBuilder().build());
    }

    public ZookeeperClusterTemplateFluent.StatefulsetNested<A> editOrNewStatefulsetLike(StatefulSetTemplate item) {
        return withNewStatefulsetLike(getStatefulset() != null ? getStatefulset(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPod instead.
 * @return The buildable object.
 */
@Deprecated public PodTemplate getPod() {
        return this.pod!=null?this.pod.build():null;
    }

    public PodTemplate buildPod() {
        return this.pod!=null?this.pod.build():null;
    }

    public A withPod(PodTemplate pod) {
        _visitables.get("pod").remove(this.pod);
        if (pod!=null){ this.pod= new PodTemplateBuilder(pod); _visitables.get("pod").add(this.pod);} return (A) this;
    }

    public Boolean hasPod() {
        return this.pod != null;
    }

    public ZookeeperClusterTemplateFluent.PodNested<A> withNewPod() {
        return new PodNestedImpl();
    }

    public ZookeeperClusterTemplateFluent.PodNested<A> withNewPodLike(PodTemplate item) {
        return new PodNestedImpl(item);
    }

    public ZookeeperClusterTemplateFluent.PodNested<A> editPod() {
        return withNewPodLike(getPod());
    }

    public ZookeeperClusterTemplateFluent.PodNested<A> editOrNewPod() {
        return withNewPodLike(getPod() != null ? getPod(): new PodTemplateBuilder().build());
    }

    public ZookeeperClusterTemplateFluent.PodNested<A> editOrNewPodLike(PodTemplate item) {
        return withNewPodLike(getPod() != null ? getPod(): item);
    }

    
/**
 * This method has been deprecated, please use method buildClientService instead.
 * @return The buildable object.
 */
@Deprecated public InternalServiceTemplate getClientService() {
        return this.clientService!=null?this.clientService.build():null;
    }

    public InternalServiceTemplate buildClientService() {
        return this.clientService!=null?this.clientService.build():null;
    }

    public A withClientService(InternalServiceTemplate clientService) {
        _visitables.get("clientService").remove(this.clientService);
        if (clientService!=null){ this.clientService= new InternalServiceTemplateBuilder(clientService); _visitables.get("clientService").add(this.clientService);} return (A) this;
    }

    public Boolean hasClientService() {
        return this.clientService != null;
    }

    public ZookeeperClusterTemplateFluent.ClientServiceNested<A> withNewClientService() {
        return new ClientServiceNestedImpl();
    }

    public ZookeeperClusterTemplateFluent.ClientServiceNested<A> withNewClientServiceLike(InternalServiceTemplate item) {
        return new ClientServiceNestedImpl(item);
    }

    public ZookeeperClusterTemplateFluent.ClientServiceNested<A> editClientService() {
        return withNewClientServiceLike(getClientService());
    }

    public ZookeeperClusterTemplateFluent.ClientServiceNested<A> editOrNewClientService() {
        return withNewClientServiceLike(getClientService() != null ? getClientService(): new InternalServiceTemplateBuilder().build());
    }

    public ZookeeperClusterTemplateFluent.ClientServiceNested<A> editOrNewClientServiceLike(InternalServiceTemplate item) {
        return withNewClientServiceLike(getClientService() != null ? getClientService(): item);
    }

    
/**
 * This method has been deprecated, please use method buildNodesService instead.
 * @return The buildable object.
 */
@Deprecated public InternalServiceTemplate getNodesService() {
        return this.nodesService!=null?this.nodesService.build():null;
    }

    public InternalServiceTemplate buildNodesService() {
        return this.nodesService!=null?this.nodesService.build():null;
    }

    public A withNodesService(InternalServiceTemplate nodesService) {
        _visitables.get("nodesService").remove(this.nodesService);
        if (nodesService!=null){ this.nodesService= new InternalServiceTemplateBuilder(nodesService); _visitables.get("nodesService").add(this.nodesService);} return (A) this;
    }

    public Boolean hasNodesService() {
        return this.nodesService != null;
    }

    public ZookeeperClusterTemplateFluent.NodesServiceNested<A> withNewNodesService() {
        return new NodesServiceNestedImpl();
    }

    public ZookeeperClusterTemplateFluent.NodesServiceNested<A> withNewNodesServiceLike(InternalServiceTemplate item) {
        return new NodesServiceNestedImpl(item);
    }

    public ZookeeperClusterTemplateFluent.NodesServiceNested<A> editNodesService() {
        return withNewNodesServiceLike(getNodesService());
    }

    public ZookeeperClusterTemplateFluent.NodesServiceNested<A> editOrNewNodesService() {
        return withNewNodesServiceLike(getNodesService() != null ? getNodesService(): new InternalServiceTemplateBuilder().build());
    }

    public ZookeeperClusterTemplateFluent.NodesServiceNested<A> editOrNewNodesServiceLike(InternalServiceTemplate item) {
        return withNewNodesServiceLike(getNodesService() != null ? getNodesService(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPersistentVolumeClaim instead.
 * @return The buildable object.
 */
@Deprecated public ResourceTemplate getPersistentVolumeClaim() {
        return this.persistentVolumeClaim!=null?this.persistentVolumeClaim.build():null;
    }

    public ResourceTemplate buildPersistentVolumeClaim() {
        return this.persistentVolumeClaim!=null?this.persistentVolumeClaim.build():null;
    }

    public A withPersistentVolumeClaim(ResourceTemplate persistentVolumeClaim) {
        _visitables.get("persistentVolumeClaim").remove(this.persistentVolumeClaim);
        if (persistentVolumeClaim!=null){ this.persistentVolumeClaim= new ResourceTemplateBuilder(persistentVolumeClaim); _visitables.get("persistentVolumeClaim").add(this.persistentVolumeClaim);} return (A) this;
    }

    public Boolean hasPersistentVolumeClaim() {
        return this.persistentVolumeClaim != null;
    }

    public ZookeeperClusterTemplateFluent.PersistentVolumeClaimNested<A> withNewPersistentVolumeClaim() {
        return new PersistentVolumeClaimNestedImpl();
    }

    public ZookeeperClusterTemplateFluent.PersistentVolumeClaimNested<A> withNewPersistentVolumeClaimLike(ResourceTemplate item) {
        return new PersistentVolumeClaimNestedImpl(item);
    }

    public ZookeeperClusterTemplateFluent.PersistentVolumeClaimNested<A> editPersistentVolumeClaim() {
        return withNewPersistentVolumeClaimLike(getPersistentVolumeClaim());
    }

    public ZookeeperClusterTemplateFluent.PersistentVolumeClaimNested<A> editOrNewPersistentVolumeClaim() {
        return withNewPersistentVolumeClaimLike(getPersistentVolumeClaim() != null ? getPersistentVolumeClaim(): new ResourceTemplateBuilder().build());
    }

    public ZookeeperClusterTemplateFluent.PersistentVolumeClaimNested<A> editOrNewPersistentVolumeClaimLike(ResourceTemplate item) {
        return withNewPersistentVolumeClaimLike(getPersistentVolumeClaim() != null ? getPersistentVolumeClaim(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPodDisruptionBudget instead.
 * @return The buildable object.
 */
@Deprecated public PodDisruptionBudgetTemplate getPodDisruptionBudget() {
        return this.podDisruptionBudget!=null?this.podDisruptionBudget.build():null;
    }

    public PodDisruptionBudgetTemplate buildPodDisruptionBudget() {
        return this.podDisruptionBudget!=null?this.podDisruptionBudget.build():null;
    }

    public A withPodDisruptionBudget(PodDisruptionBudgetTemplate podDisruptionBudget) {
        _visitables.get("podDisruptionBudget").remove(this.podDisruptionBudget);
        if (podDisruptionBudget!=null){ this.podDisruptionBudget= new PodDisruptionBudgetTemplateBuilder(podDisruptionBudget); _visitables.get("podDisruptionBudget").add(this.podDisruptionBudget);} return (A) this;
    }

    public Boolean hasPodDisruptionBudget() {
        return this.podDisruptionBudget != null;
    }

    public ZookeeperClusterTemplateFluent.PodDisruptionBudgetNested<A> withNewPodDisruptionBudget() {
        return new PodDisruptionBudgetNestedImpl();
    }

    public ZookeeperClusterTemplateFluent.PodDisruptionBudgetNested<A> withNewPodDisruptionBudgetLike(PodDisruptionBudgetTemplate item) {
        return new PodDisruptionBudgetNestedImpl(item);
    }

    public ZookeeperClusterTemplateFluent.PodDisruptionBudgetNested<A> editPodDisruptionBudget() {
        return withNewPodDisruptionBudgetLike(getPodDisruptionBudget());
    }

    public ZookeeperClusterTemplateFluent.PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudget() {
        return withNewPodDisruptionBudgetLike(getPodDisruptionBudget() != null ? getPodDisruptionBudget(): new PodDisruptionBudgetTemplateBuilder().build());
    }

    public ZookeeperClusterTemplateFluent.PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudgetLike(PodDisruptionBudgetTemplate item) {
        return withNewPodDisruptionBudgetLike(getPodDisruptionBudget() != null ? getPodDisruptionBudget(): item);
    }

    
/**
 * This method has been deprecated, please use method buildZookeeperContainer instead.
 * @return The buildable object.
 */
@Deprecated public ContainerTemplate getZookeeperContainer() {
        return this.zookeeperContainer!=null?this.zookeeperContainer.build():null;
    }

    public ContainerTemplate buildZookeeperContainer() {
        return this.zookeeperContainer!=null?this.zookeeperContainer.build():null;
    }

    public A withZookeeperContainer(ContainerTemplate zookeeperContainer) {
        _visitables.get("zookeeperContainer").remove(this.zookeeperContainer);
        if (zookeeperContainer!=null){ this.zookeeperContainer= new ContainerTemplateBuilder(zookeeperContainer); _visitables.get("zookeeperContainer").add(this.zookeeperContainer);} return (A) this;
    }

    public Boolean hasZookeeperContainer() {
        return this.zookeeperContainer != null;
    }

    public ZookeeperClusterTemplateFluent.ZookeeperContainerNested<A> withNewZookeeperContainer() {
        return new ZookeeperContainerNestedImpl();
    }

    public ZookeeperClusterTemplateFluent.ZookeeperContainerNested<A> withNewZookeeperContainerLike(ContainerTemplate item) {
        return new ZookeeperContainerNestedImpl(item);
    }

    public ZookeeperClusterTemplateFluent.ZookeeperContainerNested<A> editZookeeperContainer() {
        return withNewZookeeperContainerLike(getZookeeperContainer());
    }

    public ZookeeperClusterTemplateFluent.ZookeeperContainerNested<A> editOrNewZookeeperContainer() {
        return withNewZookeeperContainerLike(getZookeeperContainer() != null ? getZookeeperContainer(): new ContainerTemplateBuilder().build());
    }

    public ZookeeperClusterTemplateFluent.ZookeeperContainerNested<A> editOrNewZookeeperContainerLike(ContainerTemplate item) {
        return withNewZookeeperContainerLike(getZookeeperContainer() != null ? getZookeeperContainer(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTlsSidecarContainer instead.
 * @return The buildable object.
 */
@Deprecated public ContainerTemplate getTlsSidecarContainer() {
        return this.tlsSidecarContainer!=null?this.tlsSidecarContainer.build():null;
    }

    public ContainerTemplate buildTlsSidecarContainer() {
        return this.tlsSidecarContainer!=null?this.tlsSidecarContainer.build():null;
    }

    public A withTlsSidecarContainer(ContainerTemplate tlsSidecarContainer) {
        _visitables.get("tlsSidecarContainer").remove(this.tlsSidecarContainer);
        if (tlsSidecarContainer!=null){ this.tlsSidecarContainer= new ContainerTemplateBuilder(tlsSidecarContainer); _visitables.get("tlsSidecarContainer").add(this.tlsSidecarContainer);} return (A) this;
    }

    public Boolean hasTlsSidecarContainer() {
        return this.tlsSidecarContainer != null;
    }

    public ZookeeperClusterTemplateFluent.TlsSidecarContainerNested<A> withNewTlsSidecarContainer() {
        return new TlsSidecarContainerNestedImpl();
    }

    public ZookeeperClusterTemplateFluent.TlsSidecarContainerNested<A> withNewTlsSidecarContainerLike(ContainerTemplate item) {
        return new TlsSidecarContainerNestedImpl(item);
    }

    public ZookeeperClusterTemplateFluent.TlsSidecarContainerNested<A> editTlsSidecarContainer() {
        return withNewTlsSidecarContainerLike(getTlsSidecarContainer());
    }

    public ZookeeperClusterTemplateFluent.TlsSidecarContainerNested<A> editOrNewTlsSidecarContainer() {
        return withNewTlsSidecarContainerLike(getTlsSidecarContainer() != null ? getTlsSidecarContainer(): new ContainerTemplateBuilder().build());
    }

    public ZookeeperClusterTemplateFluent.TlsSidecarContainerNested<A> editOrNewTlsSidecarContainerLike(ContainerTemplate item) {
        return withNewTlsSidecarContainerLike(getTlsSidecarContainer() != null ? getTlsSidecarContainer(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ZookeeperClusterTemplateFluentImpl that = (ZookeeperClusterTemplateFluentImpl) o;
        if (statefulset != null ? !statefulset.equals(that.statefulset) :that.statefulset != null) return false;
        if (pod != null ? !pod.equals(that.pod) :that.pod != null) return false;
        if (clientService != null ? !clientService.equals(that.clientService) :that.clientService != null) return false;
        if (nodesService != null ? !nodesService.equals(that.nodesService) :that.nodesService != null) return false;
        if (persistentVolumeClaim != null ? !persistentVolumeClaim.equals(that.persistentVolumeClaim) :that.persistentVolumeClaim != null) return false;
        if (podDisruptionBudget != null ? !podDisruptionBudget.equals(that.podDisruptionBudget) :that.podDisruptionBudget != null) return false;
        if (zookeeperContainer != null ? !zookeeperContainer.equals(that.zookeeperContainer) :that.zookeeperContainer != null) return false;
        if (tlsSidecarContainer != null ? !tlsSidecarContainer.equals(that.tlsSidecarContainer) :that.tlsSidecarContainer != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(statefulset,  pod,  clientService,  nodesService,  persistentVolumeClaim,  podDisruptionBudget,  zookeeperContainer,  tlsSidecarContainer,  super.hashCode());
    }

    public class StatefulsetNestedImpl<N> extends StatefulSetTemplateFluentImpl<ZookeeperClusterTemplateFluent.StatefulsetNested<N>> implements ZookeeperClusterTemplateFluent.StatefulsetNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final StatefulSetTemplateBuilder builder;

            StatefulsetNestedImpl(StatefulSetTemplate item) {
                this.builder = new StatefulSetTemplateBuilder(this, item);
                        
            }

            StatefulsetNestedImpl() {
                this.builder = new StatefulSetTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) ZookeeperClusterTemplateFluentImpl.this.withStatefulset(builder.build());
            }

            public N endStatefulset() {
                return and();
            }
    }


    public class PodNestedImpl<N> extends PodTemplateFluentImpl<ZookeeperClusterTemplateFluent.PodNested<N>> implements ZookeeperClusterTemplateFluent.PodNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PodTemplateBuilder builder;

            PodNestedImpl(PodTemplate item) {
                this.builder = new PodTemplateBuilder(this, item);
                        
            }

            PodNestedImpl() {
                this.builder = new PodTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) ZookeeperClusterTemplateFluentImpl.this.withPod(builder.build());
            }

            public N endPod() {
                return and();
            }
    }


    public class ClientServiceNestedImpl<N> extends InternalServiceTemplateFluentImpl<ZookeeperClusterTemplateFluent.ClientServiceNested<N>> implements ZookeeperClusterTemplateFluent.ClientServiceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final InternalServiceTemplateBuilder builder;

            ClientServiceNestedImpl(InternalServiceTemplate item) {
                this.builder = new InternalServiceTemplateBuilder(this, item);
                        
            }

            ClientServiceNestedImpl() {
                this.builder = new InternalServiceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) ZookeeperClusterTemplateFluentImpl.this.withClientService(builder.build());
            }

            public N endClientService() {
                return and();
            }
    }


    public class NodesServiceNestedImpl<N> extends InternalServiceTemplateFluentImpl<ZookeeperClusterTemplateFluent.NodesServiceNested<N>> implements ZookeeperClusterTemplateFluent.NodesServiceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final InternalServiceTemplateBuilder builder;

            NodesServiceNestedImpl(InternalServiceTemplate item) {
                this.builder = new InternalServiceTemplateBuilder(this, item);
                        
            }

            NodesServiceNestedImpl() {
                this.builder = new InternalServiceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) ZookeeperClusterTemplateFluentImpl.this.withNodesService(builder.build());
            }

            public N endNodesService() {
                return and();
            }
    }


    public class PersistentVolumeClaimNestedImpl<N> extends ResourceTemplateFluentImpl<ZookeeperClusterTemplateFluent.PersistentVolumeClaimNested<N>> implements ZookeeperClusterTemplateFluent.PersistentVolumeClaimNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ResourceTemplateBuilder builder;

            PersistentVolumeClaimNestedImpl(ResourceTemplate item) {
                this.builder = new ResourceTemplateBuilder(this, item);
                        
            }

            PersistentVolumeClaimNestedImpl() {
                this.builder = new ResourceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) ZookeeperClusterTemplateFluentImpl.this.withPersistentVolumeClaim(builder.build());
            }

            public N endPersistentVolumeClaim() {
                return and();
            }
    }


    public class PodDisruptionBudgetNestedImpl<N> extends PodDisruptionBudgetTemplateFluentImpl<ZookeeperClusterTemplateFluent.PodDisruptionBudgetNested<N>> implements ZookeeperClusterTemplateFluent.PodDisruptionBudgetNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PodDisruptionBudgetTemplateBuilder builder;

            PodDisruptionBudgetNestedImpl(PodDisruptionBudgetTemplate item) {
                this.builder = new PodDisruptionBudgetTemplateBuilder(this, item);
                        
            }

            PodDisruptionBudgetNestedImpl() {
                this.builder = new PodDisruptionBudgetTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) ZookeeperClusterTemplateFluentImpl.this.withPodDisruptionBudget(builder.build());
            }

            public N endPodDisruptionBudget() {
                return and();
            }
    }


    public class ZookeeperContainerNestedImpl<N> extends ContainerTemplateFluentImpl<ZookeeperClusterTemplateFluent.ZookeeperContainerNested<N>> implements ZookeeperClusterTemplateFluent.ZookeeperContainerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ContainerTemplateBuilder builder;

            ZookeeperContainerNestedImpl(ContainerTemplate item) {
                this.builder = new ContainerTemplateBuilder(this, item);
                        
            }

            ZookeeperContainerNestedImpl() {
                this.builder = new ContainerTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) ZookeeperClusterTemplateFluentImpl.this.withZookeeperContainer(builder.build());
            }

            public N endZookeeperContainer() {
                return and();
            }
    }


    public class TlsSidecarContainerNestedImpl<N> extends ContainerTemplateFluentImpl<ZookeeperClusterTemplateFluent.TlsSidecarContainerNested<N>> implements ZookeeperClusterTemplateFluent.TlsSidecarContainerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ContainerTemplateBuilder builder;

            TlsSidecarContainerNestedImpl(ContainerTemplate item) {
                this.builder = new ContainerTemplateBuilder(this, item);
                        
            }

            TlsSidecarContainerNestedImpl() {
                this.builder = new ContainerTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) ZookeeperClusterTemplateFluentImpl.this.withTlsSidecarContainer(builder.build());
            }

            public N endTlsSidecarContainer() {
                return and();
            }
    }


}
