package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ZookeeperClusterTemplateBuilder extends ZookeeperClusterTemplateFluentImpl<ZookeeperClusterTemplateBuilder> implements VisitableBuilder<ZookeeperClusterTemplate,ZookeeperClusterTemplateBuilder> {

    ZookeeperClusterTemplateFluent<?> fluent;
    Boolean validationEnabled;

    public ZookeeperClusterTemplateBuilder() {
        this(true);
    }

    public ZookeeperClusterTemplateBuilder(Boolean validationEnabled) {
        this(new ZookeeperClusterTemplate(), validationEnabled);
    }

    public ZookeeperClusterTemplateBuilder(ZookeeperClusterTemplateFluent<?> fluent) {
        this(fluent, true);
    }

    public ZookeeperClusterTemplateBuilder(ZookeeperClusterTemplateFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ZookeeperClusterTemplate(), validationEnabled);
    }

    public ZookeeperClusterTemplateBuilder(ZookeeperClusterTemplateFluent<?> fluent,ZookeeperClusterTemplate instance) {
        this(fluent, instance, true);
    }

    public ZookeeperClusterTemplateBuilder(ZookeeperClusterTemplateFluent<?> fluent,ZookeeperClusterTemplate instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withStatefulset(instance.getStatefulset());
        
        fluent.withPod(instance.getPod());
        
        fluent.withClientService(instance.getClientService());
        
        fluent.withNodesService(instance.getNodesService());
        
        fluent.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
        
        fluent.withPodDisruptionBudget(instance.getPodDisruptionBudget());
        
        fluent.withZookeeperContainer(instance.getZookeeperContainer());
        
        fluent.withTlsSidecarContainer(instance.getTlsSidecarContainer());
        
        this.validationEnabled = validationEnabled; 
    }

    public ZookeeperClusterTemplateBuilder(ZookeeperClusterTemplate instance) {
        this(instance,true);
    }

    public ZookeeperClusterTemplateBuilder(ZookeeperClusterTemplate instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withStatefulset(instance.getStatefulset());
        
        this.withPod(instance.getPod());
        
        this.withClientService(instance.getClientService());
        
        this.withNodesService(instance.getNodesService());
        
        this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
        
        this.withPodDisruptionBudget(instance.getPodDisruptionBudget());
        
        this.withZookeeperContainer(instance.getZookeeperContainer());
        
        this.withTlsSidecarContainer(instance.getTlsSidecarContainer());
        
        this.validationEnabled = validationEnabled; 
    }

    public ZookeeperClusterTemplate build() {
        ZookeeperClusterTemplate buildable = new ZookeeperClusterTemplate();
        buildable.setStatefulset(fluent.getStatefulset());
        buildable.setPod(fluent.getPod());
        buildable.setClientService(fluent.getClientService());
        buildable.setNodesService(fluent.getNodesService());
        buildable.setPersistentVolumeClaim(fluent.getPersistentVolumeClaim());
        buildable.setPodDisruptionBudget(fluent.getPodDisruptionBudget());
        buildable.setZookeeperContainer(fluent.getZookeeperContainer());
        buildable.setTlsSidecarContainer(fluent.getTlsSidecarContainer());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ZookeeperClusterTemplateBuilder that = (ZookeeperClusterTemplateBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
