package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class MetadataTemplateBuilder extends MetadataTemplateFluentImpl<MetadataTemplateBuilder> implements VisitableBuilder<MetadataTemplate,MetadataTemplateBuilder> {

    MetadataTemplateFluent<?> fluent;
    Boolean validationEnabled;

    public MetadataTemplateBuilder() {
        this(true);
    }

    public MetadataTemplateBuilder(Boolean validationEnabled) {
        this(new MetadataTemplate(), validationEnabled);
    }

    public MetadataTemplateBuilder(MetadataTemplateFluent<?> fluent) {
        this(fluent, true);
    }

    public MetadataTemplateBuilder(MetadataTemplateFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new MetadataTemplate(), validationEnabled);
    }

    public MetadataTemplateBuilder(MetadataTemplateFluent<?> fluent,MetadataTemplate instance) {
        this(fluent, instance, true);
    }

    public MetadataTemplateBuilder(MetadataTemplateFluent<?> fluent,MetadataTemplate instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withLabels(instance.getLabels());
        
        fluent.withAnnotations(instance.getAnnotations());
        
        this.validationEnabled = validationEnabled; 
    }

    public MetadataTemplateBuilder(MetadataTemplate instance) {
        this(instance,true);
    }

    public MetadataTemplateBuilder(MetadataTemplate instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withLabels(instance.getLabels());
        
        this.withAnnotations(instance.getAnnotations());
        
        this.validationEnabled = validationEnabled; 
    }

    public MetadataTemplate build() {
        MetadataTemplate buildable = new MetadataTemplate();
        buildable.setLabels(fluent.getLabels());
        buildable.setAnnotations(fluent.getAnnotations());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        MetadataTemplateBuilder that = (MetadataTemplateBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
