package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaMirrorMakerTemplateBuilder extends KafkaMirrorMakerTemplateFluentImpl<KafkaMirrorMakerTemplateBuilder> implements VisitableBuilder<KafkaMirrorMakerTemplate,KafkaMirrorMakerTemplateBuilder> {

    KafkaMirrorMakerTemplateFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaMirrorMakerTemplateBuilder() {
        this(true);
    }

    public KafkaMirrorMakerTemplateBuilder(Boolean validationEnabled) {
        this(new KafkaMirrorMakerTemplate(), validationEnabled);
    }

    public KafkaMirrorMakerTemplateBuilder(KafkaMirrorMakerTemplateFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaMirrorMakerTemplateBuilder(KafkaMirrorMakerTemplateFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KafkaMirrorMakerTemplate(), validationEnabled);
    }

    public KafkaMirrorMakerTemplateBuilder(KafkaMirrorMakerTemplateFluent<?> fluent,KafkaMirrorMakerTemplate instance) {
        this(fluent, instance, true);
    }

    public KafkaMirrorMakerTemplateBuilder(KafkaMirrorMakerTemplateFluent<?> fluent,KafkaMirrorMakerTemplate instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDeployment(instance.getDeployment());
        
        fluent.withPod(instance.getPod());
        
        fluent.withPodDisruptionBudget(instance.getPodDisruptionBudget());
        
        fluent.withMirrorMakerContainer(instance.getMirrorMakerContainer());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaMirrorMakerTemplateBuilder(KafkaMirrorMakerTemplate instance) {
        this(instance,true);
    }

    public KafkaMirrorMakerTemplateBuilder(KafkaMirrorMakerTemplate instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withDeployment(instance.getDeployment());
        
        this.withPod(instance.getPod());
        
        this.withPodDisruptionBudget(instance.getPodDisruptionBudget());
        
        this.withMirrorMakerContainer(instance.getMirrorMakerContainer());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaMirrorMakerTemplate build() {
        KafkaMirrorMakerTemplate buildable = new KafkaMirrorMakerTemplate();
        buildable.setDeployment(fluent.getDeployment());
        buildable.setPod(fluent.getPod());
        buildable.setPodDisruptionBudget(fluent.getPodDisruptionBudget());
        buildable.setMirrorMakerContainer(fluent.getMirrorMakerContainer());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaMirrorMakerTemplateBuilder that = (KafkaMirrorMakerTemplateBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
