package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;

public class KafkaExporterTemplateFluentImpl<A extends KafkaExporterTemplateFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KafkaExporterTemplateFluent<A> {

    private ResourceTemplateBuilder deployment;
    private PodTemplateBuilder pod;
    private ResourceTemplateBuilder service;
    private ContainerTemplateBuilder container;

    public KafkaExporterTemplateFluentImpl() {
    }

    public KafkaExporterTemplateFluentImpl(KafkaExporterTemplate instance) {
        this.withDeployment(instance.getDeployment());
        
        this.withPod(instance.getPod());
        
        this.withService(instance.getService());
        
        this.withContainer(instance.getContainer());
    }

    
/**
 * This method has been deprecated, please use method buildDeployment instead.
 * @return The buildable object.
 */
@Deprecated public ResourceTemplate getDeployment() {
        return this.deployment!=null?this.deployment.build():null;
    }

    public ResourceTemplate buildDeployment() {
        return this.deployment!=null?this.deployment.build():null;
    }

    public A withDeployment(ResourceTemplate deployment) {
        _visitables.get("deployment").remove(this.deployment);
        if (deployment!=null){ this.deployment= new ResourceTemplateBuilder(deployment); _visitables.get("deployment").add(this.deployment);} return (A) this;
    }

    public Boolean hasDeployment() {
        return this.deployment != null;
    }

    public KafkaExporterTemplateFluent.DeploymentNested<A> withNewDeployment() {
        return new DeploymentNestedImpl();
    }

    public KafkaExporterTemplateFluent.DeploymentNested<A> withNewDeploymentLike(ResourceTemplate item) {
        return new DeploymentNestedImpl(item);
    }

    public KafkaExporterTemplateFluent.DeploymentNested<A> editDeployment() {
        return withNewDeploymentLike(getDeployment());
    }

    public KafkaExporterTemplateFluent.DeploymentNested<A> editOrNewDeployment() {
        return withNewDeploymentLike(getDeployment() != null ? getDeployment(): new ResourceTemplateBuilder().build());
    }

    public KafkaExporterTemplateFluent.DeploymentNested<A> editOrNewDeploymentLike(ResourceTemplate item) {
        return withNewDeploymentLike(getDeployment() != null ? getDeployment(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPod instead.
 * @return The buildable object.
 */
@Deprecated public PodTemplate getPod() {
        return this.pod!=null?this.pod.build():null;
    }

    public PodTemplate buildPod() {
        return this.pod!=null?this.pod.build():null;
    }

    public A withPod(PodTemplate pod) {
        _visitables.get("pod").remove(this.pod);
        if (pod!=null){ this.pod= new PodTemplateBuilder(pod); _visitables.get("pod").add(this.pod);} return (A) this;
    }

    public Boolean hasPod() {
        return this.pod != null;
    }

    public KafkaExporterTemplateFluent.PodNested<A> withNewPod() {
        return new PodNestedImpl();
    }

    public KafkaExporterTemplateFluent.PodNested<A> withNewPodLike(PodTemplate item) {
        return new PodNestedImpl(item);
    }

    public KafkaExporterTemplateFluent.PodNested<A> editPod() {
        return withNewPodLike(getPod());
    }

    public KafkaExporterTemplateFluent.PodNested<A> editOrNewPod() {
        return withNewPodLike(getPod() != null ? getPod(): new PodTemplateBuilder().build());
    }

    public KafkaExporterTemplateFluent.PodNested<A> editOrNewPodLike(PodTemplate item) {
        return withNewPodLike(getPod() != null ? getPod(): item);
    }

    
/**
 * This method has been deprecated, please use method buildService instead.
 * @return The buildable object.
 */
@Deprecated public ResourceTemplate getService() {
        return this.service!=null?this.service.build():null;
    }

    public ResourceTemplate buildService() {
        return this.service!=null?this.service.build():null;
    }

    public A withService(ResourceTemplate service) {
        _visitables.get("service").remove(this.service);
        if (service!=null){ this.service= new ResourceTemplateBuilder(service); _visitables.get("service").add(this.service);} return (A) this;
    }

    public Boolean hasService() {
        return this.service != null;
    }

    public KafkaExporterTemplateFluent.ServiceNested<A> withNewService() {
        return new ServiceNestedImpl();
    }

    public KafkaExporterTemplateFluent.ServiceNested<A> withNewServiceLike(ResourceTemplate item) {
        return new ServiceNestedImpl(item);
    }

    public KafkaExporterTemplateFluent.ServiceNested<A> editService() {
        return withNewServiceLike(getService());
    }

    public KafkaExporterTemplateFluent.ServiceNested<A> editOrNewService() {
        return withNewServiceLike(getService() != null ? getService(): new ResourceTemplateBuilder().build());
    }

    public KafkaExporterTemplateFluent.ServiceNested<A> editOrNewServiceLike(ResourceTemplate item) {
        return withNewServiceLike(getService() != null ? getService(): item);
    }

    
/**
 * This method has been deprecated, please use method buildContainer instead.
 * @return The buildable object.
 */
@Deprecated public ContainerTemplate getContainer() {
        return this.container!=null?this.container.build():null;
    }

    public ContainerTemplate buildContainer() {
        return this.container!=null?this.container.build():null;
    }

    public A withContainer(ContainerTemplate container) {
        _visitables.get("container").remove(this.container);
        if (container!=null){ this.container= new ContainerTemplateBuilder(container); _visitables.get("container").add(this.container);} return (A) this;
    }

    public Boolean hasContainer() {
        return this.container != null;
    }

    public KafkaExporterTemplateFluent.ContainerNested<A> withNewContainer() {
        return new ContainerNestedImpl();
    }

    public KafkaExporterTemplateFluent.ContainerNested<A> withNewContainerLike(ContainerTemplate item) {
        return new ContainerNestedImpl(item);
    }

    public KafkaExporterTemplateFluent.ContainerNested<A> editContainer() {
        return withNewContainerLike(getContainer());
    }

    public KafkaExporterTemplateFluent.ContainerNested<A> editOrNewContainer() {
        return withNewContainerLike(getContainer() != null ? getContainer(): new ContainerTemplateBuilder().build());
    }

    public KafkaExporterTemplateFluent.ContainerNested<A> editOrNewContainerLike(ContainerTemplate item) {
        return withNewContainerLike(getContainer() != null ? getContainer(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KafkaExporterTemplateFluentImpl that = (KafkaExporterTemplateFluentImpl) o;
        if (deployment != null ? !deployment.equals(that.deployment) :that.deployment != null) return false;
        if (pod != null ? !pod.equals(that.pod) :that.pod != null) return false;
        if (service != null ? !service.equals(that.service) :that.service != null) return false;
        if (container != null ? !container.equals(that.container) :that.container != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(deployment,  pod,  service,  container,  super.hashCode());
    }

    public class DeploymentNestedImpl<N> extends ResourceTemplateFluentImpl<KafkaExporterTemplateFluent.DeploymentNested<N>> implements KafkaExporterTemplateFluent.DeploymentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ResourceTemplateBuilder builder;

            DeploymentNestedImpl(ResourceTemplate item) {
                this.builder = new ResourceTemplateBuilder(this, item);
                        
            }

            DeploymentNestedImpl() {
                this.builder = new ResourceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaExporterTemplateFluentImpl.this.withDeployment(builder.build());
            }

            public N endDeployment() {
                return and();
            }
    }


    public class PodNestedImpl<N> extends PodTemplateFluentImpl<KafkaExporterTemplateFluent.PodNested<N>> implements KafkaExporterTemplateFluent.PodNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PodTemplateBuilder builder;

            PodNestedImpl(PodTemplate item) {
                this.builder = new PodTemplateBuilder(this, item);
                        
            }

            PodNestedImpl() {
                this.builder = new PodTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaExporterTemplateFluentImpl.this.withPod(builder.build());
            }

            public N endPod() {
                return and();
            }
    }


    public class ServiceNestedImpl<N> extends ResourceTemplateFluentImpl<KafkaExporterTemplateFluent.ServiceNested<N>> implements KafkaExporterTemplateFluent.ServiceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ResourceTemplateBuilder builder;

            ServiceNestedImpl(ResourceTemplate item) {
                this.builder = new ResourceTemplateBuilder(this, item);
                        
            }

            ServiceNestedImpl() {
                this.builder = new ResourceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaExporterTemplateFluentImpl.this.withService(builder.build());
            }

            public N endService() {
                return and();
            }
    }


    public class ContainerNestedImpl<N> extends ContainerTemplateFluentImpl<KafkaExporterTemplateFluent.ContainerNested<N>> implements KafkaExporterTemplateFluent.ContainerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ContainerTemplateBuilder builder;

            ContainerNestedImpl(ContainerTemplate item) {
                this.builder = new ContainerTemplateBuilder(this, item);
                        
            }

            ContainerNestedImpl() {
                this.builder = new ContainerTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaExporterTemplateFluentImpl.this.withContainer(builder.build());
            }

            public N endContainer() {
                return and();
            }
    }


}
