package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;

public class KafkaClusterTemplateFluentImpl<A extends KafkaClusterTemplateFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KafkaClusterTemplateFluent<A> {

    private StatefulSetTemplateBuilder statefulset;
    private PodTemplateBuilder pod;
    private InternalServiceTemplateBuilder bootstrapService;
    private InternalServiceTemplateBuilder brokersService;
    private ExternalServiceTemplateBuilder externalBootstrapService;
    private ExternalServiceTemplateBuilder perPodService;
    private ResourceTemplateBuilder externalBootstrapRoute;
    private ResourceTemplateBuilder perPodRoute;
    private ResourceTemplateBuilder externalBootstrapIngress;
    private ResourceTemplateBuilder perPodIngress;
    private ResourceTemplateBuilder persistentVolumeClaim;
    private ResourceTemplateBuilder clusterCaCert;
    private PodDisruptionBudgetTemplateBuilder podDisruptionBudget;
    private ContainerTemplateBuilder kafkaContainer;
    private ContainerTemplateBuilder tlsSidecarContainer;
    private ContainerTemplateBuilder initContainer;
    private ResourceTemplateBuilder clusterRoleBinding;

    public KafkaClusterTemplateFluentImpl() {
    }

    public KafkaClusterTemplateFluentImpl(KafkaClusterTemplate instance) {
        this.withStatefulset(instance.getStatefulset());
        
        this.withPod(instance.getPod());
        
        this.withBootstrapService(instance.getBootstrapService());
        
        this.withBrokersService(instance.getBrokersService());
        
        this.withExternalBootstrapService(instance.getExternalBootstrapService());
        
        this.withPerPodService(instance.getPerPodService());
        
        this.withExternalBootstrapRoute(instance.getExternalBootstrapRoute());
        
        this.withPerPodRoute(instance.getPerPodRoute());
        
        this.withExternalBootstrapIngress(instance.getExternalBootstrapIngress());
        
        this.withPerPodIngress(instance.getPerPodIngress());
        
        this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
        
        this.withClusterCaCert(instance.getClusterCaCert());
        
        this.withPodDisruptionBudget(instance.getPodDisruptionBudget());
        
        this.withKafkaContainer(instance.getKafkaContainer());
        
        this.withTlsSidecarContainer(instance.getTlsSidecarContainer());
        
        this.withInitContainer(instance.getInitContainer());
        
        this.withClusterRoleBinding(instance.getClusterRoleBinding());
    }

    
/**
 * This method has been deprecated, please use method buildStatefulset instead.
 * @return The buildable object.
 */
@Deprecated public StatefulSetTemplate getStatefulset() {
        return this.statefulset!=null?this.statefulset.build():null;
    }

    public StatefulSetTemplate buildStatefulset() {
        return this.statefulset!=null?this.statefulset.build():null;
    }

    public A withStatefulset(StatefulSetTemplate statefulset) {
        _visitables.get("statefulset").remove(this.statefulset);
        if (statefulset!=null){ this.statefulset= new StatefulSetTemplateBuilder(statefulset); _visitables.get("statefulset").add(this.statefulset);} return (A) this;
    }

    public Boolean hasStatefulset() {
        return this.statefulset != null;
    }

    public KafkaClusterTemplateFluent.StatefulsetNested<A> withNewStatefulset() {
        return new StatefulsetNestedImpl();
    }

    public KafkaClusterTemplateFluent.StatefulsetNested<A> withNewStatefulsetLike(StatefulSetTemplate item) {
        return new StatefulsetNestedImpl(item);
    }

    public KafkaClusterTemplateFluent.StatefulsetNested<A> editStatefulset() {
        return withNewStatefulsetLike(getStatefulset());
    }

    public KafkaClusterTemplateFluent.StatefulsetNested<A> editOrNewStatefulset() {
        return withNewStatefulsetLike(getStatefulset() != null ? getStatefulset(): new StatefulSetTemplateBuilder().build());
    }

    public KafkaClusterTemplateFluent.StatefulsetNested<A> editOrNewStatefulsetLike(StatefulSetTemplate item) {
        return withNewStatefulsetLike(getStatefulset() != null ? getStatefulset(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPod instead.
 * @return The buildable object.
 */
@Deprecated public PodTemplate getPod() {
        return this.pod!=null?this.pod.build():null;
    }

    public PodTemplate buildPod() {
        return this.pod!=null?this.pod.build():null;
    }

    public A withPod(PodTemplate pod) {
        _visitables.get("pod").remove(this.pod);
        if (pod!=null){ this.pod= new PodTemplateBuilder(pod); _visitables.get("pod").add(this.pod);} return (A) this;
    }

    public Boolean hasPod() {
        return this.pod != null;
    }

    public KafkaClusterTemplateFluent.PodNested<A> withNewPod() {
        return new PodNestedImpl();
    }

    public KafkaClusterTemplateFluent.PodNested<A> withNewPodLike(PodTemplate item) {
        return new PodNestedImpl(item);
    }

    public KafkaClusterTemplateFluent.PodNested<A> editPod() {
        return withNewPodLike(getPod());
    }

    public KafkaClusterTemplateFluent.PodNested<A> editOrNewPod() {
        return withNewPodLike(getPod() != null ? getPod(): new PodTemplateBuilder().build());
    }

    public KafkaClusterTemplateFluent.PodNested<A> editOrNewPodLike(PodTemplate item) {
        return withNewPodLike(getPod() != null ? getPod(): item);
    }

    
/**
 * This method has been deprecated, please use method buildBootstrapService instead.
 * @return The buildable object.
 */
@Deprecated public InternalServiceTemplate getBootstrapService() {
        return this.bootstrapService!=null?this.bootstrapService.build():null;
    }

    public InternalServiceTemplate buildBootstrapService() {
        return this.bootstrapService!=null?this.bootstrapService.build():null;
    }

    public A withBootstrapService(InternalServiceTemplate bootstrapService) {
        _visitables.get("bootstrapService").remove(this.bootstrapService);
        if (bootstrapService!=null){ this.bootstrapService= new InternalServiceTemplateBuilder(bootstrapService); _visitables.get("bootstrapService").add(this.bootstrapService);} return (A) this;
    }

    public Boolean hasBootstrapService() {
        return this.bootstrapService != null;
    }

    public KafkaClusterTemplateFluent.BootstrapServiceNested<A> withNewBootstrapService() {
        return new BootstrapServiceNestedImpl();
    }

    public KafkaClusterTemplateFluent.BootstrapServiceNested<A> withNewBootstrapServiceLike(InternalServiceTemplate item) {
        return new BootstrapServiceNestedImpl(item);
    }

    public KafkaClusterTemplateFluent.BootstrapServiceNested<A> editBootstrapService() {
        return withNewBootstrapServiceLike(getBootstrapService());
    }

    public KafkaClusterTemplateFluent.BootstrapServiceNested<A> editOrNewBootstrapService() {
        return withNewBootstrapServiceLike(getBootstrapService() != null ? getBootstrapService(): new InternalServiceTemplateBuilder().build());
    }

    public KafkaClusterTemplateFluent.BootstrapServiceNested<A> editOrNewBootstrapServiceLike(InternalServiceTemplate item) {
        return withNewBootstrapServiceLike(getBootstrapService() != null ? getBootstrapService(): item);
    }

    
/**
 * This method has been deprecated, please use method buildBrokersService instead.
 * @return The buildable object.
 */
@Deprecated public InternalServiceTemplate getBrokersService() {
        return this.brokersService!=null?this.brokersService.build():null;
    }

    public InternalServiceTemplate buildBrokersService() {
        return this.brokersService!=null?this.brokersService.build():null;
    }

    public A withBrokersService(InternalServiceTemplate brokersService) {
        _visitables.get("brokersService").remove(this.brokersService);
        if (brokersService!=null){ this.brokersService= new InternalServiceTemplateBuilder(brokersService); _visitables.get("brokersService").add(this.brokersService);} return (A) this;
    }

    public Boolean hasBrokersService() {
        return this.brokersService != null;
    }

    public KafkaClusterTemplateFluent.BrokersServiceNested<A> withNewBrokersService() {
        return new BrokersServiceNestedImpl();
    }

    public KafkaClusterTemplateFluent.BrokersServiceNested<A> withNewBrokersServiceLike(InternalServiceTemplate item) {
        return new BrokersServiceNestedImpl(item);
    }

    public KafkaClusterTemplateFluent.BrokersServiceNested<A> editBrokersService() {
        return withNewBrokersServiceLike(getBrokersService());
    }

    public KafkaClusterTemplateFluent.BrokersServiceNested<A> editOrNewBrokersService() {
        return withNewBrokersServiceLike(getBrokersService() != null ? getBrokersService(): new InternalServiceTemplateBuilder().build());
    }

    public KafkaClusterTemplateFluent.BrokersServiceNested<A> editOrNewBrokersServiceLike(InternalServiceTemplate item) {
        return withNewBrokersServiceLike(getBrokersService() != null ? getBrokersService(): item);
    }

    
/**
 * This method has been deprecated, please use method buildExternalBootstrapService instead.
 * @return The buildable object.
 */
@Deprecated public ExternalServiceTemplate getExternalBootstrapService() {
        return this.externalBootstrapService!=null?this.externalBootstrapService.build():null;
    }

    public ExternalServiceTemplate buildExternalBootstrapService() {
        return this.externalBootstrapService!=null?this.externalBootstrapService.build():null;
    }

    public A withExternalBootstrapService(ExternalServiceTemplate externalBootstrapService) {
        _visitables.get("externalBootstrapService").remove(this.externalBootstrapService);
        if (externalBootstrapService!=null){ this.externalBootstrapService= new ExternalServiceTemplateBuilder(externalBootstrapService); _visitables.get("externalBootstrapService").add(this.externalBootstrapService);} return (A) this;
    }

    public Boolean hasExternalBootstrapService() {
        return this.externalBootstrapService != null;
    }

    public KafkaClusterTemplateFluent.ExternalBootstrapServiceNested<A> withNewExternalBootstrapService() {
        return new ExternalBootstrapServiceNestedImpl();
    }

    public KafkaClusterTemplateFluent.ExternalBootstrapServiceNested<A> withNewExternalBootstrapServiceLike(ExternalServiceTemplate item) {
        return new ExternalBootstrapServiceNestedImpl(item);
    }

    public KafkaClusterTemplateFluent.ExternalBootstrapServiceNested<A> editExternalBootstrapService() {
        return withNewExternalBootstrapServiceLike(getExternalBootstrapService());
    }

    public KafkaClusterTemplateFluent.ExternalBootstrapServiceNested<A> editOrNewExternalBootstrapService() {
        return withNewExternalBootstrapServiceLike(getExternalBootstrapService() != null ? getExternalBootstrapService(): new ExternalServiceTemplateBuilder().build());
    }

    public KafkaClusterTemplateFluent.ExternalBootstrapServiceNested<A> editOrNewExternalBootstrapServiceLike(ExternalServiceTemplate item) {
        return withNewExternalBootstrapServiceLike(getExternalBootstrapService() != null ? getExternalBootstrapService(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPerPodService instead.
 * @return The buildable object.
 */
@Deprecated public ExternalServiceTemplate getPerPodService() {
        return this.perPodService!=null?this.perPodService.build():null;
    }

    public ExternalServiceTemplate buildPerPodService() {
        return this.perPodService!=null?this.perPodService.build():null;
    }

    public A withPerPodService(ExternalServiceTemplate perPodService) {
        _visitables.get("perPodService").remove(this.perPodService);
        if (perPodService!=null){ this.perPodService= new ExternalServiceTemplateBuilder(perPodService); _visitables.get("perPodService").add(this.perPodService);} return (A) this;
    }

    public Boolean hasPerPodService() {
        return this.perPodService != null;
    }

    public KafkaClusterTemplateFluent.PerPodServiceNested<A> withNewPerPodService() {
        return new PerPodServiceNestedImpl();
    }

    public KafkaClusterTemplateFluent.PerPodServiceNested<A> withNewPerPodServiceLike(ExternalServiceTemplate item) {
        return new PerPodServiceNestedImpl(item);
    }

    public KafkaClusterTemplateFluent.PerPodServiceNested<A> editPerPodService() {
        return withNewPerPodServiceLike(getPerPodService());
    }

    public KafkaClusterTemplateFluent.PerPodServiceNested<A> editOrNewPerPodService() {
        return withNewPerPodServiceLike(getPerPodService() != null ? getPerPodService(): new ExternalServiceTemplateBuilder().build());
    }

    public KafkaClusterTemplateFluent.PerPodServiceNested<A> editOrNewPerPodServiceLike(ExternalServiceTemplate item) {
        return withNewPerPodServiceLike(getPerPodService() != null ? getPerPodService(): item);
    }

    
/**
 * This method has been deprecated, please use method buildExternalBootstrapRoute instead.
 * @return The buildable object.
 */
@Deprecated public ResourceTemplate getExternalBootstrapRoute() {
        return this.externalBootstrapRoute!=null?this.externalBootstrapRoute.build():null;
    }

    public ResourceTemplate buildExternalBootstrapRoute() {
        return this.externalBootstrapRoute!=null?this.externalBootstrapRoute.build():null;
    }

    public A withExternalBootstrapRoute(ResourceTemplate externalBootstrapRoute) {
        _visitables.get("externalBootstrapRoute").remove(this.externalBootstrapRoute);
        if (externalBootstrapRoute!=null){ this.externalBootstrapRoute= new ResourceTemplateBuilder(externalBootstrapRoute); _visitables.get("externalBootstrapRoute").add(this.externalBootstrapRoute);} return (A) this;
    }

    public Boolean hasExternalBootstrapRoute() {
        return this.externalBootstrapRoute != null;
    }

    public KafkaClusterTemplateFluent.ExternalBootstrapRouteNested<A> withNewExternalBootstrapRoute() {
        return new ExternalBootstrapRouteNestedImpl();
    }

    public KafkaClusterTemplateFluent.ExternalBootstrapRouteNested<A> withNewExternalBootstrapRouteLike(ResourceTemplate item) {
        return new ExternalBootstrapRouteNestedImpl(item);
    }

    public KafkaClusterTemplateFluent.ExternalBootstrapRouteNested<A> editExternalBootstrapRoute() {
        return withNewExternalBootstrapRouteLike(getExternalBootstrapRoute());
    }

    public KafkaClusterTemplateFluent.ExternalBootstrapRouteNested<A> editOrNewExternalBootstrapRoute() {
        return withNewExternalBootstrapRouteLike(getExternalBootstrapRoute() != null ? getExternalBootstrapRoute(): new ResourceTemplateBuilder().build());
    }

    public KafkaClusterTemplateFluent.ExternalBootstrapRouteNested<A> editOrNewExternalBootstrapRouteLike(ResourceTemplate item) {
        return withNewExternalBootstrapRouteLike(getExternalBootstrapRoute() != null ? getExternalBootstrapRoute(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPerPodRoute instead.
 * @return The buildable object.
 */
@Deprecated public ResourceTemplate getPerPodRoute() {
        return this.perPodRoute!=null?this.perPodRoute.build():null;
    }

    public ResourceTemplate buildPerPodRoute() {
        return this.perPodRoute!=null?this.perPodRoute.build():null;
    }

    public A withPerPodRoute(ResourceTemplate perPodRoute) {
        _visitables.get("perPodRoute").remove(this.perPodRoute);
        if (perPodRoute!=null){ this.perPodRoute= new ResourceTemplateBuilder(perPodRoute); _visitables.get("perPodRoute").add(this.perPodRoute);} return (A) this;
    }

    public Boolean hasPerPodRoute() {
        return this.perPodRoute != null;
    }

    public KafkaClusterTemplateFluent.PerPodRouteNested<A> withNewPerPodRoute() {
        return new PerPodRouteNestedImpl();
    }

    public KafkaClusterTemplateFluent.PerPodRouteNested<A> withNewPerPodRouteLike(ResourceTemplate item) {
        return new PerPodRouteNestedImpl(item);
    }

    public KafkaClusterTemplateFluent.PerPodRouteNested<A> editPerPodRoute() {
        return withNewPerPodRouteLike(getPerPodRoute());
    }

    public KafkaClusterTemplateFluent.PerPodRouteNested<A> editOrNewPerPodRoute() {
        return withNewPerPodRouteLike(getPerPodRoute() != null ? getPerPodRoute(): new ResourceTemplateBuilder().build());
    }

    public KafkaClusterTemplateFluent.PerPodRouteNested<A> editOrNewPerPodRouteLike(ResourceTemplate item) {
        return withNewPerPodRouteLike(getPerPodRoute() != null ? getPerPodRoute(): item);
    }

    
/**
 * This method has been deprecated, please use method buildExternalBootstrapIngress instead.
 * @return The buildable object.
 */
@Deprecated public ResourceTemplate getExternalBootstrapIngress() {
        return this.externalBootstrapIngress!=null?this.externalBootstrapIngress.build():null;
    }

    public ResourceTemplate buildExternalBootstrapIngress() {
        return this.externalBootstrapIngress!=null?this.externalBootstrapIngress.build():null;
    }

    public A withExternalBootstrapIngress(ResourceTemplate externalBootstrapIngress) {
        _visitables.get("externalBootstrapIngress").remove(this.externalBootstrapIngress);
        if (externalBootstrapIngress!=null){ this.externalBootstrapIngress= new ResourceTemplateBuilder(externalBootstrapIngress); _visitables.get("externalBootstrapIngress").add(this.externalBootstrapIngress);} return (A) this;
    }

    public Boolean hasExternalBootstrapIngress() {
        return this.externalBootstrapIngress != null;
    }

    public KafkaClusterTemplateFluent.ExternalBootstrapIngressNested<A> withNewExternalBootstrapIngress() {
        return new ExternalBootstrapIngressNestedImpl();
    }

    public KafkaClusterTemplateFluent.ExternalBootstrapIngressNested<A> withNewExternalBootstrapIngressLike(ResourceTemplate item) {
        return new ExternalBootstrapIngressNestedImpl(item);
    }

    public KafkaClusterTemplateFluent.ExternalBootstrapIngressNested<A> editExternalBootstrapIngress() {
        return withNewExternalBootstrapIngressLike(getExternalBootstrapIngress());
    }

    public KafkaClusterTemplateFluent.ExternalBootstrapIngressNested<A> editOrNewExternalBootstrapIngress() {
        return withNewExternalBootstrapIngressLike(getExternalBootstrapIngress() != null ? getExternalBootstrapIngress(): new ResourceTemplateBuilder().build());
    }

    public KafkaClusterTemplateFluent.ExternalBootstrapIngressNested<A> editOrNewExternalBootstrapIngressLike(ResourceTemplate item) {
        return withNewExternalBootstrapIngressLike(getExternalBootstrapIngress() != null ? getExternalBootstrapIngress(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPerPodIngress instead.
 * @return The buildable object.
 */
@Deprecated public ResourceTemplate getPerPodIngress() {
        return this.perPodIngress!=null?this.perPodIngress.build():null;
    }

    public ResourceTemplate buildPerPodIngress() {
        return this.perPodIngress!=null?this.perPodIngress.build():null;
    }

    public A withPerPodIngress(ResourceTemplate perPodIngress) {
        _visitables.get("perPodIngress").remove(this.perPodIngress);
        if (perPodIngress!=null){ this.perPodIngress= new ResourceTemplateBuilder(perPodIngress); _visitables.get("perPodIngress").add(this.perPodIngress);} return (A) this;
    }

    public Boolean hasPerPodIngress() {
        return this.perPodIngress != null;
    }

    public KafkaClusterTemplateFluent.PerPodIngressNested<A> withNewPerPodIngress() {
        return new PerPodIngressNestedImpl();
    }

    public KafkaClusterTemplateFluent.PerPodIngressNested<A> withNewPerPodIngressLike(ResourceTemplate item) {
        return new PerPodIngressNestedImpl(item);
    }

    public KafkaClusterTemplateFluent.PerPodIngressNested<A> editPerPodIngress() {
        return withNewPerPodIngressLike(getPerPodIngress());
    }

    public KafkaClusterTemplateFluent.PerPodIngressNested<A> editOrNewPerPodIngress() {
        return withNewPerPodIngressLike(getPerPodIngress() != null ? getPerPodIngress(): new ResourceTemplateBuilder().build());
    }

    public KafkaClusterTemplateFluent.PerPodIngressNested<A> editOrNewPerPodIngressLike(ResourceTemplate item) {
        return withNewPerPodIngressLike(getPerPodIngress() != null ? getPerPodIngress(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPersistentVolumeClaim instead.
 * @return The buildable object.
 */
@Deprecated public ResourceTemplate getPersistentVolumeClaim() {
        return this.persistentVolumeClaim!=null?this.persistentVolumeClaim.build():null;
    }

    public ResourceTemplate buildPersistentVolumeClaim() {
        return this.persistentVolumeClaim!=null?this.persistentVolumeClaim.build():null;
    }

    public A withPersistentVolumeClaim(ResourceTemplate persistentVolumeClaim) {
        _visitables.get("persistentVolumeClaim").remove(this.persistentVolumeClaim);
        if (persistentVolumeClaim!=null){ this.persistentVolumeClaim= new ResourceTemplateBuilder(persistentVolumeClaim); _visitables.get("persistentVolumeClaim").add(this.persistentVolumeClaim);} return (A) this;
    }

    public Boolean hasPersistentVolumeClaim() {
        return this.persistentVolumeClaim != null;
    }

    public KafkaClusterTemplateFluent.PersistentVolumeClaimNested<A> withNewPersistentVolumeClaim() {
        return new PersistentVolumeClaimNestedImpl();
    }

    public KafkaClusterTemplateFluent.PersistentVolumeClaimNested<A> withNewPersistentVolumeClaimLike(ResourceTemplate item) {
        return new PersistentVolumeClaimNestedImpl(item);
    }

    public KafkaClusterTemplateFluent.PersistentVolumeClaimNested<A> editPersistentVolumeClaim() {
        return withNewPersistentVolumeClaimLike(getPersistentVolumeClaim());
    }

    public KafkaClusterTemplateFluent.PersistentVolumeClaimNested<A> editOrNewPersistentVolumeClaim() {
        return withNewPersistentVolumeClaimLike(getPersistentVolumeClaim() != null ? getPersistentVolumeClaim(): new ResourceTemplateBuilder().build());
    }

    public KafkaClusterTemplateFluent.PersistentVolumeClaimNested<A> editOrNewPersistentVolumeClaimLike(ResourceTemplate item) {
        return withNewPersistentVolumeClaimLike(getPersistentVolumeClaim() != null ? getPersistentVolumeClaim(): item);
    }

    
/**
 * This method has been deprecated, please use method buildClusterCaCert instead.
 * @return The buildable object.
 */
@Deprecated public ResourceTemplate getClusterCaCert() {
        return this.clusterCaCert!=null?this.clusterCaCert.build():null;
    }

    public ResourceTemplate buildClusterCaCert() {
        return this.clusterCaCert!=null?this.clusterCaCert.build():null;
    }

    public A withClusterCaCert(ResourceTemplate clusterCaCert) {
        _visitables.get("clusterCaCert").remove(this.clusterCaCert);
        if (clusterCaCert!=null){ this.clusterCaCert= new ResourceTemplateBuilder(clusterCaCert); _visitables.get("clusterCaCert").add(this.clusterCaCert);} return (A) this;
    }

    public Boolean hasClusterCaCert() {
        return this.clusterCaCert != null;
    }

    public KafkaClusterTemplateFluent.ClusterCaCertNested<A> withNewClusterCaCert() {
        return new ClusterCaCertNestedImpl();
    }

    public KafkaClusterTemplateFluent.ClusterCaCertNested<A> withNewClusterCaCertLike(ResourceTemplate item) {
        return new ClusterCaCertNestedImpl(item);
    }

    public KafkaClusterTemplateFluent.ClusterCaCertNested<A> editClusterCaCert() {
        return withNewClusterCaCertLike(getClusterCaCert());
    }

    public KafkaClusterTemplateFluent.ClusterCaCertNested<A> editOrNewClusterCaCert() {
        return withNewClusterCaCertLike(getClusterCaCert() != null ? getClusterCaCert(): new ResourceTemplateBuilder().build());
    }

    public KafkaClusterTemplateFluent.ClusterCaCertNested<A> editOrNewClusterCaCertLike(ResourceTemplate item) {
        return withNewClusterCaCertLike(getClusterCaCert() != null ? getClusterCaCert(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPodDisruptionBudget instead.
 * @return The buildable object.
 */
@Deprecated public PodDisruptionBudgetTemplate getPodDisruptionBudget() {
        return this.podDisruptionBudget!=null?this.podDisruptionBudget.build():null;
    }

    public PodDisruptionBudgetTemplate buildPodDisruptionBudget() {
        return this.podDisruptionBudget!=null?this.podDisruptionBudget.build():null;
    }

    public A withPodDisruptionBudget(PodDisruptionBudgetTemplate podDisruptionBudget) {
        _visitables.get("podDisruptionBudget").remove(this.podDisruptionBudget);
        if (podDisruptionBudget!=null){ this.podDisruptionBudget= new PodDisruptionBudgetTemplateBuilder(podDisruptionBudget); _visitables.get("podDisruptionBudget").add(this.podDisruptionBudget);} return (A) this;
    }

    public Boolean hasPodDisruptionBudget() {
        return this.podDisruptionBudget != null;
    }

    public KafkaClusterTemplateFluent.PodDisruptionBudgetNested<A> withNewPodDisruptionBudget() {
        return new PodDisruptionBudgetNestedImpl();
    }

    public KafkaClusterTemplateFluent.PodDisruptionBudgetNested<A> withNewPodDisruptionBudgetLike(PodDisruptionBudgetTemplate item) {
        return new PodDisruptionBudgetNestedImpl(item);
    }

    public KafkaClusterTemplateFluent.PodDisruptionBudgetNested<A> editPodDisruptionBudget() {
        return withNewPodDisruptionBudgetLike(getPodDisruptionBudget());
    }

    public KafkaClusterTemplateFluent.PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudget() {
        return withNewPodDisruptionBudgetLike(getPodDisruptionBudget() != null ? getPodDisruptionBudget(): new PodDisruptionBudgetTemplateBuilder().build());
    }

    public KafkaClusterTemplateFluent.PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudgetLike(PodDisruptionBudgetTemplate item) {
        return withNewPodDisruptionBudgetLike(getPodDisruptionBudget() != null ? getPodDisruptionBudget(): item);
    }

    
/**
 * This method has been deprecated, please use method buildKafkaContainer instead.
 * @return The buildable object.
 */
@Deprecated public ContainerTemplate getKafkaContainer() {
        return this.kafkaContainer!=null?this.kafkaContainer.build():null;
    }

    public ContainerTemplate buildKafkaContainer() {
        return this.kafkaContainer!=null?this.kafkaContainer.build():null;
    }

    public A withKafkaContainer(ContainerTemplate kafkaContainer) {
        _visitables.get("kafkaContainer").remove(this.kafkaContainer);
        if (kafkaContainer!=null){ this.kafkaContainer= new ContainerTemplateBuilder(kafkaContainer); _visitables.get("kafkaContainer").add(this.kafkaContainer);} return (A) this;
    }

    public Boolean hasKafkaContainer() {
        return this.kafkaContainer != null;
    }

    public KafkaClusterTemplateFluent.KafkaContainerNested<A> withNewKafkaContainer() {
        return new KafkaContainerNestedImpl();
    }

    public KafkaClusterTemplateFluent.KafkaContainerNested<A> withNewKafkaContainerLike(ContainerTemplate item) {
        return new KafkaContainerNestedImpl(item);
    }

    public KafkaClusterTemplateFluent.KafkaContainerNested<A> editKafkaContainer() {
        return withNewKafkaContainerLike(getKafkaContainer());
    }

    public KafkaClusterTemplateFluent.KafkaContainerNested<A> editOrNewKafkaContainer() {
        return withNewKafkaContainerLike(getKafkaContainer() != null ? getKafkaContainer(): new ContainerTemplateBuilder().build());
    }

    public KafkaClusterTemplateFluent.KafkaContainerNested<A> editOrNewKafkaContainerLike(ContainerTemplate item) {
        return withNewKafkaContainerLike(getKafkaContainer() != null ? getKafkaContainer(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTlsSidecarContainer instead.
 * @return The buildable object.
 */
@Deprecated public ContainerTemplate getTlsSidecarContainer() {
        return this.tlsSidecarContainer!=null?this.tlsSidecarContainer.build():null;
    }

    public ContainerTemplate buildTlsSidecarContainer() {
        return this.tlsSidecarContainer!=null?this.tlsSidecarContainer.build():null;
    }

    public A withTlsSidecarContainer(ContainerTemplate tlsSidecarContainer) {
        _visitables.get("tlsSidecarContainer").remove(this.tlsSidecarContainer);
        if (tlsSidecarContainer!=null){ this.tlsSidecarContainer= new ContainerTemplateBuilder(tlsSidecarContainer); _visitables.get("tlsSidecarContainer").add(this.tlsSidecarContainer);} return (A) this;
    }

    public Boolean hasTlsSidecarContainer() {
        return this.tlsSidecarContainer != null;
    }

    public KafkaClusterTemplateFluent.TlsSidecarContainerNested<A> withNewTlsSidecarContainer() {
        return new TlsSidecarContainerNestedImpl();
    }

    public KafkaClusterTemplateFluent.TlsSidecarContainerNested<A> withNewTlsSidecarContainerLike(ContainerTemplate item) {
        return new TlsSidecarContainerNestedImpl(item);
    }

    public KafkaClusterTemplateFluent.TlsSidecarContainerNested<A> editTlsSidecarContainer() {
        return withNewTlsSidecarContainerLike(getTlsSidecarContainer());
    }

    public KafkaClusterTemplateFluent.TlsSidecarContainerNested<A> editOrNewTlsSidecarContainer() {
        return withNewTlsSidecarContainerLike(getTlsSidecarContainer() != null ? getTlsSidecarContainer(): new ContainerTemplateBuilder().build());
    }

    public KafkaClusterTemplateFluent.TlsSidecarContainerNested<A> editOrNewTlsSidecarContainerLike(ContainerTemplate item) {
        return withNewTlsSidecarContainerLike(getTlsSidecarContainer() != null ? getTlsSidecarContainer(): item);
    }

    
/**
 * This method has been deprecated, please use method buildInitContainer instead.
 * @return The buildable object.
 */
@Deprecated public ContainerTemplate getInitContainer() {
        return this.initContainer!=null?this.initContainer.build():null;
    }

    public ContainerTemplate buildInitContainer() {
        return this.initContainer!=null?this.initContainer.build():null;
    }

    public A withInitContainer(ContainerTemplate initContainer) {
        _visitables.get("initContainer").remove(this.initContainer);
        if (initContainer!=null){ this.initContainer= new ContainerTemplateBuilder(initContainer); _visitables.get("initContainer").add(this.initContainer);} return (A) this;
    }

    public Boolean hasInitContainer() {
        return this.initContainer != null;
    }

    public KafkaClusterTemplateFluent.InitContainerNested<A> withNewInitContainer() {
        return new InitContainerNestedImpl();
    }

    public KafkaClusterTemplateFluent.InitContainerNested<A> withNewInitContainerLike(ContainerTemplate item) {
        return new InitContainerNestedImpl(item);
    }

    public KafkaClusterTemplateFluent.InitContainerNested<A> editInitContainer() {
        return withNewInitContainerLike(getInitContainer());
    }

    public KafkaClusterTemplateFluent.InitContainerNested<A> editOrNewInitContainer() {
        return withNewInitContainerLike(getInitContainer() != null ? getInitContainer(): new ContainerTemplateBuilder().build());
    }

    public KafkaClusterTemplateFluent.InitContainerNested<A> editOrNewInitContainerLike(ContainerTemplate item) {
        return withNewInitContainerLike(getInitContainer() != null ? getInitContainer(): item);
    }

    
/**
 * This method has been deprecated, please use method buildClusterRoleBinding instead.
 * @return The buildable object.
 */
@Deprecated public ResourceTemplate getClusterRoleBinding() {
        return this.clusterRoleBinding!=null?this.clusterRoleBinding.build():null;
    }

    public ResourceTemplate buildClusterRoleBinding() {
        return this.clusterRoleBinding!=null?this.clusterRoleBinding.build():null;
    }

    public A withClusterRoleBinding(ResourceTemplate clusterRoleBinding) {
        _visitables.get("clusterRoleBinding").remove(this.clusterRoleBinding);
        if (clusterRoleBinding!=null){ this.clusterRoleBinding= new ResourceTemplateBuilder(clusterRoleBinding); _visitables.get("clusterRoleBinding").add(this.clusterRoleBinding);} return (A) this;
    }

    public Boolean hasClusterRoleBinding() {
        return this.clusterRoleBinding != null;
    }

    public KafkaClusterTemplateFluent.ClusterRoleBindingNested<A> withNewClusterRoleBinding() {
        return new ClusterRoleBindingNestedImpl();
    }

    public KafkaClusterTemplateFluent.ClusterRoleBindingNested<A> withNewClusterRoleBindingLike(ResourceTemplate item) {
        return new ClusterRoleBindingNestedImpl(item);
    }

    public KafkaClusterTemplateFluent.ClusterRoleBindingNested<A> editClusterRoleBinding() {
        return withNewClusterRoleBindingLike(getClusterRoleBinding());
    }

    public KafkaClusterTemplateFluent.ClusterRoleBindingNested<A> editOrNewClusterRoleBinding() {
        return withNewClusterRoleBindingLike(getClusterRoleBinding() != null ? getClusterRoleBinding(): new ResourceTemplateBuilder().build());
    }

    public KafkaClusterTemplateFluent.ClusterRoleBindingNested<A> editOrNewClusterRoleBindingLike(ResourceTemplate item) {
        return withNewClusterRoleBindingLike(getClusterRoleBinding() != null ? getClusterRoleBinding(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KafkaClusterTemplateFluentImpl that = (KafkaClusterTemplateFluentImpl) o;
        if (statefulset != null ? !statefulset.equals(that.statefulset) :that.statefulset != null) return false;
        if (pod != null ? !pod.equals(that.pod) :that.pod != null) return false;
        if (bootstrapService != null ? !bootstrapService.equals(that.bootstrapService) :that.bootstrapService != null) return false;
        if (brokersService != null ? !brokersService.equals(that.brokersService) :that.brokersService != null) return false;
        if (externalBootstrapService != null ? !externalBootstrapService.equals(that.externalBootstrapService) :that.externalBootstrapService != null) return false;
        if (perPodService != null ? !perPodService.equals(that.perPodService) :that.perPodService != null) return false;
        if (externalBootstrapRoute != null ? !externalBootstrapRoute.equals(that.externalBootstrapRoute) :that.externalBootstrapRoute != null) return false;
        if (perPodRoute != null ? !perPodRoute.equals(that.perPodRoute) :that.perPodRoute != null) return false;
        if (externalBootstrapIngress != null ? !externalBootstrapIngress.equals(that.externalBootstrapIngress) :that.externalBootstrapIngress != null) return false;
        if (perPodIngress != null ? !perPodIngress.equals(that.perPodIngress) :that.perPodIngress != null) return false;
        if (persistentVolumeClaim != null ? !persistentVolumeClaim.equals(that.persistentVolumeClaim) :that.persistentVolumeClaim != null) return false;
        if (clusterCaCert != null ? !clusterCaCert.equals(that.clusterCaCert) :that.clusterCaCert != null) return false;
        if (podDisruptionBudget != null ? !podDisruptionBudget.equals(that.podDisruptionBudget) :that.podDisruptionBudget != null) return false;
        if (kafkaContainer != null ? !kafkaContainer.equals(that.kafkaContainer) :that.kafkaContainer != null) return false;
        if (tlsSidecarContainer != null ? !tlsSidecarContainer.equals(that.tlsSidecarContainer) :that.tlsSidecarContainer != null) return false;
        if (initContainer != null ? !initContainer.equals(that.initContainer) :that.initContainer != null) return false;
        if (clusterRoleBinding != null ? !clusterRoleBinding.equals(that.clusterRoleBinding) :that.clusterRoleBinding != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(statefulset,  pod,  bootstrapService,  brokersService,  externalBootstrapService,  perPodService,  externalBootstrapRoute,  perPodRoute,  externalBootstrapIngress,  perPodIngress,  persistentVolumeClaim,  clusterCaCert,  podDisruptionBudget,  kafkaContainer,  tlsSidecarContainer,  initContainer,  clusterRoleBinding,  super.hashCode());
    }

    public class StatefulsetNestedImpl<N> extends StatefulSetTemplateFluentImpl<KafkaClusterTemplateFluent.StatefulsetNested<N>> implements KafkaClusterTemplateFluent.StatefulsetNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final StatefulSetTemplateBuilder builder;

            StatefulsetNestedImpl(StatefulSetTemplate item) {
                this.builder = new StatefulSetTemplateBuilder(this, item);
                        
            }

            StatefulsetNestedImpl() {
                this.builder = new StatefulSetTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterTemplateFluentImpl.this.withStatefulset(builder.build());
            }

            public N endStatefulset() {
                return and();
            }
    }


    public class PodNestedImpl<N> extends PodTemplateFluentImpl<KafkaClusterTemplateFluent.PodNested<N>> implements KafkaClusterTemplateFluent.PodNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PodTemplateBuilder builder;

            PodNestedImpl(PodTemplate item) {
                this.builder = new PodTemplateBuilder(this, item);
                        
            }

            PodNestedImpl() {
                this.builder = new PodTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterTemplateFluentImpl.this.withPod(builder.build());
            }

            public N endPod() {
                return and();
            }
    }


    public class BootstrapServiceNestedImpl<N> extends InternalServiceTemplateFluentImpl<KafkaClusterTemplateFluent.BootstrapServiceNested<N>> implements KafkaClusterTemplateFluent.BootstrapServiceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final InternalServiceTemplateBuilder builder;

            BootstrapServiceNestedImpl(InternalServiceTemplate item) {
                this.builder = new InternalServiceTemplateBuilder(this, item);
                        
            }

            BootstrapServiceNestedImpl() {
                this.builder = new InternalServiceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterTemplateFluentImpl.this.withBootstrapService(builder.build());
            }

            public N endBootstrapService() {
                return and();
            }
    }


    public class BrokersServiceNestedImpl<N> extends InternalServiceTemplateFluentImpl<KafkaClusterTemplateFluent.BrokersServiceNested<N>> implements KafkaClusterTemplateFluent.BrokersServiceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final InternalServiceTemplateBuilder builder;

            BrokersServiceNestedImpl(InternalServiceTemplate item) {
                this.builder = new InternalServiceTemplateBuilder(this, item);
                        
            }

            BrokersServiceNestedImpl() {
                this.builder = new InternalServiceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterTemplateFluentImpl.this.withBrokersService(builder.build());
            }

            public N endBrokersService() {
                return and();
            }
    }


    public class ExternalBootstrapServiceNestedImpl<N> extends ExternalServiceTemplateFluentImpl<KafkaClusterTemplateFluent.ExternalBootstrapServiceNested<N>> implements KafkaClusterTemplateFluent.ExternalBootstrapServiceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ExternalServiceTemplateBuilder builder;

            ExternalBootstrapServiceNestedImpl(ExternalServiceTemplate item) {
                this.builder = new ExternalServiceTemplateBuilder(this, item);
                        
            }

            ExternalBootstrapServiceNestedImpl() {
                this.builder = new ExternalServiceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterTemplateFluentImpl.this.withExternalBootstrapService(builder.build());
            }

            public N endExternalBootstrapService() {
                return and();
            }
    }


    public class PerPodServiceNestedImpl<N> extends ExternalServiceTemplateFluentImpl<KafkaClusterTemplateFluent.PerPodServiceNested<N>> implements KafkaClusterTemplateFluent.PerPodServiceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ExternalServiceTemplateBuilder builder;

            PerPodServiceNestedImpl(ExternalServiceTemplate item) {
                this.builder = new ExternalServiceTemplateBuilder(this, item);
                        
            }

            PerPodServiceNestedImpl() {
                this.builder = new ExternalServiceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterTemplateFluentImpl.this.withPerPodService(builder.build());
            }

            public N endPerPodService() {
                return and();
            }
    }


    public class ExternalBootstrapRouteNestedImpl<N> extends ResourceTemplateFluentImpl<KafkaClusterTemplateFluent.ExternalBootstrapRouteNested<N>> implements KafkaClusterTemplateFluent.ExternalBootstrapRouteNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ResourceTemplateBuilder builder;

            ExternalBootstrapRouteNestedImpl(ResourceTemplate item) {
                this.builder = new ResourceTemplateBuilder(this, item);
                        
            }

            ExternalBootstrapRouteNestedImpl() {
                this.builder = new ResourceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterTemplateFluentImpl.this.withExternalBootstrapRoute(builder.build());
            }

            public N endExternalBootstrapRoute() {
                return and();
            }
    }


    public class PerPodRouteNestedImpl<N> extends ResourceTemplateFluentImpl<KafkaClusterTemplateFluent.PerPodRouteNested<N>> implements KafkaClusterTemplateFluent.PerPodRouteNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ResourceTemplateBuilder builder;

            PerPodRouteNestedImpl(ResourceTemplate item) {
                this.builder = new ResourceTemplateBuilder(this, item);
                        
            }

            PerPodRouteNestedImpl() {
                this.builder = new ResourceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterTemplateFluentImpl.this.withPerPodRoute(builder.build());
            }

            public N endPerPodRoute() {
                return and();
            }
    }


    public class ExternalBootstrapIngressNestedImpl<N> extends ResourceTemplateFluentImpl<KafkaClusterTemplateFluent.ExternalBootstrapIngressNested<N>> implements KafkaClusterTemplateFluent.ExternalBootstrapIngressNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ResourceTemplateBuilder builder;

            ExternalBootstrapIngressNestedImpl(ResourceTemplate item) {
                this.builder = new ResourceTemplateBuilder(this, item);
                        
            }

            ExternalBootstrapIngressNestedImpl() {
                this.builder = new ResourceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterTemplateFluentImpl.this.withExternalBootstrapIngress(builder.build());
            }

            public N endExternalBootstrapIngress() {
                return and();
            }
    }


    public class PerPodIngressNestedImpl<N> extends ResourceTemplateFluentImpl<KafkaClusterTemplateFluent.PerPodIngressNested<N>> implements KafkaClusterTemplateFluent.PerPodIngressNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ResourceTemplateBuilder builder;

            PerPodIngressNestedImpl(ResourceTemplate item) {
                this.builder = new ResourceTemplateBuilder(this, item);
                        
            }

            PerPodIngressNestedImpl() {
                this.builder = new ResourceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterTemplateFluentImpl.this.withPerPodIngress(builder.build());
            }

            public N endPerPodIngress() {
                return and();
            }
    }


    public class PersistentVolumeClaimNestedImpl<N> extends ResourceTemplateFluentImpl<KafkaClusterTemplateFluent.PersistentVolumeClaimNested<N>> implements KafkaClusterTemplateFluent.PersistentVolumeClaimNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ResourceTemplateBuilder builder;

            PersistentVolumeClaimNestedImpl(ResourceTemplate item) {
                this.builder = new ResourceTemplateBuilder(this, item);
                        
            }

            PersistentVolumeClaimNestedImpl() {
                this.builder = new ResourceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterTemplateFluentImpl.this.withPersistentVolumeClaim(builder.build());
            }

            public N endPersistentVolumeClaim() {
                return and();
            }
    }


    public class ClusterCaCertNestedImpl<N> extends ResourceTemplateFluentImpl<KafkaClusterTemplateFluent.ClusterCaCertNested<N>> implements KafkaClusterTemplateFluent.ClusterCaCertNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ResourceTemplateBuilder builder;

            ClusterCaCertNestedImpl(ResourceTemplate item) {
                this.builder = new ResourceTemplateBuilder(this, item);
                        
            }

            ClusterCaCertNestedImpl() {
                this.builder = new ResourceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterTemplateFluentImpl.this.withClusterCaCert(builder.build());
            }

            public N endClusterCaCert() {
                return and();
            }
    }


    public class PodDisruptionBudgetNestedImpl<N> extends PodDisruptionBudgetTemplateFluentImpl<KafkaClusterTemplateFluent.PodDisruptionBudgetNested<N>> implements KafkaClusterTemplateFluent.PodDisruptionBudgetNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PodDisruptionBudgetTemplateBuilder builder;

            PodDisruptionBudgetNestedImpl(PodDisruptionBudgetTemplate item) {
                this.builder = new PodDisruptionBudgetTemplateBuilder(this, item);
                        
            }

            PodDisruptionBudgetNestedImpl() {
                this.builder = new PodDisruptionBudgetTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterTemplateFluentImpl.this.withPodDisruptionBudget(builder.build());
            }

            public N endPodDisruptionBudget() {
                return and();
            }
    }


    public class KafkaContainerNestedImpl<N> extends ContainerTemplateFluentImpl<KafkaClusterTemplateFluent.KafkaContainerNested<N>> implements KafkaClusterTemplateFluent.KafkaContainerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ContainerTemplateBuilder builder;

            KafkaContainerNestedImpl(ContainerTemplate item) {
                this.builder = new ContainerTemplateBuilder(this, item);
                        
            }

            KafkaContainerNestedImpl() {
                this.builder = new ContainerTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterTemplateFluentImpl.this.withKafkaContainer(builder.build());
            }

            public N endKafkaContainer() {
                return and();
            }
    }


    public class TlsSidecarContainerNestedImpl<N> extends ContainerTemplateFluentImpl<KafkaClusterTemplateFluent.TlsSidecarContainerNested<N>> implements KafkaClusterTemplateFluent.TlsSidecarContainerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ContainerTemplateBuilder builder;

            TlsSidecarContainerNestedImpl(ContainerTemplate item) {
                this.builder = new ContainerTemplateBuilder(this, item);
                        
            }

            TlsSidecarContainerNestedImpl() {
                this.builder = new ContainerTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterTemplateFluentImpl.this.withTlsSidecarContainer(builder.build());
            }

            public N endTlsSidecarContainer() {
                return and();
            }
    }


    public class InitContainerNestedImpl<N> extends ContainerTemplateFluentImpl<KafkaClusterTemplateFluent.InitContainerNested<N>> implements KafkaClusterTemplateFluent.InitContainerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ContainerTemplateBuilder builder;

            InitContainerNestedImpl(ContainerTemplate item) {
                this.builder = new ContainerTemplateBuilder(this, item);
                        
            }

            InitContainerNestedImpl() {
                this.builder = new ContainerTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterTemplateFluentImpl.this.withInitContainer(builder.build());
            }

            public N endInitContainer() {
                return and();
            }
    }


    public class ClusterRoleBindingNestedImpl<N> extends ResourceTemplateFluentImpl<KafkaClusterTemplateFluent.ClusterRoleBindingNested<N>> implements KafkaClusterTemplateFluent.ClusterRoleBindingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ResourceTemplateBuilder builder;

            ClusterRoleBindingNestedImpl(ResourceTemplate item) {
                this.builder = new ResourceTemplateBuilder(this, item);
                        
            }

            ClusterRoleBindingNestedImpl() {
                this.builder = new ResourceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterTemplateFluentImpl.this.withClusterRoleBinding(builder.build());
            }

            public N endClusterRoleBinding() {
                return and();
            }
    }


}
