package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaClusterTemplateBuilder extends KafkaClusterTemplateFluentImpl<KafkaClusterTemplateBuilder> implements VisitableBuilder<KafkaClusterTemplate,KafkaClusterTemplateBuilder> {

    KafkaClusterTemplateFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaClusterTemplateBuilder() {
        this(true);
    }

    public KafkaClusterTemplateBuilder(Boolean validationEnabled) {
        this(new KafkaClusterTemplate(), validationEnabled);
    }

    public KafkaClusterTemplateBuilder(KafkaClusterTemplateFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaClusterTemplateBuilder(KafkaClusterTemplateFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KafkaClusterTemplate(), validationEnabled);
    }

    public KafkaClusterTemplateBuilder(KafkaClusterTemplateFluent<?> fluent,KafkaClusterTemplate instance) {
        this(fluent, instance, true);
    }

    public KafkaClusterTemplateBuilder(KafkaClusterTemplateFluent<?> fluent,KafkaClusterTemplate instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withStatefulset(instance.getStatefulset());
        
        fluent.withPod(instance.getPod());
        
        fluent.withBootstrapService(instance.getBootstrapService());
        
        fluent.withBrokersService(instance.getBrokersService());
        
        fluent.withExternalBootstrapService(instance.getExternalBootstrapService());
        
        fluent.withPerPodService(instance.getPerPodService());
        
        fluent.withExternalBootstrapRoute(instance.getExternalBootstrapRoute());
        
        fluent.withPerPodRoute(instance.getPerPodRoute());
        
        fluent.withExternalBootstrapIngress(instance.getExternalBootstrapIngress());
        
        fluent.withPerPodIngress(instance.getPerPodIngress());
        
        fluent.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
        
        fluent.withClusterCaCert(instance.getClusterCaCert());
        
        fluent.withPodDisruptionBudget(instance.getPodDisruptionBudget());
        
        fluent.withKafkaContainer(instance.getKafkaContainer());
        
        fluent.withTlsSidecarContainer(instance.getTlsSidecarContainer());
        
        fluent.withInitContainer(instance.getInitContainer());
        
        fluent.withClusterRoleBinding(instance.getClusterRoleBinding());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaClusterTemplateBuilder(KafkaClusterTemplate instance) {
        this(instance,true);
    }

    public KafkaClusterTemplateBuilder(KafkaClusterTemplate instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withStatefulset(instance.getStatefulset());
        
        this.withPod(instance.getPod());
        
        this.withBootstrapService(instance.getBootstrapService());
        
        this.withBrokersService(instance.getBrokersService());
        
        this.withExternalBootstrapService(instance.getExternalBootstrapService());
        
        this.withPerPodService(instance.getPerPodService());
        
        this.withExternalBootstrapRoute(instance.getExternalBootstrapRoute());
        
        this.withPerPodRoute(instance.getPerPodRoute());
        
        this.withExternalBootstrapIngress(instance.getExternalBootstrapIngress());
        
        this.withPerPodIngress(instance.getPerPodIngress());
        
        this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
        
        this.withClusterCaCert(instance.getClusterCaCert());
        
        this.withPodDisruptionBudget(instance.getPodDisruptionBudget());
        
        this.withKafkaContainer(instance.getKafkaContainer());
        
        this.withTlsSidecarContainer(instance.getTlsSidecarContainer());
        
        this.withInitContainer(instance.getInitContainer());
        
        this.withClusterRoleBinding(instance.getClusterRoleBinding());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaClusterTemplate build() {
        KafkaClusterTemplate buildable = new KafkaClusterTemplate();
        buildable.setStatefulset(fluent.getStatefulset());
        buildable.setPod(fluent.getPod());
        buildable.setBootstrapService(fluent.getBootstrapService());
        buildable.setBrokersService(fluent.getBrokersService());
        buildable.setExternalBootstrapService(fluent.getExternalBootstrapService());
        buildable.setPerPodService(fluent.getPerPodService());
        buildable.setExternalBootstrapRoute(fluent.getExternalBootstrapRoute());
        buildable.setPerPodRoute(fluent.getPerPodRoute());
        buildable.setExternalBootstrapIngress(fluent.getExternalBootstrapIngress());
        buildable.setPerPodIngress(fluent.getPerPodIngress());
        buildable.setPersistentVolumeClaim(fluent.getPersistentVolumeClaim());
        buildable.setClusterCaCert(fluent.getClusterCaCert());
        buildable.setPodDisruptionBudget(fluent.getPodDisruptionBudget());
        buildable.setKafkaContainer(fluent.getKafkaContainer());
        buildable.setTlsSidecarContainer(fluent.getTlsSidecarContainer());
        buildable.setInitContainer(fluent.getInitContainer());
        buildable.setClusterRoleBinding(fluent.getClusterRoleBinding());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaClusterTemplateBuilder that = (KafkaClusterTemplateBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
