package io.strimzi.api.kafka.model.template;

import java.lang.StringBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class JmxTransOutputDefinitionTemplateFluentImpl<A extends JmxTransOutputDefinitionTemplateFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements JmxTransOutputDefinitionTemplateFluent<A> {

    private String outputType;
    private String host;
    private Integer port;
    private Integer flushDelayInSeconds;
    private String name;
    private java.util.List<String> typeNames;

    public JmxTransOutputDefinitionTemplateFluentImpl() {
    }

    public JmxTransOutputDefinitionTemplateFluentImpl(JmxTransOutputDefinitionTemplate instance) {
        this.withOutputType(instance.getOutputType());
        
        this.withHost(instance.getHost());
        
        this.withPort(instance.getPort());
        
        this.withFlushDelayInSeconds(instance.getFlushDelayInSeconds());
        
        this.withName(instance.getName());
        
        this.withTypeNames(instance.getTypeNames());
    }

    public String getOutputType() {
        return this.outputType;
    }

    public A withOutputType(String outputType) {
        this.outputType=outputType; return (A) this;
    }

    public Boolean hasOutputType() {
        return this.outputType != null;
    }

    public A withNewOutputType(StringBuilder arg1) {
        return (A)withOutputType(new String(arg1));
    }

    public A withNewOutputType(int[] arg1,int arg2,int arg3) {
        return (A)withOutputType(new String(arg1, arg2, arg3));
    }

    public A withNewOutputType(char[] arg1) {
        return (A)withOutputType(new String(arg1));
    }

    public A withNewOutputType(StringBuffer arg1) {
        return (A)withOutputType(new String(arg1));
    }

    public A withNewOutputType(byte[] arg1,int arg2) {
        return (A)withOutputType(new String(arg1, arg2));
    }

    public A withNewOutputType(byte[] arg1) {
        return (A)withOutputType(new String(arg1));
    }

    public A withNewOutputType(char[] arg1,int arg2,int arg3) {
        return (A)withOutputType(new String(arg1, arg2, arg3));
    }

    public A withNewOutputType(byte[] arg1,int arg2,int arg3) {
        return (A)withOutputType(new String(arg1, arg2, arg3));
    }

    public A withNewOutputType(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withOutputType(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewOutputType(String arg1) {
        return (A)withOutputType(new String(arg1));
    }

    public String getHost() {
        return this.host;
    }

    public A withHost(String host) {
        this.host=host; return (A) this;
    }

    public Boolean hasHost() {
        return this.host != null;
    }

    public A withNewHost(StringBuilder arg1) {
        return (A)withHost(new String(arg1));
    }

    public A withNewHost(int[] arg1,int arg2,int arg3) {
        return (A)withHost(new String(arg1, arg2, arg3));
    }

    public A withNewHost(char[] arg1) {
        return (A)withHost(new String(arg1));
    }

    public A withNewHost(StringBuffer arg1) {
        return (A)withHost(new String(arg1));
    }

    public A withNewHost(byte[] arg1,int arg2) {
        return (A)withHost(new String(arg1, arg2));
    }

    public A withNewHost(byte[] arg1) {
        return (A)withHost(new String(arg1));
    }

    public A withNewHost(char[] arg1,int arg2,int arg3) {
        return (A)withHost(new String(arg1, arg2, arg3));
    }

    public A withNewHost(byte[] arg1,int arg2,int arg3) {
        return (A)withHost(new String(arg1, arg2, arg3));
    }

    public A withNewHost(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withHost(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewHost(String arg1) {
        return (A)withHost(new String(arg1));
    }

    public Integer getPort() {
        return this.port;
    }

    public A withPort(Integer port) {
        this.port=port; return (A) this;
    }

    public Boolean hasPort() {
        return this.port != null;
    }

    public Integer getFlushDelayInSeconds() {
        return this.flushDelayInSeconds;
    }

    public A withFlushDelayInSeconds(Integer flushDelayInSeconds) {
        this.flushDelayInSeconds=flushDelayInSeconds; return (A) this;
    }

    public Boolean hasFlushDelayInSeconds() {
        return this.flushDelayInSeconds != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(int[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(char[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(byte[] arg1,int arg2) {
        return (A)withName(new String(arg1, arg2));
    }

    public A withNewName(byte[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(char[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public A addToTypeNames(int index,String item) {
        if (this.typeNames == null) {this.typeNames = new ArrayList<String>();}
        this.typeNames.add(index, item);
        return (A)this;
    }

    public A setToTypeNames(int index,String item) {
        if (this.typeNames == null) {this.typeNames = new ArrayList<String>();}
        this.typeNames.set(index, item); return (A)this;
    }

    public A addToTypeNames(String... items) {
        if (this.typeNames == null) {this.typeNames = new ArrayList<String>();}
        for (String item : items) {this.typeNames.add(item);} return (A)this;
    }

    public A addAllToTypeNames(Collection<String> items) {
        if (this.typeNames == null) {this.typeNames = new ArrayList<String>();}
        for (String item : items) {this.typeNames.add(item);} return (A)this;
    }

    public A removeFromTypeNames(String... items) {
        for (String item : items) {if (this.typeNames!= null){ this.typeNames.remove(item);}} return (A)this;
    }

    public A removeAllFromTypeNames(Collection<String> items) {
        for (String item : items) {if (this.typeNames!= null){ this.typeNames.remove(item);}} return (A)this;
    }

    public java.util.List<String> getTypeNames() {
        return this.typeNames;
    }

    public String getTypeName(int index) {
        return this.typeNames.get(index);
    }

    public String getFirstTypeName() {
        return this.typeNames.get(0);
    }

    public String getLastTypeName() {
        return this.typeNames.get(typeNames.size() - 1);
    }

    public String getMatchingTypeName(Predicate<String> predicate) {
        for (String item: typeNames) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingTypeName(Predicate<String> predicate) {
        for (String item: typeNames) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withTypeNames(java.util.List<String> typeNames) {
        if (this.typeNames != null) { _visitables.get("typeNames").removeAll(this.typeNames);}
        if (typeNames != null) {this.typeNames = new ArrayList<String>(); for (String item : typeNames){this.addToTypeNames(item);}} else { this.typeNames = null;} return (A) this;
    }

    public A withTypeNames(String... typeNames) {
        if (this.typeNames != null) {this.typeNames.clear();}
        if (typeNames != null) {for (String item :typeNames){ this.addToTypeNames(item);}} return (A) this;
    }

    public Boolean hasTypeNames() {
        return typeNames != null && !typeNames.isEmpty();
    }

    public A addNewTypeName(StringBuilder arg1) {
        return (A)addToTypeNames(new String(arg1));
    }

    public A addNewTypeName(int[] arg1,int arg2,int arg3) {
        return (A)addToTypeNames(new String(arg1, arg2, arg3));
    }

    public A addNewTypeName(char[] arg1) {
        return (A)addToTypeNames(new String(arg1));
    }

    public A addNewTypeName(StringBuffer arg1) {
        return (A)addToTypeNames(new String(arg1));
    }

    public A addNewTypeName(byte[] arg1,int arg2) {
        return (A)addToTypeNames(new String(arg1, arg2));
    }

    public A addNewTypeName(byte[] arg1) {
        return (A)addToTypeNames(new String(arg1));
    }

    public A addNewTypeName(char[] arg1,int arg2,int arg3) {
        return (A)addToTypeNames(new String(arg1, arg2, arg3));
    }

    public A addNewTypeName(byte[] arg1,int arg2,int arg3) {
        return (A)addToTypeNames(new String(arg1, arg2, arg3));
    }

    public A addNewTypeName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToTypeNames(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewTypeName(String arg1) {
        return (A)addToTypeNames(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        JmxTransOutputDefinitionTemplateFluentImpl that = (JmxTransOutputDefinitionTemplateFluentImpl) o;
        if (outputType != null ? !outputType.equals(that.outputType) :that.outputType != null) return false;
        if (host != null ? !host.equals(that.host) :that.host != null) return false;
        if (port != null ? !port.equals(that.port) :that.port != null) return false;
        if (flushDelayInSeconds != null ? !flushDelayInSeconds.equals(that.flushDelayInSeconds) :that.flushDelayInSeconds != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (typeNames != null ? !typeNames.equals(that.typeNames) :that.typeNames != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(outputType,  host,  port,  flushDelayInSeconds,  name,  typeNames,  super.hashCode());
    }

}
