package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class InternalServiceTemplateFluentImpl<A extends InternalServiceTemplateFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements InternalServiceTemplateFluent<A> {

    private MetadataTemplateBuilder metadata;
    private IpFamilyPolicy ipFamilyPolicy;
    private java.util.List<IpFamily> ipFamilies;

    public InternalServiceTemplateFluentImpl() {
    }

    public InternalServiceTemplateFluentImpl(InternalServiceTemplate instance) {
        this.withMetadata(instance.getMetadata());
        
        this.withIpFamilyPolicy(instance.getIpFamilyPolicy());
        
        this.withIpFamilies(instance.getIpFamilies());
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public MetadataTemplate getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public MetadataTemplate buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(MetadataTemplate metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new MetadataTemplateBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    public InternalServiceTemplateFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    public InternalServiceTemplateFluent.MetadataNested<A> withNewMetadataLike(MetadataTemplate item) {
        return new MetadataNestedImpl(item);
    }

    public InternalServiceTemplateFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public InternalServiceTemplateFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new MetadataTemplateBuilder().build());
    }

    public InternalServiceTemplateFluent.MetadataNested<A> editOrNewMetadataLike(MetadataTemplate item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public IpFamilyPolicy getIpFamilyPolicy() {
        return this.ipFamilyPolicy;
    }

    public A withIpFamilyPolicy(IpFamilyPolicy ipFamilyPolicy) {
        this.ipFamilyPolicy=ipFamilyPolicy; return (A) this;
    }

    public Boolean hasIpFamilyPolicy() {
        return this.ipFamilyPolicy != null;
    }

    public A addToIpFamilies(int index,IpFamily item) {
        if (this.ipFamilies == null) {this.ipFamilies = new ArrayList<IpFamily>();}
        this.ipFamilies.add(index, item);
        return (A)this;
    }

    public A setToIpFamilies(int index,IpFamily item) {
        if (this.ipFamilies == null) {this.ipFamilies = new ArrayList<IpFamily>();}
        this.ipFamilies.set(index, item); return (A)this;
    }

    public A addToIpFamilies(IpFamily... items) {
        if (this.ipFamilies == null) {this.ipFamilies = new ArrayList<IpFamily>();}
        for (IpFamily item : items) {this.ipFamilies.add(item);} return (A)this;
    }

    public A addAllToIpFamilies(Collection<IpFamily> items) {
        if (this.ipFamilies == null) {this.ipFamilies = new ArrayList<IpFamily>();}
        for (IpFamily item : items) {this.ipFamilies.add(item);} return (A)this;
    }

    public A removeFromIpFamilies(IpFamily... items) {
        for (IpFamily item : items) {if (this.ipFamilies!= null){ this.ipFamilies.remove(item);}} return (A)this;
    }

    public A removeAllFromIpFamilies(Collection<IpFamily> items) {
        for (IpFamily item : items) {if (this.ipFamilies!= null){ this.ipFamilies.remove(item);}} return (A)this;
    }

    public java.util.List<IpFamily> getIpFamilies() {
        return this.ipFamilies;
    }

    public IpFamily getIpFamily(int index) {
        return this.ipFamilies.get(index);
    }

    public IpFamily getFirstIpFamily() {
        return this.ipFamilies.get(0);
    }

    public IpFamily getLastIpFamily() {
        return this.ipFamilies.get(ipFamilies.size() - 1);
    }

    public IpFamily getMatchingIpFamily(Predicate<IpFamily> predicate) {
        for (IpFamily item: ipFamilies) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingIpFamily(Predicate<IpFamily> predicate) {
        for (IpFamily item: ipFamilies) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withIpFamilies(java.util.List<IpFamily> ipFamilies) {
        if (this.ipFamilies != null) { _visitables.get("ipFamilies").removeAll(this.ipFamilies);}
        if (ipFamilies != null) {this.ipFamilies = new ArrayList<IpFamily>(); for (IpFamily item : ipFamilies){this.addToIpFamilies(item);}} else { this.ipFamilies = null;} return (A) this;
    }

    public A withIpFamilies(IpFamily... ipFamilies) {
        if (this.ipFamilies != null) {this.ipFamilies.clear();}
        if (ipFamilies != null) {for (IpFamily item :ipFamilies){ this.addToIpFamilies(item);}} return (A) this;
    }

    public Boolean hasIpFamilies() {
        return ipFamilies != null && !ipFamilies.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        InternalServiceTemplateFluentImpl that = (InternalServiceTemplateFluentImpl) o;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (ipFamilyPolicy != null ? !ipFamilyPolicy.equals(that.ipFamilyPolicy) :that.ipFamilyPolicy != null) return false;
        if (ipFamilies != null ? !ipFamilies.equals(that.ipFamilies) :that.ipFamilies != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(metadata,  ipFamilyPolicy,  ipFamilies,  super.hashCode());
    }

    public class MetadataNestedImpl<N> extends MetadataTemplateFluentImpl<InternalServiceTemplateFluent.MetadataNested<N>> implements InternalServiceTemplateFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final MetadataTemplateBuilder builder;

            MetadataNestedImpl(MetadataTemplate item) {
                this.builder = new MetadataTemplateBuilder(this, item);
                        
            }

            MetadataNestedImpl() {
                this.builder = new MetadataTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) InternalServiceTemplateFluentImpl.this.withMetadata(builder.build());
            }

            public N endMetadata() {
                return and();
            }
    }


}
