package io.strimzi.api.kafka.model.template;

import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class ExternalServiceTemplateFluentImpl<A extends ExternalServiceTemplateFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ExternalServiceTemplateFluent<A> {

    private MetadataTemplateBuilder metadata;
    private ExternalTrafficPolicy externalTrafficPolicy;
    private java.util.List<String> loadBalancerSourceRanges;

    public ExternalServiceTemplateFluentImpl() {
    }

    public ExternalServiceTemplateFluentImpl(ExternalServiceTemplate instance) {
        this.withMetadata(instance.getMetadata());
        
        this.withExternalTrafficPolicy(instance.getExternalTrafficPolicy());
        
        this.withLoadBalancerSourceRanges(instance.getLoadBalancerSourceRanges());
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public MetadataTemplate getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public MetadataTemplate buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(MetadataTemplate metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new MetadataTemplateBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    public ExternalServiceTemplateFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    public ExternalServiceTemplateFluent.MetadataNested<A> withNewMetadataLike(MetadataTemplate item) {
        return new MetadataNestedImpl(item);
    }

    public ExternalServiceTemplateFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public ExternalServiceTemplateFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new MetadataTemplateBuilder().build());
    }

    public ExternalServiceTemplateFluent.MetadataNested<A> editOrNewMetadataLike(MetadataTemplate item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public ExternalTrafficPolicy getExternalTrafficPolicy() {
        return this.externalTrafficPolicy;
    }

    public A withExternalTrafficPolicy(ExternalTrafficPolicy externalTrafficPolicy) {
        this.externalTrafficPolicy=externalTrafficPolicy; return (A) this;
    }

    public Boolean hasExternalTrafficPolicy() {
        return this.externalTrafficPolicy != null;
    }

    public A addToLoadBalancerSourceRanges(int index,String item) {
        if (this.loadBalancerSourceRanges == null) {this.loadBalancerSourceRanges = new ArrayList<String>();}
        this.loadBalancerSourceRanges.add(index, item);
        return (A)this;
    }

    public A setToLoadBalancerSourceRanges(int index,String item) {
        if (this.loadBalancerSourceRanges == null) {this.loadBalancerSourceRanges = new ArrayList<String>();}
        this.loadBalancerSourceRanges.set(index, item); return (A)this;
    }

    public A addToLoadBalancerSourceRanges(String... items) {
        if (this.loadBalancerSourceRanges == null) {this.loadBalancerSourceRanges = new ArrayList<String>();}
        for (String item : items) {this.loadBalancerSourceRanges.add(item);} return (A)this;
    }

    public A addAllToLoadBalancerSourceRanges(Collection<String> items) {
        if (this.loadBalancerSourceRanges == null) {this.loadBalancerSourceRanges = new ArrayList<String>();}
        for (String item : items) {this.loadBalancerSourceRanges.add(item);} return (A)this;
    }

    public A removeFromLoadBalancerSourceRanges(String... items) {
        for (String item : items) {if (this.loadBalancerSourceRanges!= null){ this.loadBalancerSourceRanges.remove(item);}} return (A)this;
    }

    public A removeAllFromLoadBalancerSourceRanges(Collection<String> items) {
        for (String item : items) {if (this.loadBalancerSourceRanges!= null){ this.loadBalancerSourceRanges.remove(item);}} return (A)this;
    }

    public java.util.List<String> getLoadBalancerSourceRanges() {
        return this.loadBalancerSourceRanges;
    }

    public String getLoadBalancerSourceRange(int index) {
        return this.loadBalancerSourceRanges.get(index);
    }

    public String getFirstLoadBalancerSourceRange() {
        return this.loadBalancerSourceRanges.get(0);
    }

    public String getLastLoadBalancerSourceRange() {
        return this.loadBalancerSourceRanges.get(loadBalancerSourceRanges.size() - 1);
    }

    public String getMatchingLoadBalancerSourceRange(Predicate<String> predicate) {
        for (String item: loadBalancerSourceRanges) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingLoadBalancerSourceRange(Predicate<String> predicate) {
        for (String item: loadBalancerSourceRanges) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withLoadBalancerSourceRanges(java.util.List<String> loadBalancerSourceRanges) {
        if (this.loadBalancerSourceRanges != null) { _visitables.get("loadBalancerSourceRanges").removeAll(this.loadBalancerSourceRanges);}
        if (loadBalancerSourceRanges != null) {this.loadBalancerSourceRanges = new ArrayList<String>(); for (String item : loadBalancerSourceRanges){this.addToLoadBalancerSourceRanges(item);}} else { this.loadBalancerSourceRanges = null;} return (A) this;
    }

    public A withLoadBalancerSourceRanges(String... loadBalancerSourceRanges) {
        if (this.loadBalancerSourceRanges != null) {this.loadBalancerSourceRanges.clear();}
        if (loadBalancerSourceRanges != null) {for (String item :loadBalancerSourceRanges){ this.addToLoadBalancerSourceRanges(item);}} return (A) this;
    }

    public Boolean hasLoadBalancerSourceRanges() {
        return loadBalancerSourceRanges != null && !loadBalancerSourceRanges.isEmpty();
    }

    public A addNewLoadBalancerSourceRange(StringBuilder arg1) {
        return (A)addToLoadBalancerSourceRanges(new String(arg1));
    }

    public A addNewLoadBalancerSourceRange(int[] arg1,int arg2,int arg3) {
        return (A)addToLoadBalancerSourceRanges(new String(arg1, arg2, arg3));
    }

    public A addNewLoadBalancerSourceRange(char[] arg1) {
        return (A)addToLoadBalancerSourceRanges(new String(arg1));
    }

    public A addNewLoadBalancerSourceRange(StringBuffer arg1) {
        return (A)addToLoadBalancerSourceRanges(new String(arg1));
    }

    public A addNewLoadBalancerSourceRange(byte[] arg1,int arg2) {
        return (A)addToLoadBalancerSourceRanges(new String(arg1, arg2));
    }

    public A addNewLoadBalancerSourceRange(byte[] arg1) {
        return (A)addToLoadBalancerSourceRanges(new String(arg1));
    }

    public A addNewLoadBalancerSourceRange(char[] arg1,int arg2,int arg3) {
        return (A)addToLoadBalancerSourceRanges(new String(arg1, arg2, arg3));
    }

    public A addNewLoadBalancerSourceRange(byte[] arg1,int arg2,int arg3) {
        return (A)addToLoadBalancerSourceRanges(new String(arg1, arg2, arg3));
    }

    public A addNewLoadBalancerSourceRange(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToLoadBalancerSourceRanges(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewLoadBalancerSourceRange(String arg1) {
        return (A)addToLoadBalancerSourceRanges(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ExternalServiceTemplateFluentImpl that = (ExternalServiceTemplateFluentImpl) o;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (externalTrafficPolicy != null ? !externalTrafficPolicy.equals(that.externalTrafficPolicy) :that.externalTrafficPolicy != null) return false;
        if (loadBalancerSourceRanges != null ? !loadBalancerSourceRanges.equals(that.loadBalancerSourceRanges) :that.loadBalancerSourceRanges != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(metadata,  externalTrafficPolicy,  loadBalancerSourceRanges,  super.hashCode());
    }

    public class MetadataNestedImpl<N> extends MetadataTemplateFluentImpl<ExternalServiceTemplateFluent.MetadataNested<N>> implements ExternalServiceTemplateFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final MetadataTemplateBuilder builder;

            MetadataNestedImpl(MetadataTemplate item) {
                this.builder = new MetadataTemplateBuilder(this, item);
                        
            }

            MetadataNestedImpl() {
                this.builder = new MetadataTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) ExternalServiceTemplateFluentImpl.this.withMetadata(builder.build());
            }

            public N endMetadata() {
                return and();
            }
    }


}
