package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class DeploymentTemplateFluentImpl<A extends DeploymentTemplateFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements DeploymentTemplateFluent<A> {

    private MetadataTemplateBuilder metadata;
    private DeploymentStrategy deploymentStrategy;

    public DeploymentTemplateFluentImpl() {
    }

    public DeploymentTemplateFluentImpl(DeploymentTemplate instance) {
        this.withMetadata(instance.getMetadata());
        
        this.withDeploymentStrategy(instance.getDeploymentStrategy());
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public MetadataTemplate getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public MetadataTemplate buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(MetadataTemplate metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new MetadataTemplateBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    public DeploymentTemplateFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    public DeploymentTemplateFluent.MetadataNested<A> withNewMetadataLike(MetadataTemplate item) {
        return new MetadataNestedImpl(item);
    }

    public DeploymentTemplateFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public DeploymentTemplateFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new MetadataTemplateBuilder().build());
    }

    public DeploymentTemplateFluent.MetadataNested<A> editOrNewMetadataLike(MetadataTemplate item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public DeploymentStrategy getDeploymentStrategy() {
        return this.deploymentStrategy;
    }

    public A withDeploymentStrategy(DeploymentStrategy deploymentStrategy) {
        this.deploymentStrategy=deploymentStrategy; return (A) this;
    }

    public Boolean hasDeploymentStrategy() {
        return this.deploymentStrategy != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DeploymentTemplateFluentImpl that = (DeploymentTemplateFluentImpl) o;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (deploymentStrategy != null ? !deploymentStrategy.equals(that.deploymentStrategy) :that.deploymentStrategy != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(metadata,  deploymentStrategy,  super.hashCode());
    }

    public class MetadataNestedImpl<N> extends MetadataTemplateFluentImpl<DeploymentTemplateFluent.MetadataNested<N>> implements DeploymentTemplateFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final MetadataTemplateBuilder builder;

            MetadataNestedImpl(MetadataTemplate item) {
                this.builder = new MetadataTemplateBuilder(this, item);
                        
            }

            MetadataNestedImpl() {
                this.builder = new MetadataTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) DeploymentTemplateFluentImpl.this.withMetadata(builder.build());
            }

            public N endMetadata() {
                return and();
            }
    }


}
