package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CruiseControlTemplateBuilder extends CruiseControlTemplateFluentImpl<CruiseControlTemplateBuilder> implements VisitableBuilder<CruiseControlTemplate,CruiseControlTemplateBuilder> {

    CruiseControlTemplateFluent<?> fluent;
    Boolean validationEnabled;

    public CruiseControlTemplateBuilder() {
        this(true);
    }

    public CruiseControlTemplateBuilder(Boolean validationEnabled) {
        this(new CruiseControlTemplate(), validationEnabled);
    }

    public CruiseControlTemplateBuilder(CruiseControlTemplateFluent<?> fluent) {
        this(fluent, true);
    }

    public CruiseControlTemplateBuilder(CruiseControlTemplateFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new CruiseControlTemplate(), validationEnabled);
    }

    public CruiseControlTemplateBuilder(CruiseControlTemplateFluent<?> fluent,CruiseControlTemplate instance) {
        this(fluent, instance, true);
    }

    public CruiseControlTemplateBuilder(CruiseControlTemplateFluent<?> fluent,CruiseControlTemplate instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDeployment(instance.getDeployment());
        
        fluent.withPod(instance.getPod());
        
        fluent.withApiService(instance.getApiService());
        
        fluent.withPodDisruptionBudget(instance.getPodDisruptionBudget());
        
        fluent.withCruiseControlContainer(instance.getCruiseControlContainer());
        
        fluent.withTlsSidecarContainer(instance.getTlsSidecarContainer());
        
        this.validationEnabled = validationEnabled; 
    }

    public CruiseControlTemplateBuilder(CruiseControlTemplate instance) {
        this(instance,true);
    }

    public CruiseControlTemplateBuilder(CruiseControlTemplate instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withDeployment(instance.getDeployment());
        
        this.withPod(instance.getPod());
        
        this.withApiService(instance.getApiService());
        
        this.withPodDisruptionBudget(instance.getPodDisruptionBudget());
        
        this.withCruiseControlContainer(instance.getCruiseControlContainer());
        
        this.withTlsSidecarContainer(instance.getTlsSidecarContainer());
        
        this.validationEnabled = validationEnabled; 
    }

    public CruiseControlTemplate build() {
        CruiseControlTemplate buildable = new CruiseControlTemplate();
        buildable.setDeployment(fluent.getDeployment());
        buildable.setPod(fluent.getPod());
        buildable.setApiService(fluent.getApiService());
        buildable.setPodDisruptionBudget(fluent.getPodDisruptionBudget());
        buildable.setCruiseControlContainer(fluent.getCruiseControlContainer());
        buildable.setTlsSidecarContainer(fluent.getTlsSidecarContainer());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CruiseControlTemplateBuilder that = (CruiseControlTemplateBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
