package io.strimzi.api.kafka.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

public class JbodStorageFluentImpl<A extends JbodStorageFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements JbodStorageFluent<A> {

    private java.util.List<VisitableBuilder<? extends SingleVolumeStorage,?>> volumes;

    public JbodStorageFluentImpl() {
    }

    public JbodStorageFluentImpl(JbodStorage instance) {
        this.withVolumes(instance.getVolumes());
    }

    public A addToVolumes(VisitableBuilder<? extends SingleVolumeStorage,?> builder) {
        if (this.volumes == null) {this.volumes = new ArrayList<VisitableBuilder<? extends SingleVolumeStorage,?>>();}
        _visitables.get("volumes").add(builder);this.volumes.add(builder); return (A)this;
    }

    public A addToVolumes(int index,VisitableBuilder<? extends SingleVolumeStorage,?> builder) {
        if (this.volumes == null) {this.volumes = new ArrayList<VisitableBuilder<? extends SingleVolumeStorage,?>>();}
        _visitables.get("volumes").add(index, builder);this.volumes.add(index, builder); return (A)this;
    }

    public A addToVolumes(int index,SingleVolumeStorage item) {
        if (item instanceof PersistentClaimStorage){addToPersistentClaimStorageVolumes(index, (PersistentClaimStorage)item);}
         else if (item instanceof EphemeralStorage){addToEphemeralStorageVolumes(index, (EphemeralStorage)item);}
        
        return (A)this;
    }

    public A setToVolumes(int index,SingleVolumeStorage item) {
        if (item instanceof PersistentClaimStorage){setToPersistentClaimStorageVolumes(index, (PersistentClaimStorage)item);}
         else if (item instanceof EphemeralStorage){setToEphemeralStorageVolumes(index, (EphemeralStorage)item);}
        
        return (A)this;
    }

    public A addToVolumes(SingleVolumeStorage... items) {
         if (items != null && items.length > 0 && this.volumes== null) {this.volumes = new ArrayList<VisitableBuilder<? extends SingleVolumeStorage,?>>();}
        for (SingleVolumeStorage item : items) { 
        if (item instanceof PersistentClaimStorage){addToPersistentClaimStorageVolumes((PersistentClaimStorage)item);}
         else if (item instanceof EphemeralStorage){addToEphemeralStorageVolumes((EphemeralStorage)item);}
        
        else {  VisitableBuilder<? extends SingleVolumeStorage,?> builder = builderOf(item); _visitables.get("volumes").add(builder);this.volumes.add(builder); }
        } return (A)this;
    }

    public A addAllToVolumes(Collection<SingleVolumeStorage> items) {
         if (items != null && items.size() > 0 && this.volumes== null) {this.volumes = new ArrayList<VisitableBuilder<? extends SingleVolumeStorage,?>>();}
        for (SingleVolumeStorage item : items) { 
        if (item instanceof PersistentClaimStorage){addToPersistentClaimStorageVolumes((PersistentClaimStorage)item);}
         else if (item instanceof EphemeralStorage){addToEphemeralStorageVolumes((EphemeralStorage)item);}
        
        else {  VisitableBuilder<? extends SingleVolumeStorage,?> builder = builderOf(item); _visitables.get("volumes").add(builder);this.volumes.add(builder); }
        } return (A)this;
    }

    public A removeFromVolumes(VisitableBuilder<? extends SingleVolumeStorage,?> builder) {
        if (this.volumes == null) {this.volumes = new ArrayList<VisitableBuilder<? extends SingleVolumeStorage,?>>();}
        _visitables.get("volumes").remove(builder);this.volumes.remove(builder); return (A)this;
    }

    public A removeFromVolumes(SingleVolumeStorage... items) {
        for (SingleVolumeStorage item : items) {if (item instanceof PersistentClaimStorage){removeFromPersistentClaimStorageVolumes((PersistentClaimStorage)item);}
         else if (item instanceof EphemeralStorage){removeFromEphemeralStorageVolumes((EphemeralStorage)item);}
        
        else {  VisitableBuilder<? extends SingleVolumeStorage,?> builder = builderOf(item); _visitables.get("volumes").remove(builder);this.volumes.remove(builder); }
        } return (A)this;
    }

    public A removeAllFromVolumes(Collection<SingleVolumeStorage> items) {
        for (SingleVolumeStorage item : items) {if (item instanceof PersistentClaimStorage){removeFromPersistentClaimStorageVolumes((PersistentClaimStorage)item);}
         else if (item instanceof EphemeralStorage){removeFromEphemeralStorageVolumes((EphemeralStorage)item);}
        
        else {  VisitableBuilder<? extends SingleVolumeStorage,?> builder = builderOf(item); _visitables.get("volumes").remove(builder);this.volumes.remove(builder); }
        } return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildVolumes instead.
 * @return The buildable object.
 */
@Deprecated public java.util.List<SingleVolumeStorage> getVolumes() {
        return build(volumes);
    }

    public java.util.List<SingleVolumeStorage> buildVolumes() {
        return build(volumes);
    }

    public SingleVolumeStorage buildVolume(int index) {
        return this.volumes.get(index).build();
    }

    public SingleVolumeStorage buildFirstVolume() {
        return this.volumes.get(0).build();
    }

    public SingleVolumeStorage buildLastVolume() {
        return this.volumes.get(volumes.size() - 1).build();
    }

    public SingleVolumeStorage buildMatchingVolume(Predicate<VisitableBuilder<? extends SingleVolumeStorage,?>> predicate) {
        for (VisitableBuilder<? extends SingleVolumeStorage,?> item: volumes) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingVolume(Predicate<VisitableBuilder<? extends SingleVolumeStorage,?>> predicate) {
        for (VisitableBuilder<? extends SingleVolumeStorage,?> item: volumes) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withVolumes(java.util.List<SingleVolumeStorage> volumes) {
        if (this.volumes != null) { _visitables.get("volumes").removeAll(this.volumes);}
        if (volumes != null) {this.volumes = new ArrayList<VisitableBuilder<? extends SingleVolumeStorage,?>>(); for (SingleVolumeStorage item : volumes){this.addToVolumes(item);}} else { this.volumes = null;} return (A) this;
    }

    public A withVolumes(SingleVolumeStorage... volumes) {
        if (this.volumes != null) {this.volumes.clear();}
        if (volumes != null) {for (SingleVolumeStorage item :volumes){ this.addToVolumes(item);}} return (A) this;
    }

    public Boolean hasVolumes() {
        return volumes != null && !volumes.isEmpty();
    }

    public A addToPersistentClaimStorageVolumes(int index,PersistentClaimStorage item) {
        if (this.volumes == null) {this.volumes = new ArrayList<VisitableBuilder<? extends SingleVolumeStorage,?>>();}
        PersistentClaimStorageBuilder builder = new PersistentClaimStorageBuilder(item);_visitables.get("volumes").add(index >= 0 ? index : _visitables.get("volumes").size(), builder);this.volumes.add(index >= 0 ? index : volumes.size(), builder); return (A)this;
    }

    public A setToPersistentClaimStorageVolumes(int index,PersistentClaimStorage item) {
        if (this.volumes == null) {this.volumes = new ArrayList<VisitableBuilder<? extends SingleVolumeStorage,?>>();}
        PersistentClaimStorageBuilder builder = new PersistentClaimStorageBuilder(item);
        if (index < 0 || index >= _visitables.get("volumes").size()) { _visitables.get("volumes").add(builder); } else { _visitables.get("volumes").set(index, builder);}
        if (index < 0 || index >= volumes.size()) { volumes.add(builder); } else { volumes.set(index, builder);}
         return (A)this;
    }

    public A addToPersistentClaimStorageVolumes(PersistentClaimStorage... items) {
        if (this.volumes == null) {this.volumes = new ArrayList<VisitableBuilder<? extends SingleVolumeStorage,?>>();}
        for (PersistentClaimStorage item : items) {PersistentClaimStorageBuilder builder = new PersistentClaimStorageBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
    }

    public A addAllToPersistentClaimStorageVolumes(Collection<PersistentClaimStorage> items) {
        if (this.volumes == null) {this.volumes = new ArrayList<VisitableBuilder<? extends SingleVolumeStorage,?>>();}
        for (PersistentClaimStorage item : items) {PersistentClaimStorageBuilder builder = new PersistentClaimStorageBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
    }

    public A removeFromPersistentClaimStorageVolumes(PersistentClaimStorage... items) {
        for (PersistentClaimStorage item : items) {PersistentClaimStorageBuilder builder = new PersistentClaimStorageBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
    }

    public A removeAllFromPersistentClaimStorageVolumes(Collection<PersistentClaimStorage> items) {
        for (PersistentClaimStorage item : items) {PersistentClaimStorageBuilder builder = new PersistentClaimStorageBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromPersistentClaimStorageVolumes(Predicate<VisitableBuilder<? extends SingleVolumeStorage,?>> predicate) {
        if (volumes == null) return (A) this;
        final Iterator<VisitableBuilder<? extends SingleVolumeStorage,?>> each = volumes.iterator();
        final List visitables = _visitables.get("volumes");
        while (each.hasNext()) {
          VisitableBuilder<? extends SingleVolumeStorage,?> builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    public JbodStorageFluent.PersistentClaimStorageVolumesNested<A> addNewPersistentClaimStorageVolume() {
        return new PersistentClaimStorageVolumesNestedImpl();
    }

    public JbodStorageFluent.PersistentClaimStorageVolumesNested<A> addNewPersistentClaimStorageVolumeLike(PersistentClaimStorage item) {
        return new PersistentClaimStorageVolumesNestedImpl(-1, item);
    }

    public JbodStorageFluent.PersistentClaimStorageVolumesNested<A> setNewPersistentClaimStorageVolumeLike(int index,PersistentClaimStorage item) {
        return new PersistentClaimStorageVolumesNestedImpl(index, item);
    }

    public A addToEphemeralStorageVolumes(int index,EphemeralStorage item) {
        if (this.volumes == null) {this.volumes = new ArrayList<VisitableBuilder<? extends SingleVolumeStorage,?>>();}
        EphemeralStorageBuilder builder = new EphemeralStorageBuilder(item);_visitables.get("volumes").add(index >= 0 ? index : _visitables.get("volumes").size(), builder);this.volumes.add(index >= 0 ? index : volumes.size(), builder); return (A)this;
    }

    public A setToEphemeralStorageVolumes(int index,EphemeralStorage item) {
        if (this.volumes == null) {this.volumes = new ArrayList<VisitableBuilder<? extends SingleVolumeStorage,?>>();}
        EphemeralStorageBuilder builder = new EphemeralStorageBuilder(item);
        if (index < 0 || index >= _visitables.get("volumes").size()) { _visitables.get("volumes").add(builder); } else { _visitables.get("volumes").set(index, builder);}
        if (index < 0 || index >= volumes.size()) { volumes.add(builder); } else { volumes.set(index, builder);}
         return (A)this;
    }

    public A addToEphemeralStorageVolumes(EphemeralStorage... items) {
        if (this.volumes == null) {this.volumes = new ArrayList<VisitableBuilder<? extends SingleVolumeStorage,?>>();}
        for (EphemeralStorage item : items) {EphemeralStorageBuilder builder = new EphemeralStorageBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
    }

    public A addAllToEphemeralStorageVolumes(Collection<EphemeralStorage> items) {
        if (this.volumes == null) {this.volumes = new ArrayList<VisitableBuilder<? extends SingleVolumeStorage,?>>();}
        for (EphemeralStorage item : items) {EphemeralStorageBuilder builder = new EphemeralStorageBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
    }

    public A removeFromEphemeralStorageVolumes(EphemeralStorage... items) {
        for (EphemeralStorage item : items) {EphemeralStorageBuilder builder = new EphemeralStorageBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
    }

    public A removeAllFromEphemeralStorageVolumes(Collection<EphemeralStorage> items) {
        for (EphemeralStorage item : items) {EphemeralStorageBuilder builder = new EphemeralStorageBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromEphemeralStorageVolumes(Predicate<VisitableBuilder<? extends SingleVolumeStorage,?>> predicate) {
        if (volumes == null) return (A) this;
        final Iterator<VisitableBuilder<? extends SingleVolumeStorage,?>> each = volumes.iterator();
        final List visitables = _visitables.get("volumes");
        while (each.hasNext()) {
          VisitableBuilder<? extends SingleVolumeStorage,?> builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    public JbodStorageFluent.EphemeralStorageVolumesNested<A> addNewEphemeralStorageVolume() {
        return new EphemeralStorageVolumesNestedImpl();
    }

    public JbodStorageFluent.EphemeralStorageVolumesNested<A> addNewEphemeralStorageVolumeLike(EphemeralStorage item) {
        return new EphemeralStorageVolumesNestedImpl(-1, item);
    }

    public JbodStorageFluent.EphemeralStorageVolumesNested<A> setNewEphemeralStorageVolumeLike(int index,EphemeralStorage item) {
        return new EphemeralStorageVolumesNestedImpl(index, item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        JbodStorageFluentImpl that = (JbodStorageFluentImpl) o;
        if (volumes != null ? !volumes.equals(that.volumes) :that.volumes != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(volumes,  super.hashCode());
    }

    public class PersistentClaimStorageVolumesNestedImpl<N> extends PersistentClaimStorageFluentImpl<JbodStorageFluent.PersistentClaimStorageVolumesNested<N>> implements JbodStorageFluent.PersistentClaimStorageVolumesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PersistentClaimStorageBuilder builder;
        private final int index;

            PersistentClaimStorageVolumesNestedImpl(int index,PersistentClaimStorage item) {
                this.index = index;
                this.builder = new PersistentClaimStorageBuilder(this, item);
                        
            }

            PersistentClaimStorageVolumesNestedImpl() {
                this.index = -1;
                this.builder = new PersistentClaimStorageBuilder(this);
                        
            }

            public N and() {
                return (N) JbodStorageFluentImpl.this.setToVolumes(index,builder.build());
            }

            public N endPersistentClaimStorageVolume() {
                return and();
            }
    }


    public class EphemeralStorageVolumesNestedImpl<N> extends EphemeralStorageFluentImpl<JbodStorageFluent.EphemeralStorageVolumesNested<N>> implements JbodStorageFluent.EphemeralStorageVolumesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EphemeralStorageBuilder builder;
        private final int index;

            EphemeralStorageVolumesNestedImpl(int index,EphemeralStorage item) {
                this.index = index;
                this.builder = new EphemeralStorageBuilder(this, item);
                        
            }

            EphemeralStorageVolumesNestedImpl() {
                this.index = -1;
                this.builder = new EphemeralStorageBuilder(this);
                        
            }

            public N and() {
                return (N) JbodStorageFluentImpl.this.setToVolumes(index,builder.build());
            }

            public N endEphemeralStorageVolume() {
                return and();
            }
    }


}
