package io.strimzi.api.kafka.model.storage;

import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class EphemeralStorageFluentImpl<A extends EphemeralStorageFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements EphemeralStorageFluent<A> {

    private Integer id;
    private String sizeLimit;

    public EphemeralStorageFluentImpl() {
    }

    public EphemeralStorageFluentImpl(EphemeralStorage instance) {
        this.withId(instance.getId());
        
        this.withSizeLimit(instance.getSizeLimit());
    }

    public Integer getId() {
        return this.id;
    }

    public A withId(Integer id) {
        this.id=id; return (A) this;
    }

    public Boolean hasId() {
        return this.id != null;
    }

    public String getSizeLimit() {
        return this.sizeLimit;
    }

    public A withSizeLimit(String sizeLimit) {
        this.sizeLimit=sizeLimit; return (A) this;
    }

    public Boolean hasSizeLimit() {
        return this.sizeLimit != null;
    }

    public A withNewSizeLimit(StringBuilder arg1) {
        return (A)withSizeLimit(new String(arg1));
    }

    public A withNewSizeLimit(int[] arg1,int arg2,int arg3) {
        return (A)withSizeLimit(new String(arg1, arg2, arg3));
    }

    public A withNewSizeLimit(char[] arg1) {
        return (A)withSizeLimit(new String(arg1));
    }

    public A withNewSizeLimit(StringBuffer arg1) {
        return (A)withSizeLimit(new String(arg1));
    }

    public A withNewSizeLimit(byte[] arg1,int arg2) {
        return (A)withSizeLimit(new String(arg1, arg2));
    }

    public A withNewSizeLimit(byte[] arg1) {
        return (A)withSizeLimit(new String(arg1));
    }

    public A withNewSizeLimit(char[] arg1,int arg2,int arg3) {
        return (A)withSizeLimit(new String(arg1, arg2, arg3));
    }

    public A withNewSizeLimit(byte[] arg1,int arg2,int arg3) {
        return (A)withSizeLimit(new String(arg1, arg2, arg3));
    }

    public A withNewSizeLimit(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withSizeLimit(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewSizeLimit(String arg1) {
        return (A)withSizeLimit(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        EphemeralStorageFluentImpl that = (EphemeralStorageFluentImpl) o;
        if (id != null ? !id.equals(that.id) :that.id != null) return false;
        if (sizeLimit != null ? !sizeLimit.equals(that.sizeLimit) :that.sizeLimit != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(id,  sizeLimit,  super.hashCode());
    }

}
