package io.strimzi.api.kafka.model.status;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class KafkaUserStatusFluentImpl<A extends KafkaUserStatusFluent<A>> extends StatusFluentImpl<A> implements KafkaUserStatusFluent<A> {

    private String username;
    private String secret;

    public KafkaUserStatusFluentImpl() {
    }

    public KafkaUserStatusFluentImpl(KafkaUserStatus instance) {
        this.withUsername(instance.getUsername());
        
        this.withSecret(instance.getSecret());
        
        this.withConditions(instance.getConditions());
        
        this.withObservedGeneration(instance.getObservedGeneration());
    }

    public String getUsername() {
        return this.username;
    }

    public A withUsername(String username) {
        this.username=username; return (A) this;
    }

    public Boolean hasUsername() {
        return this.username != null;
    }

    public A withNewUsername(StringBuilder arg1) {
        return (A)withUsername(new String(arg1));
    }

    public A withNewUsername(int[] arg1,int arg2,int arg3) {
        return (A)withUsername(new String(arg1, arg2, arg3));
    }

    public A withNewUsername(char[] arg1) {
        return (A)withUsername(new String(arg1));
    }

    public A withNewUsername(StringBuffer arg1) {
        return (A)withUsername(new String(arg1));
    }

    public A withNewUsername(byte[] arg1,int arg2) {
        return (A)withUsername(new String(arg1, arg2));
    }

    public A withNewUsername(byte[] arg1) {
        return (A)withUsername(new String(arg1));
    }

    public A withNewUsername(char[] arg1,int arg2,int arg3) {
        return (A)withUsername(new String(arg1, arg2, arg3));
    }

    public A withNewUsername(byte[] arg1,int arg2,int arg3) {
        return (A)withUsername(new String(arg1, arg2, arg3));
    }

    public A withNewUsername(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withUsername(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewUsername(String arg1) {
        return (A)withUsername(new String(arg1));
    }

    public String getSecret() {
        return this.secret;
    }

    public A withSecret(String secret) {
        this.secret=secret; return (A) this;
    }

    public Boolean hasSecret() {
        return this.secret != null;
    }

    public A withNewSecret(StringBuilder arg1) {
        return (A)withSecret(new String(arg1));
    }

    public A withNewSecret(int[] arg1,int arg2,int arg3) {
        return (A)withSecret(new String(arg1, arg2, arg3));
    }

    public A withNewSecret(char[] arg1) {
        return (A)withSecret(new String(arg1));
    }

    public A withNewSecret(StringBuffer arg1) {
        return (A)withSecret(new String(arg1));
    }

    public A withNewSecret(byte[] arg1,int arg2) {
        return (A)withSecret(new String(arg1, arg2));
    }

    public A withNewSecret(byte[] arg1) {
        return (A)withSecret(new String(arg1));
    }

    public A withNewSecret(char[] arg1,int arg2,int arg3) {
        return (A)withSecret(new String(arg1, arg2, arg3));
    }

    public A withNewSecret(byte[] arg1,int arg2,int arg3) {
        return (A)withSecret(new String(arg1, arg2, arg3));
    }

    public A withNewSecret(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withSecret(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewSecret(String arg1) {
        return (A)withSecret(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaUserStatusFluentImpl that = (KafkaUserStatusFluentImpl) o;
        if (username != null ? !username.equals(that.username) :that.username != null) return false;
        if (secret != null ? !secret.equals(that.secret) :that.secret != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(username,  secret,  super.hashCode());
    }

}
