package io.strimzi.api.kafka.model.status;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

public class KafkaRebalanceStatusFluentImpl<A extends KafkaRebalanceStatusFluent<A>> extends StatusFluentImpl<A> implements KafkaRebalanceStatusFluent<A> {

    private String sessionId;
    private Map<String,Object> optimizationResult;

    public KafkaRebalanceStatusFluentImpl() {
    }

    public KafkaRebalanceStatusFluentImpl(KafkaRebalanceStatus instance) {
        this.withSessionId(instance.getSessionId());
        
        this.withOptimizationResult(instance.getOptimizationResult());
        
        this.withConditions(instance.getConditions());
        
        this.withObservedGeneration(instance.getObservedGeneration());
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public A withSessionId(String sessionId) {
        this.sessionId=sessionId; return (A) this;
    }

    public Boolean hasSessionId() {
        return this.sessionId != null;
    }

    public A withNewSessionId(StringBuilder arg1) {
        return (A)withSessionId(new String(arg1));
    }

    public A withNewSessionId(int[] arg1,int arg2,int arg3) {
        return (A)withSessionId(new String(arg1, arg2, arg3));
    }

    public A withNewSessionId(char[] arg1) {
        return (A)withSessionId(new String(arg1));
    }

    public A withNewSessionId(StringBuffer arg1) {
        return (A)withSessionId(new String(arg1));
    }

    public A withNewSessionId(byte[] arg1,int arg2) {
        return (A)withSessionId(new String(arg1, arg2));
    }

    public A withNewSessionId(byte[] arg1) {
        return (A)withSessionId(new String(arg1));
    }

    public A withNewSessionId(char[] arg1,int arg2,int arg3) {
        return (A)withSessionId(new String(arg1, arg2, arg3));
    }

    public A withNewSessionId(byte[] arg1,int arg2,int arg3) {
        return (A)withSessionId(new String(arg1, arg2, arg3));
    }

    public A withNewSessionId(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withSessionId(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewSessionId(String arg1) {
        return (A)withSessionId(new String(arg1));
    }

    public A addToOptimizationResult(String key,Object value) {
        if(this.optimizationResult == null && key != null && value != null) { this.optimizationResult = new LinkedHashMap<String,Object>(); }
        if(key != null && value != null) {this.optimizationResult.put(key, value);} return (A)this;
    }

    public A addToOptimizationResult(Map<String,Object> map) {
        if(this.optimizationResult == null && map != null) { this.optimizationResult = new LinkedHashMap<String,Object>(); }
        if(map != null) { this.optimizationResult.putAll(map);} return (A)this;
    }

    public A removeFromOptimizationResult(String key) {
        if(this.optimizationResult == null) { return (A) this; }
        if(key != null && this.optimizationResult != null) {this.optimizationResult.remove(key);} return (A)this;
    }

    public A removeFromOptimizationResult(Map<String,Object> map) {
        if(this.optimizationResult == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.optimizationResult != null){this.optimizationResult.remove(key);}}} return (A)this;
    }

    public Map<String,Object> getOptimizationResult() {
        return this.optimizationResult;
    }

    public <K extends Object,V extends Object>A withOptimizationResult(Map<String,Object> optimizationResult) {
        if (optimizationResult == null) { this.optimizationResult =  null;} else {this.optimizationResult = new LinkedHashMap<String,Object>(optimizationResult);} return (A) this;
    }

    public Boolean hasOptimizationResult() {
        return this.optimizationResult != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaRebalanceStatusFluentImpl that = (KafkaRebalanceStatusFluentImpl) o;
        if (sessionId != null ? !sessionId.equals(that.sessionId) :that.sessionId != null) return false;
        if (optimizationResult != null ? !optimizationResult.equals(that.optimizationResult) :that.optimizationResult != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(sessionId,  optimizationResult,  super.hashCode());
    }

}
