package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaMirrorMakerStatusBuilder extends KafkaMirrorMakerStatusFluentImpl<KafkaMirrorMakerStatusBuilder> implements VisitableBuilder<KafkaMirrorMakerStatus,KafkaMirrorMakerStatusBuilder> {

    KafkaMirrorMakerStatusFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaMirrorMakerStatusBuilder() {
        this(true);
    }

    public KafkaMirrorMakerStatusBuilder(Boolean validationEnabled) {
        this(new KafkaMirrorMakerStatus(), validationEnabled);
    }

    public KafkaMirrorMakerStatusBuilder(KafkaMirrorMakerStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaMirrorMakerStatusBuilder(KafkaMirrorMakerStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KafkaMirrorMakerStatus(), validationEnabled);
    }

    public KafkaMirrorMakerStatusBuilder(KafkaMirrorMakerStatusFluent<?> fluent,KafkaMirrorMakerStatus instance) {
        this(fluent, instance, true);
    }

    public KafkaMirrorMakerStatusBuilder(KafkaMirrorMakerStatusFluent<?> fluent,KafkaMirrorMakerStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withReplicas(instance.getReplicas());
        
        fluent.withLabelSelector(instance.getLabelSelector());
        
        fluent.withConditions(instance.getConditions());
        
        fluent.withObservedGeneration(instance.getObservedGeneration());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaMirrorMakerStatusBuilder(KafkaMirrorMakerStatus instance) {
        this(instance,true);
    }

    public KafkaMirrorMakerStatusBuilder(KafkaMirrorMakerStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withReplicas(instance.getReplicas());
        
        this.withLabelSelector(instance.getLabelSelector());
        
        this.withConditions(instance.getConditions());
        
        this.withObservedGeneration(instance.getObservedGeneration());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaMirrorMakerStatus build() {
        KafkaMirrorMakerStatus buildable = new KafkaMirrorMakerStatus();
        buildable.setConditions(fluent.getConditions());
        buildable.setObservedGeneration(fluent.getObservedGeneration());
        buildable.setReplicas(fluent.getReplicas());
        buildable.setLabelSelector(fluent.getLabelSelector());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaMirrorMakerStatusBuilder that = (KafkaMirrorMakerStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
