package io.strimzi.api.kafka.model.status;

import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.function.Predicate;

public class KafkaMirrorMaker2StatusFluentImpl<A extends KafkaMirrorMaker2StatusFluent<A>> extends KafkaConnectStatusFluentImpl<A> implements KafkaMirrorMaker2StatusFluent<A> {

    private java.util.List<Map<String,Object>> connectors;

    public KafkaMirrorMaker2StatusFluentImpl() {
    }

    public KafkaMirrorMaker2StatusFluentImpl(KafkaMirrorMaker2Status instance) {
        this.withConnectors(instance.getConnectors());
        
        this.withUrl(instance.getUrl());
        
        this.withConnectorPlugins(instance.getConnectorPlugins());
        
        this.withReplicas(instance.getReplicas());
        
        this.withLabelSelector(instance.getLabelSelector());
        
        this.withConditions(instance.getConditions());
        
        this.withObservedGeneration(instance.getObservedGeneration());
    }

    public A addToConnectors(int index,Map<String,Object> item) {
        if (this.connectors == null) {this.connectors = new ArrayList<Map<String,Object>>();}
        this.connectors.add(index, item);
        return (A)this;
    }

    public A setToConnectors(int index,Map<String,Object> item) {
        if (this.connectors == null) {this.connectors = new ArrayList<Map<String,Object>>();}
        this.connectors.set(index, item); return (A)this;
    }

    public A addToConnectors(Map<String,Object>... items) {
        if (this.connectors == null) {this.connectors = new ArrayList<Map<String,Object>>();}
        for (Map<String,Object> item : items) {this.connectors.add(item);} return (A)this;
    }

    public A addAllToConnectors(Collection<Map<String,Object>> items) {
        if (this.connectors == null) {this.connectors = new ArrayList<Map<String,Object>>();}
        for (Map<String,Object> item : items) {this.connectors.add(item);} return (A)this;
    }

    public A removeFromConnectors(Map<String,Object>... items) {
        for (Map<String,Object> item : items) {if (this.connectors!= null){ this.connectors.remove(item);}} return (A)this;
    }

    public A removeAllFromConnectors(Collection<Map<String,Object>> items) {
        for (Map<String,Object> item : items) {if (this.connectors!= null){ this.connectors.remove(item);}} return (A)this;
    }

    public java.util.List<Map<String,Object>> getConnectors() {
        return this.connectors;
    }

    public Map<String,Object> getConnector(int index) {
        return this.connectors.get(index);
    }

    public Map<String,Object> getFirstConnector() {
        return this.connectors.get(0);
    }

    public Map<String,Object> getLastConnector() {
        return this.connectors.get(connectors.size() - 1);
    }

    public Map<String,Object> getMatchingConnector(Predicate<Map<String,Object>> predicate) {
        for (Map<String,Object> item: connectors) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingConnector(Predicate<Map<String,Object>> predicate) {
        for (Map<String,Object> item: connectors) { if(predicate.test(item)){ return true;} } return false;
    }

    public <K extends Object,V extends Object>A withConnectors(java.util.List<Map<String,Object>> connectors) {
        if (this.connectors != null) { _visitables.get("connectors").removeAll(this.connectors);}
        if (connectors != null) {this.connectors = new ArrayList<Map<String,Object>>(); for (Map<String,Object> item : connectors){this.addToConnectors(item);}} else { this.connectors = null;} return (A) this;
    }

    public A withConnectors(Map<String,Object>... connectors) {
        if (this.connectors != null) {this.connectors.clear();}
        if (connectors != null) {for (Map<String,Object> item :connectors){ this.addToConnectors(item);}} return (A) this;
    }

    public Boolean hasConnectors() {
        return connectors != null && !connectors.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaMirrorMaker2StatusFluentImpl that = (KafkaMirrorMaker2StatusFluentImpl) o;
        if (connectors != null ? !connectors.equals(that.connectors) :that.connectors != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(connectors,  super.hashCode());
    }

}
