package io.strimzi.api.kafka.model.status;

import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.function.Predicate;

public interface KafkaMirrorMaker2StatusFluent<A extends KafkaMirrorMaker2StatusFluent<A>> extends KafkaConnectStatusFluent<A> {


    public A addToConnectors(int index,Map<String,Object> item);
    public A setToConnectors(int index,Map<String,Object> item);
    public A addToConnectors(Map<String,Object>... items);
    public A addAllToConnectors(Collection<Map<String,Object>> items);
    public A removeFromConnectors(Map<String,Object>... items);
    public A removeAllFromConnectors(Collection<Map<String,Object>> items);
    public java.util.List<Map<String,Object>> getConnectors();
    public Map<String,Object> getConnector(int index);
    public Map<String,Object> getFirstConnector();
    public Map<String,Object> getLastConnector();
    public Map<String,Object> getMatchingConnector(Predicate<Map<String,Object>> predicate);
    public Boolean hasMatchingConnector(Predicate<Map<String,Object>> predicate);
    public <K extends Object,V extends Object>A withConnectors(java.util.List<Map<String,Object>> connectors);
    public A withConnectors(Map<String,Object>... connectors);
    public Boolean hasConnectors();
}
