package io.strimzi.api.kafka.model.status;

import java.lang.StringBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public class KafkaConnectorStatusFluentImpl<A extends KafkaConnectorStatusFluent<A>> extends StatusFluentImpl<A> implements KafkaConnectorStatusFluent<A> {

    private Map<String,Object> connectorStatus;
    private int tasksMax;
    private java.util.List<String> topics;

    public KafkaConnectorStatusFluentImpl() {
    }

    public KafkaConnectorStatusFluentImpl(KafkaConnectorStatus instance) {
        this.withConnectorStatus(instance.getConnectorStatus());
        
        this.withTasksMax(instance.getTasksMax());
        
        this.withTopics(instance.getTopics());
        
        this.withConditions(instance.getConditions());
        
        this.withObservedGeneration(instance.getObservedGeneration());
    }

    public A addToConnectorStatus(String key,Object value) {
        if(this.connectorStatus == null && key != null && value != null) { this.connectorStatus = new LinkedHashMap<String,Object>(); }
        if(key != null && value != null) {this.connectorStatus.put(key, value);} return (A)this;
    }

    public A addToConnectorStatus(Map<String,Object> map) {
        if(this.connectorStatus == null && map != null) { this.connectorStatus = new LinkedHashMap<String,Object>(); }
        if(map != null) { this.connectorStatus.putAll(map);} return (A)this;
    }

    public A removeFromConnectorStatus(String key) {
        if(this.connectorStatus == null) { return (A) this; }
        if(key != null && this.connectorStatus != null) {this.connectorStatus.remove(key);} return (A)this;
    }

    public A removeFromConnectorStatus(Map<String,Object> map) {
        if(this.connectorStatus == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.connectorStatus != null){this.connectorStatus.remove(key);}}} return (A)this;
    }

    public Map<String,Object> getConnectorStatus() {
        return this.connectorStatus;
    }

    public <K extends Object,V extends Object>A withConnectorStatus(Map<String,Object> connectorStatus) {
        if (connectorStatus == null) { this.connectorStatus =  null;} else {this.connectorStatus = new LinkedHashMap<String,Object>(connectorStatus);} return (A) this;
    }

    public Boolean hasConnectorStatus() {
        return this.connectorStatus != null;
    }

    public int getTasksMax() {
        return this.tasksMax;
    }

    public A withTasksMax(int tasksMax) {
        this.tasksMax=tasksMax; return (A) this;
    }

    public Boolean hasTasksMax() {
        return true;
    }

    public A addToTopics(int index,String item) {
        if (this.topics == null) {this.topics = new ArrayList<String>();}
        this.topics.add(index, item);
        return (A)this;
    }

    public A setToTopics(int index,String item) {
        if (this.topics == null) {this.topics = new ArrayList<String>();}
        this.topics.set(index, item); return (A)this;
    }

    public A addToTopics(String... items) {
        if (this.topics == null) {this.topics = new ArrayList<String>();}
        for (String item : items) {this.topics.add(item);} return (A)this;
    }

    public A addAllToTopics(Collection<String> items) {
        if (this.topics == null) {this.topics = new ArrayList<String>();}
        for (String item : items) {this.topics.add(item);} return (A)this;
    }

    public A removeFromTopics(String... items) {
        for (String item : items) {if (this.topics!= null){ this.topics.remove(item);}} return (A)this;
    }

    public A removeAllFromTopics(Collection<String> items) {
        for (String item : items) {if (this.topics!= null){ this.topics.remove(item);}} return (A)this;
    }

    public java.util.List<String> getTopics() {
        return this.topics;
    }

    public String getTopic(int index) {
        return this.topics.get(index);
    }

    public String getFirstTopic() {
        return this.topics.get(0);
    }

    public String getLastTopic() {
        return this.topics.get(topics.size() - 1);
    }

    public String getMatchingTopic(Predicate<String> predicate) {
        for (String item: topics) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingTopic(Predicate<String> predicate) {
        for (String item: topics) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withTopics(java.util.List<String> topics) {
        if (this.topics != null) { _visitables.get("topics").removeAll(this.topics);}
        if (topics != null) {this.topics = new ArrayList<String>(); for (String item : topics){this.addToTopics(item);}} else { this.topics = null;} return (A) this;
    }

    public A withTopics(String... topics) {
        if (this.topics != null) {this.topics.clear();}
        if (topics != null) {for (String item :topics){ this.addToTopics(item);}} return (A) this;
    }

    public Boolean hasTopics() {
        return topics != null && !topics.isEmpty();
    }

    public A addNewTopic(StringBuilder arg1) {
        return (A)addToTopics(new String(arg1));
    }

    public A addNewTopic(int[] arg1,int arg2,int arg3) {
        return (A)addToTopics(new String(arg1, arg2, arg3));
    }

    public A addNewTopic(char[] arg1) {
        return (A)addToTopics(new String(arg1));
    }

    public A addNewTopic(StringBuffer arg1) {
        return (A)addToTopics(new String(arg1));
    }

    public A addNewTopic(byte[] arg1,int arg2) {
        return (A)addToTopics(new String(arg1, arg2));
    }

    public A addNewTopic(byte[] arg1) {
        return (A)addToTopics(new String(arg1));
    }

    public A addNewTopic(char[] arg1,int arg2,int arg3) {
        return (A)addToTopics(new String(arg1, arg2, arg3));
    }

    public A addNewTopic(byte[] arg1,int arg2,int arg3) {
        return (A)addToTopics(new String(arg1, arg2, arg3));
    }

    public A addNewTopic(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToTopics(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewTopic(String arg1) {
        return (A)addToTopics(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaConnectorStatusFluentImpl that = (KafkaConnectorStatusFluentImpl) o;
        if (connectorStatus != null ? !connectorStatus.equals(that.connectorStatus) :that.connectorStatus != null) return false;
        if (tasksMax != that.tasksMax) return false;
        if (topics != null ? !topics.equals(that.topics) :that.topics != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(connectorStatus,  tasksMax,  topics,  super.hashCode());
    }

}
