package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.strimzi.api.kafka.model.connect.ConnectorPluginBuilder;
import java.util.function.Predicate;
import io.strimzi.api.kafka.model.connect.ConnectorPlugin;
import java.lang.StringBuffer;
import io.strimzi.api.kafka.model.connect.ConnectorPluginFluentImpl;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class KafkaConnectStatusFluentImpl<A extends KafkaConnectStatusFluent<A>> extends StatusFluentImpl<A> implements KafkaConnectStatusFluent<A> {

    private String url;
    private java.util.List<ConnectorPluginBuilder> connectorPlugins;
    private int replicas;
    private String labelSelector;

    public KafkaConnectStatusFluentImpl() {
    }

    public KafkaConnectStatusFluentImpl(KafkaConnectStatus instance) {
        this.withUrl(instance.getUrl());
        
        this.withConnectorPlugins(instance.getConnectorPlugins());
        
        this.withReplicas(instance.getReplicas());
        
        this.withLabelSelector(instance.getLabelSelector());
        
        this.withConditions(instance.getConditions());
        
        this.withObservedGeneration(instance.getObservedGeneration());
    }

    public String getUrl() {
        return this.url;
    }

    public A withUrl(String url) {
        this.url=url; return (A) this;
    }

    public Boolean hasUrl() {
        return this.url != null;
    }

    public A withNewUrl(StringBuilder arg1) {
        return (A)withUrl(new String(arg1));
    }

    public A withNewUrl(int[] arg1,int arg2,int arg3) {
        return (A)withUrl(new String(arg1, arg2, arg3));
    }

    public A withNewUrl(char[] arg1) {
        return (A)withUrl(new String(arg1));
    }

    public A withNewUrl(StringBuffer arg1) {
        return (A)withUrl(new String(arg1));
    }

    public A withNewUrl(byte[] arg1,int arg2) {
        return (A)withUrl(new String(arg1, arg2));
    }

    public A withNewUrl(byte[] arg1) {
        return (A)withUrl(new String(arg1));
    }

    public A withNewUrl(char[] arg1,int arg2,int arg3) {
        return (A)withUrl(new String(arg1, arg2, arg3));
    }

    public A withNewUrl(byte[] arg1,int arg2,int arg3) {
        return (A)withUrl(new String(arg1, arg2, arg3));
    }

    public A withNewUrl(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withUrl(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewUrl(String arg1) {
        return (A)withUrl(new String(arg1));
    }

    public A addToConnectorPlugins(int index,ConnectorPlugin item) {
        if (this.connectorPlugins == null) {this.connectorPlugins = new ArrayList<ConnectorPluginBuilder>();}
        ConnectorPluginBuilder builder = new ConnectorPluginBuilder(item);_visitables.get("connectorPlugins").add(index >= 0 ? index : _visitables.get("connectorPlugins").size(), builder);this.connectorPlugins.add(index >= 0 ? index : connectorPlugins.size(), builder); return (A)this;
    }

    public A setToConnectorPlugins(int index,ConnectorPlugin item) {
        if (this.connectorPlugins == null) {this.connectorPlugins = new ArrayList<ConnectorPluginBuilder>();}
        ConnectorPluginBuilder builder = new ConnectorPluginBuilder(item);
        if (index < 0 || index >= _visitables.get("connectorPlugins").size()) { _visitables.get("connectorPlugins").add(builder); } else { _visitables.get("connectorPlugins").set(index, builder);}
        if (index < 0 || index >= connectorPlugins.size()) { connectorPlugins.add(builder); } else { connectorPlugins.set(index, builder);}
         return (A)this;
    }

    public A addToConnectorPlugins(ConnectorPlugin... items) {
        if (this.connectorPlugins == null) {this.connectorPlugins = new ArrayList<ConnectorPluginBuilder>();}
        for (ConnectorPlugin item : items) {ConnectorPluginBuilder builder = new ConnectorPluginBuilder(item);_visitables.get("connectorPlugins").add(builder);this.connectorPlugins.add(builder);} return (A)this;
    }

    public A addAllToConnectorPlugins(Collection<ConnectorPlugin> items) {
        if (this.connectorPlugins == null) {this.connectorPlugins = new ArrayList<ConnectorPluginBuilder>();}
        for (ConnectorPlugin item : items) {ConnectorPluginBuilder builder = new ConnectorPluginBuilder(item);_visitables.get("connectorPlugins").add(builder);this.connectorPlugins.add(builder);} return (A)this;
    }

    public A removeFromConnectorPlugins(ConnectorPlugin... items) {
        for (ConnectorPlugin item : items) {ConnectorPluginBuilder builder = new ConnectorPluginBuilder(item);_visitables.get("connectorPlugins").remove(builder);if (this.connectorPlugins != null) {this.connectorPlugins.remove(builder);}} return (A)this;
    }

    public A removeAllFromConnectorPlugins(Collection<ConnectorPlugin> items) {
        for (ConnectorPlugin item : items) {ConnectorPluginBuilder builder = new ConnectorPluginBuilder(item);_visitables.get("connectorPlugins").remove(builder);if (this.connectorPlugins != null) {this.connectorPlugins.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConnectorPlugins(Predicate<ConnectorPluginBuilder> predicate) {
        if (connectorPlugins == null) return (A) this;
        final Iterator<ConnectorPluginBuilder> each = connectorPlugins.iterator();
        final List visitables = _visitables.get("connectorPlugins");
        while (each.hasNext()) {
          ConnectorPluginBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConnectorPlugins instead.
 * @return The buildable object.
 */
@Deprecated public java.util.List<ConnectorPlugin> getConnectorPlugins() {
        return build(connectorPlugins);
    }

    public java.util.List<ConnectorPlugin> buildConnectorPlugins() {
        return build(connectorPlugins);
    }

    public ConnectorPlugin buildConnectorPlugin(int index) {
        return this.connectorPlugins.get(index).build();
    }

    public ConnectorPlugin buildFirstConnectorPlugin() {
        return this.connectorPlugins.get(0).build();
    }

    public ConnectorPlugin buildLastConnectorPlugin() {
        return this.connectorPlugins.get(connectorPlugins.size() - 1).build();
    }

    public ConnectorPlugin buildMatchingConnectorPlugin(Predicate<ConnectorPluginBuilder> predicate) {
        for (ConnectorPluginBuilder item: connectorPlugins) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingConnectorPlugin(Predicate<ConnectorPluginBuilder> predicate) {
        for (ConnectorPluginBuilder item: connectorPlugins) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConnectorPlugins(java.util.List<ConnectorPlugin> connectorPlugins) {
        if (this.connectorPlugins != null) { _visitables.get("connectorPlugins").removeAll(this.connectorPlugins);}
        if (connectorPlugins != null) {this.connectorPlugins = new ArrayList<ConnectorPluginBuilder>(); for (ConnectorPlugin item : connectorPlugins){this.addToConnectorPlugins(item);}} else { this.connectorPlugins = null;} return (A) this;
    }

    public A withConnectorPlugins(ConnectorPlugin... connectorPlugins) {
        if (this.connectorPlugins != null) {this.connectorPlugins.clear();}
        if (connectorPlugins != null) {for (ConnectorPlugin item :connectorPlugins){ this.addToConnectorPlugins(item);}} return (A) this;
    }

    public Boolean hasConnectorPlugins() {
        return connectorPlugins != null && !connectorPlugins.isEmpty();
    }

    public KafkaConnectStatusFluent.ConnectorPluginsNested<A> addNewConnectorPlugin() {
        return new ConnectorPluginsNestedImpl();
    }

    public KafkaConnectStatusFluent.ConnectorPluginsNested<A> addNewConnectorPluginLike(ConnectorPlugin item) {
        return new ConnectorPluginsNestedImpl(-1, item);
    }

    public KafkaConnectStatusFluent.ConnectorPluginsNested<A> setNewConnectorPluginLike(int index,ConnectorPlugin item) {
        return new ConnectorPluginsNestedImpl(index, item);
    }

    public KafkaConnectStatusFluent.ConnectorPluginsNested<A> editConnectorPlugin(int index) {
        if (connectorPlugins.size() <= index) throw new RuntimeException("Can't edit connectorPlugins. Index exceeds size.");
        return setNewConnectorPluginLike(index, buildConnectorPlugin(index));
    }

    public KafkaConnectStatusFluent.ConnectorPluginsNested<A> editFirstConnectorPlugin() {
        if (connectorPlugins.size() == 0) throw new RuntimeException("Can't edit first connectorPlugins. The list is empty.");
        return setNewConnectorPluginLike(0, buildConnectorPlugin(0));
    }

    public KafkaConnectStatusFluent.ConnectorPluginsNested<A> editLastConnectorPlugin() {
        int index = connectorPlugins.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last connectorPlugins. The list is empty.");
        return setNewConnectorPluginLike(index, buildConnectorPlugin(index));
    }

    public KafkaConnectStatusFluent.ConnectorPluginsNested<A> editMatchingConnectorPlugin(Predicate<ConnectorPluginBuilder> predicate) {
        int index = -1;
        for (int i=0;i<connectorPlugins.size();i++) { 
        if (predicate.test(connectorPlugins.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching connectorPlugins. No match found.");
        return setNewConnectorPluginLike(index, buildConnectorPlugin(index));
    }

    public int getReplicas() {
        return this.replicas;
    }

    public A withReplicas(int replicas) {
        this.replicas=replicas; return (A) this;
    }

    public Boolean hasReplicas() {
        return true;
    }

    public String getLabelSelector() {
        return this.labelSelector;
    }

    public A withLabelSelector(String labelSelector) {
        this.labelSelector=labelSelector; return (A) this;
    }

    public Boolean hasLabelSelector() {
        return this.labelSelector != null;
    }

    public A withNewLabelSelector(StringBuilder arg1) {
        return (A)withLabelSelector(new String(arg1));
    }

    public A withNewLabelSelector(int[] arg1,int arg2,int arg3) {
        return (A)withLabelSelector(new String(arg1, arg2, arg3));
    }

    public A withNewLabelSelector(char[] arg1) {
        return (A)withLabelSelector(new String(arg1));
    }

    public A withNewLabelSelector(StringBuffer arg1) {
        return (A)withLabelSelector(new String(arg1));
    }

    public A withNewLabelSelector(byte[] arg1,int arg2) {
        return (A)withLabelSelector(new String(arg1, arg2));
    }

    public A withNewLabelSelector(byte[] arg1) {
        return (A)withLabelSelector(new String(arg1));
    }

    public A withNewLabelSelector(char[] arg1,int arg2,int arg3) {
        return (A)withLabelSelector(new String(arg1, arg2, arg3));
    }

    public A withNewLabelSelector(byte[] arg1,int arg2,int arg3) {
        return (A)withLabelSelector(new String(arg1, arg2, arg3));
    }

    public A withNewLabelSelector(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withLabelSelector(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewLabelSelector(String arg1) {
        return (A)withLabelSelector(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaConnectStatusFluentImpl that = (KafkaConnectStatusFluentImpl) o;
        if (url != null ? !url.equals(that.url) :that.url != null) return false;
        if (connectorPlugins != null ? !connectorPlugins.equals(that.connectorPlugins) :that.connectorPlugins != null) return false;
        if (replicas != that.replicas) return false;
        if (labelSelector != null ? !labelSelector.equals(that.labelSelector) :that.labelSelector != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(url,  connectorPlugins,  replicas,  labelSelector,  super.hashCode());
    }

    public class ConnectorPluginsNestedImpl<N> extends ConnectorPluginFluentImpl<KafkaConnectStatusFluent.ConnectorPluginsNested<N>> implements KafkaConnectStatusFluent.ConnectorPluginsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ConnectorPluginBuilder builder;
        private final int index;

            ConnectorPluginsNestedImpl(int index,ConnectorPlugin item) {
                this.index = index;
                this.builder = new ConnectorPluginBuilder(this, item);
                        
            }

            ConnectorPluginsNestedImpl() {
                this.index = -1;
                this.builder = new ConnectorPluginBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaConnectStatusFluentImpl.this.setToConnectorPlugins(index,builder.build());
            }

            public N endConnectorPlugin() {
                return and();
            }
    }


}
