package io.strimzi.api.kafka.model.status;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class KafkaConnectS2IStatusFluentImpl<A extends KafkaConnectS2IStatusFluent<A>> extends KafkaConnectStatusFluentImpl<A> implements KafkaConnectS2IStatusFluent<A> {

    private String buildConfigName;

    public KafkaConnectS2IStatusFluentImpl() {
    }

    public KafkaConnectS2IStatusFluentImpl(KafkaConnectS2IStatus instance) {
        this.withBuildConfigName(instance.getBuildConfigName());
        
        this.withUrl(instance.getUrl());
        
        this.withConnectorPlugins(instance.getConnectorPlugins());
        
        this.withReplicas(instance.getReplicas());
        
        this.withLabelSelector(instance.getLabelSelector());
        
        this.withConditions(instance.getConditions());
        
        this.withObservedGeneration(instance.getObservedGeneration());
    }

    public String getBuildConfigName() {
        return this.buildConfigName;
    }

    public A withBuildConfigName(String buildConfigName) {
        this.buildConfigName=buildConfigName; return (A) this;
    }

    public Boolean hasBuildConfigName() {
        return this.buildConfigName != null;
    }

    public A withNewBuildConfigName(StringBuilder arg1) {
        return (A)withBuildConfigName(new String(arg1));
    }

    public A withNewBuildConfigName(int[] arg1,int arg2,int arg3) {
        return (A)withBuildConfigName(new String(arg1, arg2, arg3));
    }

    public A withNewBuildConfigName(char[] arg1) {
        return (A)withBuildConfigName(new String(arg1));
    }

    public A withNewBuildConfigName(StringBuffer arg1) {
        return (A)withBuildConfigName(new String(arg1));
    }

    public A withNewBuildConfigName(byte[] arg1,int arg2) {
        return (A)withBuildConfigName(new String(arg1, arg2));
    }

    public A withNewBuildConfigName(byte[] arg1) {
        return (A)withBuildConfigName(new String(arg1));
    }

    public A withNewBuildConfigName(char[] arg1,int arg2,int arg3) {
        return (A)withBuildConfigName(new String(arg1, arg2, arg3));
    }

    public A withNewBuildConfigName(byte[] arg1,int arg2,int arg3) {
        return (A)withBuildConfigName(new String(arg1, arg2, arg3));
    }

    public A withNewBuildConfigName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withBuildConfigName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewBuildConfigName(String arg1) {
        return (A)withBuildConfigName(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaConnectS2IStatusFluentImpl that = (KafkaConnectS2IStatusFluentImpl) o;
        if (buildConfigName != null ? !buildConfigName.equals(that.buildConfigName) :that.buildConfigName != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(buildConfigName,  super.hashCode());
    }

}
