package io.strimzi.api.kafka.model.listener.arraylistener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.strimzi.api.kafka.model.listener.NodeAddressType;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.strimzi.api.kafka.model.template.IpFamilyPolicy;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.CertAndKeySecretSource;
import io.strimzi.api.kafka.model.template.IpFamily;
import io.strimzi.api.kafka.model.CertAndKeySecretSourceBuilder;
import java.lang.Integer;
import java.lang.StringBuffer;
import io.strimzi.api.kafka.model.CertAndKeySecretSourceFluentImpl;
import java.util.Collection;
import java.lang.Object;
import io.strimzi.api.kafka.model.template.ExternalTrafficPolicy;

public class GenericKafkaListenerConfigurationFluentImpl<A extends GenericKafkaListenerConfigurationFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements GenericKafkaListenerConfigurationFluent<A> {

    private CertAndKeySecretSourceBuilder brokerCertChainAndKey;
    private String ingressClass;
    private NodeAddressType preferredNodePortAddressType;
    private ExternalTrafficPolicy externalTrafficPolicy;
    private java.util.List<String> loadBalancerSourceRanges;
    private java.util.List<String> finalizers;
    private Boolean useServiceDnsDomain;
    private GenericKafkaListenerConfigurationBootstrapBuilder bootstrap;
    private java.util.List<GenericKafkaListenerConfigurationBrokerBuilder> brokers;
    private Integer maxConnections;
    private Integer maxConnectionCreationRate;
    private IpFamilyPolicy ipFamilyPolicy;
    private java.util.List<IpFamily> ipFamilies;

    public GenericKafkaListenerConfigurationFluentImpl() {
    }

    public GenericKafkaListenerConfigurationFluentImpl(GenericKafkaListenerConfiguration instance) {
        this.withBrokerCertChainAndKey(instance.getBrokerCertChainAndKey());
        
        this.withIngressClass(instance.getIngressClass());
        
        this.withPreferredNodePortAddressType(instance.getPreferredNodePortAddressType());
        
        this.withExternalTrafficPolicy(instance.getExternalTrafficPolicy());
        
        this.withLoadBalancerSourceRanges(instance.getLoadBalancerSourceRanges());
        
        this.withFinalizers(instance.getFinalizers());
        
        this.withUseServiceDnsDomain(instance.getUseServiceDnsDomain());
        
        this.withBootstrap(instance.getBootstrap());
        
        this.withBrokers(instance.getBrokers());
        
        this.withMaxConnections(instance.getMaxConnections());
        
        this.withMaxConnectionCreationRate(instance.getMaxConnectionCreationRate());
        
        this.withIpFamilyPolicy(instance.getIpFamilyPolicy());
        
        this.withIpFamilies(instance.getIpFamilies());
    }

    
/**
 * This method has been deprecated, please use method buildBrokerCertChainAndKey instead.
 * @return The buildable object.
 */
@Deprecated public CertAndKeySecretSource getBrokerCertChainAndKey() {
        return this.brokerCertChainAndKey!=null?this.brokerCertChainAndKey.build():null;
    }

    public CertAndKeySecretSource buildBrokerCertChainAndKey() {
        return this.brokerCertChainAndKey!=null?this.brokerCertChainAndKey.build():null;
    }

    public A withBrokerCertChainAndKey(CertAndKeySecretSource brokerCertChainAndKey) {
        _visitables.get("brokerCertChainAndKey").remove(this.brokerCertChainAndKey);
        if (brokerCertChainAndKey!=null){ this.brokerCertChainAndKey= new CertAndKeySecretSourceBuilder(brokerCertChainAndKey); _visitables.get("brokerCertChainAndKey").add(this.brokerCertChainAndKey);} return (A) this;
    }

    public Boolean hasBrokerCertChainAndKey() {
        return this.brokerCertChainAndKey != null;
    }

    public GenericKafkaListenerConfigurationFluent.BrokerCertChainAndKeyNested<A> withNewBrokerCertChainAndKey() {
        return new BrokerCertChainAndKeyNestedImpl();
    }

    public GenericKafkaListenerConfigurationFluent.BrokerCertChainAndKeyNested<A> withNewBrokerCertChainAndKeyLike(CertAndKeySecretSource item) {
        return new BrokerCertChainAndKeyNestedImpl(item);
    }

    public GenericKafkaListenerConfigurationFluent.BrokerCertChainAndKeyNested<A> editBrokerCertChainAndKey() {
        return withNewBrokerCertChainAndKeyLike(getBrokerCertChainAndKey());
    }

    public GenericKafkaListenerConfigurationFluent.BrokerCertChainAndKeyNested<A> editOrNewBrokerCertChainAndKey() {
        return withNewBrokerCertChainAndKeyLike(getBrokerCertChainAndKey() != null ? getBrokerCertChainAndKey(): new CertAndKeySecretSourceBuilder().build());
    }

    public GenericKafkaListenerConfigurationFluent.BrokerCertChainAndKeyNested<A> editOrNewBrokerCertChainAndKeyLike(CertAndKeySecretSource item) {
        return withNewBrokerCertChainAndKeyLike(getBrokerCertChainAndKey() != null ? getBrokerCertChainAndKey(): item);
    }

    public String getIngressClass() {
        return this.ingressClass;
    }

    public A withIngressClass(String ingressClass) {
        this.ingressClass=ingressClass; return (A) this;
    }

    public Boolean hasIngressClass() {
        return this.ingressClass != null;
    }

    public A withNewIngressClass(StringBuilder arg1) {
        return (A)withIngressClass(new String(arg1));
    }

    public A withNewIngressClass(int[] arg1,int arg2,int arg3) {
        return (A)withIngressClass(new String(arg1, arg2, arg3));
    }

    public A withNewIngressClass(char[] arg1) {
        return (A)withIngressClass(new String(arg1));
    }

    public A withNewIngressClass(StringBuffer arg1) {
        return (A)withIngressClass(new String(arg1));
    }

    public A withNewIngressClass(byte[] arg1,int arg2) {
        return (A)withIngressClass(new String(arg1, arg2));
    }

    public A withNewIngressClass(byte[] arg1) {
        return (A)withIngressClass(new String(arg1));
    }

    public A withNewIngressClass(char[] arg1,int arg2,int arg3) {
        return (A)withIngressClass(new String(arg1, arg2, arg3));
    }

    public A withNewIngressClass(byte[] arg1,int arg2,int arg3) {
        return (A)withIngressClass(new String(arg1, arg2, arg3));
    }

    public A withNewIngressClass(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withIngressClass(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewIngressClass(String arg1) {
        return (A)withIngressClass(new String(arg1));
    }

    public NodeAddressType getPreferredNodePortAddressType() {
        return this.preferredNodePortAddressType;
    }

    public A withPreferredNodePortAddressType(NodeAddressType preferredNodePortAddressType) {
        this.preferredNodePortAddressType=preferredNodePortAddressType; return (A) this;
    }

    public Boolean hasPreferredNodePortAddressType() {
        return this.preferredNodePortAddressType != null;
    }

    public ExternalTrafficPolicy getExternalTrafficPolicy() {
        return this.externalTrafficPolicy;
    }

    public A withExternalTrafficPolicy(ExternalTrafficPolicy externalTrafficPolicy) {
        this.externalTrafficPolicy=externalTrafficPolicy; return (A) this;
    }

    public Boolean hasExternalTrafficPolicy() {
        return this.externalTrafficPolicy != null;
    }

    public A addToLoadBalancerSourceRanges(int index,String item) {
        if (this.loadBalancerSourceRanges == null) {this.loadBalancerSourceRanges = new ArrayList<String>();}
        this.loadBalancerSourceRanges.add(index, item);
        return (A)this;
    }

    public A setToLoadBalancerSourceRanges(int index,String item) {
        if (this.loadBalancerSourceRanges == null) {this.loadBalancerSourceRanges = new ArrayList<String>();}
        this.loadBalancerSourceRanges.set(index, item); return (A)this;
    }

    public A addToLoadBalancerSourceRanges(String... items) {
        if (this.loadBalancerSourceRanges == null) {this.loadBalancerSourceRanges = new ArrayList<String>();}
        for (String item : items) {this.loadBalancerSourceRanges.add(item);} return (A)this;
    }

    public A addAllToLoadBalancerSourceRanges(Collection<String> items) {
        if (this.loadBalancerSourceRanges == null) {this.loadBalancerSourceRanges = new ArrayList<String>();}
        for (String item : items) {this.loadBalancerSourceRanges.add(item);} return (A)this;
    }

    public A removeFromLoadBalancerSourceRanges(String... items) {
        for (String item : items) {if (this.loadBalancerSourceRanges!= null){ this.loadBalancerSourceRanges.remove(item);}} return (A)this;
    }

    public A removeAllFromLoadBalancerSourceRanges(Collection<String> items) {
        for (String item : items) {if (this.loadBalancerSourceRanges!= null){ this.loadBalancerSourceRanges.remove(item);}} return (A)this;
    }

    public java.util.List<String> getLoadBalancerSourceRanges() {
        return this.loadBalancerSourceRanges;
    }

    public String getLoadBalancerSourceRange(int index) {
        return this.loadBalancerSourceRanges.get(index);
    }

    public String getFirstLoadBalancerSourceRange() {
        return this.loadBalancerSourceRanges.get(0);
    }

    public String getLastLoadBalancerSourceRange() {
        return this.loadBalancerSourceRanges.get(loadBalancerSourceRanges.size() - 1);
    }

    public String getMatchingLoadBalancerSourceRange(Predicate<String> predicate) {
        for (String item: loadBalancerSourceRanges) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingLoadBalancerSourceRange(Predicate<String> predicate) {
        for (String item: loadBalancerSourceRanges) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withLoadBalancerSourceRanges(java.util.List<String> loadBalancerSourceRanges) {
        if (this.loadBalancerSourceRanges != null) { _visitables.get("loadBalancerSourceRanges").removeAll(this.loadBalancerSourceRanges);}
        if (loadBalancerSourceRanges != null) {this.loadBalancerSourceRanges = new ArrayList<String>(); for (String item : loadBalancerSourceRanges){this.addToLoadBalancerSourceRanges(item);}} else { this.loadBalancerSourceRanges = null;} return (A) this;
    }

    public A withLoadBalancerSourceRanges(String... loadBalancerSourceRanges) {
        if (this.loadBalancerSourceRanges != null) {this.loadBalancerSourceRanges.clear();}
        if (loadBalancerSourceRanges != null) {for (String item :loadBalancerSourceRanges){ this.addToLoadBalancerSourceRanges(item);}} return (A) this;
    }

    public Boolean hasLoadBalancerSourceRanges() {
        return loadBalancerSourceRanges != null && !loadBalancerSourceRanges.isEmpty();
    }

    public A addNewLoadBalancerSourceRange(StringBuilder arg1) {
        return (A)addToLoadBalancerSourceRanges(new String(arg1));
    }

    public A addNewLoadBalancerSourceRange(int[] arg1,int arg2,int arg3) {
        return (A)addToLoadBalancerSourceRanges(new String(arg1, arg2, arg3));
    }

    public A addNewLoadBalancerSourceRange(char[] arg1) {
        return (A)addToLoadBalancerSourceRanges(new String(arg1));
    }

    public A addNewLoadBalancerSourceRange(StringBuffer arg1) {
        return (A)addToLoadBalancerSourceRanges(new String(arg1));
    }

    public A addNewLoadBalancerSourceRange(byte[] arg1,int arg2) {
        return (A)addToLoadBalancerSourceRanges(new String(arg1, arg2));
    }

    public A addNewLoadBalancerSourceRange(byte[] arg1) {
        return (A)addToLoadBalancerSourceRanges(new String(arg1));
    }

    public A addNewLoadBalancerSourceRange(char[] arg1,int arg2,int arg3) {
        return (A)addToLoadBalancerSourceRanges(new String(arg1, arg2, arg3));
    }

    public A addNewLoadBalancerSourceRange(byte[] arg1,int arg2,int arg3) {
        return (A)addToLoadBalancerSourceRanges(new String(arg1, arg2, arg3));
    }

    public A addNewLoadBalancerSourceRange(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToLoadBalancerSourceRanges(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewLoadBalancerSourceRange(String arg1) {
        return (A)addToLoadBalancerSourceRanges(new String(arg1));
    }

    public A addToFinalizers(int index,String item) {
        if (this.finalizers == null) {this.finalizers = new ArrayList<String>();}
        this.finalizers.add(index, item);
        return (A)this;
    }

    public A setToFinalizers(int index,String item) {
        if (this.finalizers == null) {this.finalizers = new ArrayList<String>();}
        this.finalizers.set(index, item); return (A)this;
    }

    public A addToFinalizers(String... items) {
        if (this.finalizers == null) {this.finalizers = new ArrayList<String>();}
        for (String item : items) {this.finalizers.add(item);} return (A)this;
    }

    public A addAllToFinalizers(Collection<String> items) {
        if (this.finalizers == null) {this.finalizers = new ArrayList<String>();}
        for (String item : items) {this.finalizers.add(item);} return (A)this;
    }

    public A removeFromFinalizers(String... items) {
        for (String item : items) {if (this.finalizers!= null){ this.finalizers.remove(item);}} return (A)this;
    }

    public A removeAllFromFinalizers(Collection<String> items) {
        for (String item : items) {if (this.finalizers!= null){ this.finalizers.remove(item);}} return (A)this;
    }

    public java.util.List<String> getFinalizers() {
        return this.finalizers;
    }

    public String getFinalizer(int index) {
        return this.finalizers.get(index);
    }

    public String getFirstFinalizer() {
        return this.finalizers.get(0);
    }

    public String getLastFinalizer() {
        return this.finalizers.get(finalizers.size() - 1);
    }

    public String getMatchingFinalizer(Predicate<String> predicate) {
        for (String item: finalizers) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingFinalizer(Predicate<String> predicate) {
        for (String item: finalizers) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withFinalizers(java.util.List<String> finalizers) {
        if (this.finalizers != null) { _visitables.get("finalizers").removeAll(this.finalizers);}
        if (finalizers != null) {this.finalizers = new ArrayList<String>(); for (String item : finalizers){this.addToFinalizers(item);}} else { this.finalizers = null;} return (A) this;
    }

    public A withFinalizers(String... finalizers) {
        if (this.finalizers != null) {this.finalizers.clear();}
        if (finalizers != null) {for (String item :finalizers){ this.addToFinalizers(item);}} return (A) this;
    }

    public Boolean hasFinalizers() {
        return finalizers != null && !finalizers.isEmpty();
    }

    public A addNewFinalizer(StringBuilder arg1) {
        return (A)addToFinalizers(new String(arg1));
    }

    public A addNewFinalizer(int[] arg1,int arg2,int arg3) {
        return (A)addToFinalizers(new String(arg1, arg2, arg3));
    }

    public A addNewFinalizer(char[] arg1) {
        return (A)addToFinalizers(new String(arg1));
    }

    public A addNewFinalizer(StringBuffer arg1) {
        return (A)addToFinalizers(new String(arg1));
    }

    public A addNewFinalizer(byte[] arg1,int arg2) {
        return (A)addToFinalizers(new String(arg1, arg2));
    }

    public A addNewFinalizer(byte[] arg1) {
        return (A)addToFinalizers(new String(arg1));
    }

    public A addNewFinalizer(char[] arg1,int arg2,int arg3) {
        return (A)addToFinalizers(new String(arg1, arg2, arg3));
    }

    public A addNewFinalizer(byte[] arg1,int arg2,int arg3) {
        return (A)addToFinalizers(new String(arg1, arg2, arg3));
    }

    public A addNewFinalizer(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToFinalizers(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewFinalizer(String arg1) {
        return (A)addToFinalizers(new String(arg1));
    }

    public Boolean getUseServiceDnsDomain() {
        return this.useServiceDnsDomain;
    }

    public A withUseServiceDnsDomain(Boolean useServiceDnsDomain) {
        this.useServiceDnsDomain=useServiceDnsDomain; return (A) this;
    }

    public Boolean hasUseServiceDnsDomain() {
        return this.useServiceDnsDomain != null;
    }

    public A withNewUseServiceDnsDomain(String arg1) {
        return (A)withUseServiceDnsDomain(new Boolean(arg1));
    }

    public A withNewUseServiceDnsDomain(boolean arg1) {
        return (A)withUseServiceDnsDomain(new Boolean(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildBootstrap instead.
 * @return The buildable object.
 */
@Deprecated public GenericKafkaListenerConfigurationBootstrap getBootstrap() {
        return this.bootstrap!=null?this.bootstrap.build():null;
    }

    public GenericKafkaListenerConfigurationBootstrap buildBootstrap() {
        return this.bootstrap!=null?this.bootstrap.build():null;
    }

    public A withBootstrap(GenericKafkaListenerConfigurationBootstrap bootstrap) {
        _visitables.get("bootstrap").remove(this.bootstrap);
        if (bootstrap!=null){ this.bootstrap= new GenericKafkaListenerConfigurationBootstrapBuilder(bootstrap); _visitables.get("bootstrap").add(this.bootstrap);} return (A) this;
    }

    public Boolean hasBootstrap() {
        return this.bootstrap != null;
    }

    public GenericKafkaListenerConfigurationFluent.BootstrapNested<A> withNewBootstrap() {
        return new BootstrapNestedImpl();
    }

    public GenericKafkaListenerConfigurationFluent.BootstrapNested<A> withNewBootstrapLike(GenericKafkaListenerConfigurationBootstrap item) {
        return new BootstrapNestedImpl(item);
    }

    public GenericKafkaListenerConfigurationFluent.BootstrapNested<A> editBootstrap() {
        return withNewBootstrapLike(getBootstrap());
    }

    public GenericKafkaListenerConfigurationFluent.BootstrapNested<A> editOrNewBootstrap() {
        return withNewBootstrapLike(getBootstrap() != null ? getBootstrap(): new GenericKafkaListenerConfigurationBootstrapBuilder().build());
    }

    public GenericKafkaListenerConfigurationFluent.BootstrapNested<A> editOrNewBootstrapLike(GenericKafkaListenerConfigurationBootstrap item) {
        return withNewBootstrapLike(getBootstrap() != null ? getBootstrap(): item);
    }

    public A addToBrokers(int index,GenericKafkaListenerConfigurationBroker item) {
        if (this.brokers == null) {this.brokers = new ArrayList<GenericKafkaListenerConfigurationBrokerBuilder>();}
        GenericKafkaListenerConfigurationBrokerBuilder builder = new GenericKafkaListenerConfigurationBrokerBuilder(item);_visitables.get("brokers").add(index >= 0 ? index : _visitables.get("brokers").size(), builder);this.brokers.add(index >= 0 ? index : brokers.size(), builder); return (A)this;
    }

    public A setToBrokers(int index,GenericKafkaListenerConfigurationBroker item) {
        if (this.brokers == null) {this.brokers = new ArrayList<GenericKafkaListenerConfigurationBrokerBuilder>();}
        GenericKafkaListenerConfigurationBrokerBuilder builder = new GenericKafkaListenerConfigurationBrokerBuilder(item);
        if (index < 0 || index >= _visitables.get("brokers").size()) { _visitables.get("brokers").add(builder); } else { _visitables.get("brokers").set(index, builder);}
        if (index < 0 || index >= brokers.size()) { brokers.add(builder); } else { brokers.set(index, builder);}
         return (A)this;
    }

    public A addToBrokers(GenericKafkaListenerConfigurationBroker... items) {
        if (this.brokers == null) {this.brokers = new ArrayList<GenericKafkaListenerConfigurationBrokerBuilder>();}
        for (GenericKafkaListenerConfigurationBroker item : items) {GenericKafkaListenerConfigurationBrokerBuilder builder = new GenericKafkaListenerConfigurationBrokerBuilder(item);_visitables.get("brokers").add(builder);this.brokers.add(builder);} return (A)this;
    }

    public A addAllToBrokers(Collection<GenericKafkaListenerConfigurationBroker> items) {
        if (this.brokers == null) {this.brokers = new ArrayList<GenericKafkaListenerConfigurationBrokerBuilder>();}
        for (GenericKafkaListenerConfigurationBroker item : items) {GenericKafkaListenerConfigurationBrokerBuilder builder = new GenericKafkaListenerConfigurationBrokerBuilder(item);_visitables.get("brokers").add(builder);this.brokers.add(builder);} return (A)this;
    }

    public A removeFromBrokers(GenericKafkaListenerConfigurationBroker... items) {
        for (GenericKafkaListenerConfigurationBroker item : items) {GenericKafkaListenerConfigurationBrokerBuilder builder = new GenericKafkaListenerConfigurationBrokerBuilder(item);_visitables.get("brokers").remove(builder);if (this.brokers != null) {this.brokers.remove(builder);}} return (A)this;
    }

    public A removeAllFromBrokers(Collection<GenericKafkaListenerConfigurationBroker> items) {
        for (GenericKafkaListenerConfigurationBroker item : items) {GenericKafkaListenerConfigurationBrokerBuilder builder = new GenericKafkaListenerConfigurationBrokerBuilder(item);_visitables.get("brokers").remove(builder);if (this.brokers != null) {this.brokers.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromBrokers(Predicate<GenericKafkaListenerConfigurationBrokerBuilder> predicate) {
        if (brokers == null) return (A) this;
        final Iterator<GenericKafkaListenerConfigurationBrokerBuilder> each = brokers.iterator();
        final List visitables = _visitables.get("brokers");
        while (each.hasNext()) {
          GenericKafkaListenerConfigurationBrokerBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildBrokers instead.
 * @return The buildable object.
 */
@Deprecated public java.util.List<GenericKafkaListenerConfigurationBroker> getBrokers() {
        return build(brokers);
    }

    public java.util.List<GenericKafkaListenerConfigurationBroker> buildBrokers() {
        return build(brokers);
    }

    public GenericKafkaListenerConfigurationBroker buildBroker(int index) {
        return this.brokers.get(index).build();
    }

    public GenericKafkaListenerConfigurationBroker buildFirstBroker() {
        return this.brokers.get(0).build();
    }

    public GenericKafkaListenerConfigurationBroker buildLastBroker() {
        return this.brokers.get(brokers.size() - 1).build();
    }

    public GenericKafkaListenerConfigurationBroker buildMatchingBroker(Predicate<GenericKafkaListenerConfigurationBrokerBuilder> predicate) {
        for (GenericKafkaListenerConfigurationBrokerBuilder item: brokers) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingBroker(Predicate<GenericKafkaListenerConfigurationBrokerBuilder> predicate) {
        for (GenericKafkaListenerConfigurationBrokerBuilder item: brokers) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withBrokers(java.util.List<GenericKafkaListenerConfigurationBroker> brokers) {
        if (this.brokers != null) { _visitables.get("brokers").removeAll(this.brokers);}
        if (brokers != null) {this.brokers = new ArrayList<GenericKafkaListenerConfigurationBrokerBuilder>(); for (GenericKafkaListenerConfigurationBroker item : brokers){this.addToBrokers(item);}} else { this.brokers = null;} return (A) this;
    }

    public A withBrokers(GenericKafkaListenerConfigurationBroker... brokers) {
        if (this.brokers != null) {this.brokers.clear();}
        if (brokers != null) {for (GenericKafkaListenerConfigurationBroker item :brokers){ this.addToBrokers(item);}} return (A) this;
    }

    public Boolean hasBrokers() {
        return brokers != null && !brokers.isEmpty();
    }

    public GenericKafkaListenerConfigurationFluent.BrokersNested<A> addNewBroker() {
        return new BrokersNestedImpl();
    }

    public GenericKafkaListenerConfigurationFluent.BrokersNested<A> addNewBrokerLike(GenericKafkaListenerConfigurationBroker item) {
        return new BrokersNestedImpl(-1, item);
    }

    public GenericKafkaListenerConfigurationFluent.BrokersNested<A> setNewBrokerLike(int index,GenericKafkaListenerConfigurationBroker item) {
        return new BrokersNestedImpl(index, item);
    }

    public GenericKafkaListenerConfigurationFluent.BrokersNested<A> editBroker(int index) {
        if (brokers.size() <= index) throw new RuntimeException("Can't edit brokers. Index exceeds size.");
        return setNewBrokerLike(index, buildBroker(index));
    }

    public GenericKafkaListenerConfigurationFluent.BrokersNested<A> editFirstBroker() {
        if (brokers.size() == 0) throw new RuntimeException("Can't edit first brokers. The list is empty.");
        return setNewBrokerLike(0, buildBroker(0));
    }

    public GenericKafkaListenerConfigurationFluent.BrokersNested<A> editLastBroker() {
        int index = brokers.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last brokers. The list is empty.");
        return setNewBrokerLike(index, buildBroker(index));
    }

    public GenericKafkaListenerConfigurationFluent.BrokersNested<A> editMatchingBroker(Predicate<GenericKafkaListenerConfigurationBrokerBuilder> predicate) {
        int index = -1;
        for (int i=0;i<brokers.size();i++) { 
        if (predicate.test(brokers.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching brokers. No match found.");
        return setNewBrokerLike(index, buildBroker(index));
    }

    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    public A withMaxConnections(Integer maxConnections) {
        this.maxConnections=maxConnections; return (A) this;
    }

    public Boolean hasMaxConnections() {
        return this.maxConnections != null;
    }

    public Integer getMaxConnectionCreationRate() {
        return this.maxConnectionCreationRate;
    }

    public A withMaxConnectionCreationRate(Integer maxConnectionCreationRate) {
        this.maxConnectionCreationRate=maxConnectionCreationRate; return (A) this;
    }

    public Boolean hasMaxConnectionCreationRate() {
        return this.maxConnectionCreationRate != null;
    }

    public IpFamilyPolicy getIpFamilyPolicy() {
        return this.ipFamilyPolicy;
    }

    public A withIpFamilyPolicy(IpFamilyPolicy ipFamilyPolicy) {
        this.ipFamilyPolicy=ipFamilyPolicy; return (A) this;
    }

    public Boolean hasIpFamilyPolicy() {
        return this.ipFamilyPolicy != null;
    }

    public A addToIpFamilies(int index,IpFamily item) {
        if (this.ipFamilies == null) {this.ipFamilies = new ArrayList<IpFamily>();}
        this.ipFamilies.add(index, item);
        return (A)this;
    }

    public A setToIpFamilies(int index,IpFamily item) {
        if (this.ipFamilies == null) {this.ipFamilies = new ArrayList<IpFamily>();}
        this.ipFamilies.set(index, item); return (A)this;
    }

    public A addToIpFamilies(IpFamily... items) {
        if (this.ipFamilies == null) {this.ipFamilies = new ArrayList<IpFamily>();}
        for (IpFamily item : items) {this.ipFamilies.add(item);} return (A)this;
    }

    public A addAllToIpFamilies(Collection<IpFamily> items) {
        if (this.ipFamilies == null) {this.ipFamilies = new ArrayList<IpFamily>();}
        for (IpFamily item : items) {this.ipFamilies.add(item);} return (A)this;
    }

    public A removeFromIpFamilies(IpFamily... items) {
        for (IpFamily item : items) {if (this.ipFamilies!= null){ this.ipFamilies.remove(item);}} return (A)this;
    }

    public A removeAllFromIpFamilies(Collection<IpFamily> items) {
        for (IpFamily item : items) {if (this.ipFamilies!= null){ this.ipFamilies.remove(item);}} return (A)this;
    }

    public java.util.List<IpFamily> getIpFamilies() {
        return this.ipFamilies;
    }

    public IpFamily getIpFamily(int index) {
        return this.ipFamilies.get(index);
    }

    public IpFamily getFirstIpFamily() {
        return this.ipFamilies.get(0);
    }

    public IpFamily getLastIpFamily() {
        return this.ipFamilies.get(ipFamilies.size() - 1);
    }

    public IpFamily getMatchingIpFamily(Predicate<IpFamily> predicate) {
        for (IpFamily item: ipFamilies) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingIpFamily(Predicate<IpFamily> predicate) {
        for (IpFamily item: ipFamilies) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withIpFamilies(java.util.List<IpFamily> ipFamilies) {
        if (this.ipFamilies != null) { _visitables.get("ipFamilies").removeAll(this.ipFamilies);}
        if (ipFamilies != null) {this.ipFamilies = new ArrayList<IpFamily>(); for (IpFamily item : ipFamilies){this.addToIpFamilies(item);}} else { this.ipFamilies = null;} return (A) this;
    }

    public A withIpFamilies(IpFamily... ipFamilies) {
        if (this.ipFamilies != null) {this.ipFamilies.clear();}
        if (ipFamilies != null) {for (IpFamily item :ipFamilies){ this.addToIpFamilies(item);}} return (A) this;
    }

    public Boolean hasIpFamilies() {
        return ipFamilies != null && !ipFamilies.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GenericKafkaListenerConfigurationFluentImpl that = (GenericKafkaListenerConfigurationFluentImpl) o;
        if (brokerCertChainAndKey != null ? !brokerCertChainAndKey.equals(that.brokerCertChainAndKey) :that.brokerCertChainAndKey != null) return false;
        if (ingressClass != null ? !ingressClass.equals(that.ingressClass) :that.ingressClass != null) return false;
        if (preferredNodePortAddressType != null ? !preferredNodePortAddressType.equals(that.preferredNodePortAddressType) :that.preferredNodePortAddressType != null) return false;
        if (externalTrafficPolicy != null ? !externalTrafficPolicy.equals(that.externalTrafficPolicy) :that.externalTrafficPolicy != null) return false;
        if (loadBalancerSourceRanges != null ? !loadBalancerSourceRanges.equals(that.loadBalancerSourceRanges) :that.loadBalancerSourceRanges != null) return false;
        if (finalizers != null ? !finalizers.equals(that.finalizers) :that.finalizers != null) return false;
        if (useServiceDnsDomain != null ? !useServiceDnsDomain.equals(that.useServiceDnsDomain) :that.useServiceDnsDomain != null) return false;
        if (bootstrap != null ? !bootstrap.equals(that.bootstrap) :that.bootstrap != null) return false;
        if (brokers != null ? !brokers.equals(that.brokers) :that.brokers != null) return false;
        if (maxConnections != null ? !maxConnections.equals(that.maxConnections) :that.maxConnections != null) return false;
        if (maxConnectionCreationRate != null ? !maxConnectionCreationRate.equals(that.maxConnectionCreationRate) :that.maxConnectionCreationRate != null) return false;
        if (ipFamilyPolicy != null ? !ipFamilyPolicy.equals(that.ipFamilyPolicy) :that.ipFamilyPolicy != null) return false;
        if (ipFamilies != null ? !ipFamilies.equals(that.ipFamilies) :that.ipFamilies != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(brokerCertChainAndKey,  ingressClass,  preferredNodePortAddressType,  externalTrafficPolicy,  loadBalancerSourceRanges,  finalizers,  useServiceDnsDomain,  bootstrap,  brokers,  maxConnections,  maxConnectionCreationRate,  ipFamilyPolicy,  ipFamilies,  super.hashCode());
    }

    public class BrokerCertChainAndKeyNestedImpl<N> extends CertAndKeySecretSourceFluentImpl<GenericKafkaListenerConfigurationFluent.BrokerCertChainAndKeyNested<N>> implements GenericKafkaListenerConfigurationFluent.BrokerCertChainAndKeyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final CertAndKeySecretSourceBuilder builder;

            BrokerCertChainAndKeyNestedImpl(CertAndKeySecretSource item) {
                this.builder = new CertAndKeySecretSourceBuilder(this, item);
                        
            }

            BrokerCertChainAndKeyNestedImpl() {
                this.builder = new CertAndKeySecretSourceBuilder(this);
                        
            }

            public N and() {
                return (N) GenericKafkaListenerConfigurationFluentImpl.this.withBrokerCertChainAndKey(builder.build());
            }

            public N endBrokerCertChainAndKey() {
                return and();
            }
    }


    public class BootstrapNestedImpl<N> extends GenericKafkaListenerConfigurationBootstrapFluentImpl<GenericKafkaListenerConfigurationFluent.BootstrapNested<N>> implements GenericKafkaListenerConfigurationFluent.BootstrapNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final GenericKafkaListenerConfigurationBootstrapBuilder builder;

            BootstrapNestedImpl(GenericKafkaListenerConfigurationBootstrap item) {
                this.builder = new GenericKafkaListenerConfigurationBootstrapBuilder(this, item);
                        
            }

            BootstrapNestedImpl() {
                this.builder = new GenericKafkaListenerConfigurationBootstrapBuilder(this);
                        
            }

            public N and() {
                return (N) GenericKafkaListenerConfigurationFluentImpl.this.withBootstrap(builder.build());
            }

            public N endBootstrap() {
                return and();
            }
    }


    public class BrokersNestedImpl<N> extends GenericKafkaListenerConfigurationBrokerFluentImpl<GenericKafkaListenerConfigurationFluent.BrokersNested<N>> implements GenericKafkaListenerConfigurationFluent.BrokersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final GenericKafkaListenerConfigurationBrokerBuilder builder;
        private final int index;

            BrokersNestedImpl(int index,GenericKafkaListenerConfigurationBroker item) {
                this.index = index;
                this.builder = new GenericKafkaListenerConfigurationBrokerBuilder(this, item);
                        
            }

            BrokersNestedImpl() {
                this.index = -1;
                this.builder = new GenericKafkaListenerConfigurationBrokerBuilder(this);
                        
            }

            public N and() {
                return (N) GenericKafkaListenerConfigurationFluentImpl.this.setToBrokers(index,builder.build());
            }

            public N endBroker() {
                return and();
            }
    }


}
