package io.strimzi.api.kafka.model.listener.arraylistener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.listener.KafkaListeners;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.strimzi.api.kafka.model.listener.KafkaListenersBuilder;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.listener.KafkaListenersFluent;

public interface ArrayOrObjectKafkaListenersFluent<A extends ArrayOrObjectKafkaListenersFluent<A>> extends Fluent<A> {


    public A addToGenericKafkaListeners(int index,GenericKafkaListener item);
    public A setToGenericKafkaListeners(int index,GenericKafkaListener item);
    public A addToGenericKafkaListeners(GenericKafkaListener... items);
    public A addAllToGenericKafkaListeners(Collection<GenericKafkaListener> items);
    public A removeFromGenericKafkaListeners(GenericKafkaListener... items);
    public A removeAllFromGenericKafkaListeners(Collection<GenericKafkaListener> items);
    public A removeMatchingFromGenericKafkaListeners(Predicate<GenericKafkaListenerBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildGenericKafkaListeners instead.
 * @return The buildable object.
 */
@Deprecated public java.util.List<GenericKafkaListener> getGenericKafkaListeners();
    public java.util.List<GenericKafkaListener> buildGenericKafkaListeners();
    public GenericKafkaListener buildGenericKafkaListener(int index);
    public GenericKafkaListener buildFirstGenericKafkaListener();
    public GenericKafkaListener buildLastGenericKafkaListener();
    public GenericKafkaListener buildMatchingGenericKafkaListener(Predicate<GenericKafkaListenerBuilder> predicate);
    public Boolean hasMatchingGenericKafkaListener(Predicate<GenericKafkaListenerBuilder> predicate);
    public A withGenericKafkaListeners(java.util.List<GenericKafkaListener> genericKafkaListeners);
    public A withGenericKafkaListeners(GenericKafkaListener... genericKafkaListeners);
    public Boolean hasGenericKafkaListeners();
    public ArrayOrObjectKafkaListenersFluent.GenericKafkaListenersNested<A> addNewGenericKafkaListener();
    public ArrayOrObjectKafkaListenersFluent.GenericKafkaListenersNested<A> addNewGenericKafkaListenerLike(GenericKafkaListener item);
    public ArrayOrObjectKafkaListenersFluent.GenericKafkaListenersNested<A> setNewGenericKafkaListenerLike(int index,GenericKafkaListener item);
    public ArrayOrObjectKafkaListenersFluent.GenericKafkaListenersNested<A> editGenericKafkaListener(int index);
    public ArrayOrObjectKafkaListenersFluent.GenericKafkaListenersNested<A> editFirstGenericKafkaListener();
    public ArrayOrObjectKafkaListenersFluent.GenericKafkaListenersNested<A> editLastGenericKafkaListener();
    public ArrayOrObjectKafkaListenersFluent.GenericKafkaListenersNested<A> editMatchingGenericKafkaListener(Predicate<GenericKafkaListenerBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildKafkaListeners instead.
 * @return The buildable object.
 */
@Deprecated public KafkaListeners getKafkaListeners();
    public KafkaListeners buildKafkaListeners();
    public A withKafkaListeners(KafkaListeners kafkaListeners);
    public Boolean hasKafkaListeners();
    public ArrayOrObjectKafkaListenersFluent.KafkaListenersNested<A> withNewKafkaListeners();
    public ArrayOrObjectKafkaListenersFluent.KafkaListenersNested<A> withNewKafkaListenersLike(KafkaListeners item);
    public ArrayOrObjectKafkaListenersFluent.KafkaListenersNested<A> editKafkaListeners();
    public ArrayOrObjectKafkaListenersFluent.KafkaListenersNested<A> editOrNewKafkaListeners();
    public ArrayOrObjectKafkaListenersFluent.KafkaListenersNested<A> editOrNewKafkaListenersLike(KafkaListeners item);
    public interface GenericKafkaListenersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,GenericKafkaListenerFluent<ArrayOrObjectKafkaListenersFluent.GenericKafkaListenersNested<N>> {

            public N and();
            public N endGenericKafkaListener();    }


    public interface KafkaListenersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaListenersFluent<ArrayOrObjectKafkaListenersFluent.KafkaListenersNested<N>> {

            public N and();
            public N endKafkaListeners();    }


}
