package io.strimzi.api.kafka.model.listener.arraylistener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ArrayOrObjectKafkaListenersBuilder extends ArrayOrObjectKafkaListenersFluentImpl<ArrayOrObjectKafkaListenersBuilder> implements VisitableBuilder<ArrayOrObjectKafkaListeners,ArrayOrObjectKafkaListenersBuilder> {

    ArrayOrObjectKafkaListenersFluent<?> fluent;
    Boolean validationEnabled;

    public ArrayOrObjectKafkaListenersBuilder() {
        this(true);
    }

    public ArrayOrObjectKafkaListenersBuilder(Boolean validationEnabled) {
        this.fluent = this; this.validationEnabled=validationEnabled;
    }

    public ArrayOrObjectKafkaListenersBuilder(ArrayOrObjectKafkaListenersFluent<?> fluent) {
        this(fluent, true);
    }

    public ArrayOrObjectKafkaListenersBuilder(ArrayOrObjectKafkaListenersFluent<?> fluent,Boolean validationEnabled) {
        this.fluent = fluent; this.validationEnabled=validationEnabled;
    }

    public ArrayOrObjectKafkaListenersBuilder(ArrayOrObjectKafkaListenersFluent<?> fluent,ArrayOrObjectKafkaListeners instance) {
        this(fluent, instance, true);
    }

    public ArrayOrObjectKafkaListenersBuilder(ArrayOrObjectKafkaListenersFluent<?> fluent,ArrayOrObjectKafkaListeners instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withGenericKafkaListeners(instance.getGenericKafkaListeners()); 
        fluent.withKafkaListeners(instance.getKafkaListeners()); 
        this.validationEnabled = validationEnabled; 
    }

    public ArrayOrObjectKafkaListenersBuilder(ArrayOrObjectKafkaListeners instance) {
        this(instance,true);
    }

    public ArrayOrObjectKafkaListenersBuilder(ArrayOrObjectKafkaListeners instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withGenericKafkaListeners(instance.getGenericKafkaListeners()); 
        this.withKafkaListeners(instance.getKafkaListeners()); 
        this.validationEnabled = validationEnabled; 
    }

    public ArrayOrObjectKafkaListeners build() {
        ArrayOrObjectKafkaListeners buildable = new ArrayOrObjectKafkaListeners(fluent.getGenericKafkaListeners(),fluent.getKafkaListeners());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ArrayOrObjectKafkaListenersBuilder that = (ArrayOrObjectKafkaListenersBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
