package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TlsListenerConfigurationBuilder extends TlsListenerConfigurationFluentImpl<TlsListenerConfigurationBuilder> implements VisitableBuilder<TlsListenerConfiguration,TlsListenerConfigurationBuilder> {

    TlsListenerConfigurationFluent<?> fluent;
    Boolean validationEnabled;

    public TlsListenerConfigurationBuilder() {
        this(true);
    }

    public TlsListenerConfigurationBuilder(Boolean validationEnabled) {
        this(new TlsListenerConfiguration(), validationEnabled);
    }

    public TlsListenerConfigurationBuilder(TlsListenerConfigurationFluent<?> fluent) {
        this(fluent, true);
    }

    public TlsListenerConfigurationBuilder(TlsListenerConfigurationFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new TlsListenerConfiguration(), validationEnabled);
    }

    public TlsListenerConfigurationBuilder(TlsListenerConfigurationFluent<?> fluent,TlsListenerConfiguration instance) {
        this(fluent, instance, true);
    }

    public TlsListenerConfigurationBuilder(TlsListenerConfigurationFluent<?> fluent,TlsListenerConfiguration instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withBrokerCertChainAndKey(instance.getBrokerCertChainAndKey());
        
        this.validationEnabled = validationEnabled; 
    }

    public TlsListenerConfigurationBuilder(TlsListenerConfiguration instance) {
        this(instance,true);
    }

    public TlsListenerConfigurationBuilder(TlsListenerConfiguration instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withBrokerCertChainAndKey(instance.getBrokerCertChainAndKey());
        
        this.validationEnabled = validationEnabled; 
    }

    public TlsListenerConfiguration build() {
        TlsListenerConfiguration buildable = new TlsListenerConfiguration();
        buildable.setBrokerCertChainAndKey(fluent.getBrokerCertChainAndKey());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        TlsListenerConfigurationBuilder that = (TlsListenerConfigurationBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
