package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RouteListenerBrokerOverrideBuilder extends RouteListenerBrokerOverrideFluentImpl<RouteListenerBrokerOverrideBuilder> implements VisitableBuilder<RouteListenerBrokerOverride,RouteListenerBrokerOverrideBuilder> {

    RouteListenerBrokerOverrideFluent<?> fluent;
    Boolean validationEnabled;

    public RouteListenerBrokerOverrideBuilder() {
        this(true);
    }

    public RouteListenerBrokerOverrideBuilder(Boolean validationEnabled) {
        this(new RouteListenerBrokerOverride(), validationEnabled);
    }

    public RouteListenerBrokerOverrideBuilder(RouteListenerBrokerOverrideFluent<?> fluent) {
        this(fluent, true);
    }

    public RouteListenerBrokerOverrideBuilder(RouteListenerBrokerOverrideFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new RouteListenerBrokerOverride(), validationEnabled);
    }

    public RouteListenerBrokerOverrideBuilder(RouteListenerBrokerOverrideFluent<?> fluent,RouteListenerBrokerOverride instance) {
        this(fluent, instance, true);
    }

    public RouteListenerBrokerOverrideBuilder(RouteListenerBrokerOverrideFluent<?> fluent,RouteListenerBrokerOverride instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withHost(instance.getHost());
        
        fluent.withBroker(instance.getBroker());
        
        fluent.withAdvertisedHost(instance.getAdvertisedHost());
        
        fluent.withAdvertisedPort(instance.getAdvertisedPort());
        
        this.validationEnabled = validationEnabled; 
    }

    public RouteListenerBrokerOverrideBuilder(RouteListenerBrokerOverride instance) {
        this(instance,true);
    }

    public RouteListenerBrokerOverrideBuilder(RouteListenerBrokerOverride instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withHost(instance.getHost());
        
        this.withBroker(instance.getBroker());
        
        this.withAdvertisedHost(instance.getAdvertisedHost());
        
        this.withAdvertisedPort(instance.getAdvertisedPort());
        
        this.validationEnabled = validationEnabled; 
    }

    public RouteListenerBrokerOverride build() {
        RouteListenerBrokerOverride buildable = new RouteListenerBrokerOverride();
        buildable.setBroker(fluent.getBroker());
        buildable.setAdvertisedHost(fluent.getAdvertisedHost());
        buildable.setAdvertisedPort(fluent.getAdvertisedPort());
        buildable.setHost(fluent.getHost());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        RouteListenerBrokerOverrideBuilder that = (RouteListenerBrokerOverrideBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
