package io.strimzi.api.kafka.model.listener;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class RouteListenerBootstrapOverrideFluentImpl<A extends RouteListenerBootstrapOverrideFluent<A>> extends ExternalListenerBootstrapOverrideFluentImpl<A> implements RouteListenerBootstrapOverrideFluent<A> {

    private String host;

    public RouteListenerBootstrapOverrideFluentImpl() {
    }

    public RouteListenerBootstrapOverrideFluentImpl(RouteListenerBootstrapOverride instance) {
        this.withHost(instance.getHost());
        
        this.withAddress(instance.getAddress());
    }

    public String getHost() {
        return this.host;
    }

    public A withHost(String host) {
        this.host=host; return (A) this;
    }

    public Boolean hasHost() {
        return this.host != null;
    }

    public A withNewHost(StringBuilder arg1) {
        return (A)withHost(new String(arg1));
    }

    public A withNewHost(int[] arg1,int arg2,int arg3) {
        return (A)withHost(new String(arg1, arg2, arg3));
    }

    public A withNewHost(char[] arg1) {
        return (A)withHost(new String(arg1));
    }

    public A withNewHost(StringBuffer arg1) {
        return (A)withHost(new String(arg1));
    }

    public A withNewHost(byte[] arg1,int arg2) {
        return (A)withHost(new String(arg1, arg2));
    }

    public A withNewHost(byte[] arg1) {
        return (A)withHost(new String(arg1));
    }

    public A withNewHost(char[] arg1,int arg2,int arg3) {
        return (A)withHost(new String(arg1, arg2, arg3));
    }

    public A withNewHost(byte[] arg1,int arg2,int arg3) {
        return (A)withHost(new String(arg1, arg2, arg3));
    }

    public A withNewHost(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withHost(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewHost(String arg1) {
        return (A)withHost(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        RouteListenerBootstrapOverrideFluentImpl that = (RouteListenerBootstrapOverrideFluentImpl) o;
        if (host != null ? !host.equals(that.host) :that.host != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(host,  super.hashCode());
    }

}
