package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NodePortListenerConfigurationBuilder extends NodePortListenerConfigurationFluentImpl<NodePortListenerConfigurationBuilder> implements VisitableBuilder<NodePortListenerConfiguration,NodePortListenerConfigurationBuilder> {

    NodePortListenerConfigurationFluent<?> fluent;
    Boolean validationEnabled;

    public NodePortListenerConfigurationBuilder() {
        this(true);
    }

    public NodePortListenerConfigurationBuilder(Boolean validationEnabled) {
        this(new NodePortListenerConfiguration(), validationEnabled);
    }

    public NodePortListenerConfigurationBuilder(NodePortListenerConfigurationFluent<?> fluent) {
        this(fluent, true);
    }

    public NodePortListenerConfigurationBuilder(NodePortListenerConfigurationFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new NodePortListenerConfiguration(), validationEnabled);
    }

    public NodePortListenerConfigurationBuilder(NodePortListenerConfigurationFluent<?> fluent,NodePortListenerConfiguration instance) {
        this(fluent, instance, true);
    }

    public NodePortListenerConfigurationBuilder(NodePortListenerConfigurationFluent<?> fluent,NodePortListenerConfiguration instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withPreferredAddressType(instance.getPreferredAddressType());
        
        fluent.withBrokerCertChainAndKey(instance.getBrokerCertChainAndKey());
        
        this.validationEnabled = validationEnabled; 
    }

    public NodePortListenerConfigurationBuilder(NodePortListenerConfiguration instance) {
        this(instance,true);
    }

    public NodePortListenerConfigurationBuilder(NodePortListenerConfiguration instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withPreferredAddressType(instance.getPreferredAddressType());
        
        this.withBrokerCertChainAndKey(instance.getBrokerCertChainAndKey());
        
        this.validationEnabled = validationEnabled; 
    }

    public NodePortListenerConfiguration build() {
        NodePortListenerConfiguration buildable = new NodePortListenerConfiguration();
        buildable.setBrokerCertChainAndKey(fluent.getBrokerCertChainAndKey());
        buildable.setPreferredAddressType(fluent.getPreferredAddressType());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        NodePortListenerConfigurationBuilder that = (NodePortListenerConfigurationBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
