package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class LoadBalancerListenerOverrideFluentImpl<A extends LoadBalancerListenerOverrideFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements LoadBalancerListenerOverrideFluent<A> {

    private LoadBalancerListenerBootstrapOverrideBuilder bootstrap;
    private java.util.List<LoadBalancerListenerBrokerOverrideBuilder> brokers;

    public LoadBalancerListenerOverrideFluentImpl() {
    }

    public LoadBalancerListenerOverrideFluentImpl(LoadBalancerListenerOverride instance) {
        this.withBootstrap(instance.getBootstrap());
        
        this.withBrokers(instance.getBrokers());
    }

    
/**
 * This method has been deprecated, please use method buildBootstrap instead.
 * @return The buildable object.
 */
@Deprecated public LoadBalancerListenerBootstrapOverride getBootstrap() {
        return this.bootstrap!=null?this.bootstrap.build():null;
    }

    public LoadBalancerListenerBootstrapOverride buildBootstrap() {
        return this.bootstrap!=null?this.bootstrap.build():null;
    }

    public A withBootstrap(LoadBalancerListenerBootstrapOverride bootstrap) {
        _visitables.get("bootstrap").remove(this.bootstrap);
        if (bootstrap!=null){ this.bootstrap= new LoadBalancerListenerBootstrapOverrideBuilder(bootstrap); _visitables.get("bootstrap").add(this.bootstrap);} return (A) this;
    }

    public Boolean hasBootstrap() {
        return this.bootstrap != null;
    }

    public LoadBalancerListenerOverrideFluent.BootstrapNested<A> withNewBootstrap() {
        return new BootstrapNestedImpl();
    }

    public LoadBalancerListenerOverrideFluent.BootstrapNested<A> withNewBootstrapLike(LoadBalancerListenerBootstrapOverride item) {
        return new BootstrapNestedImpl(item);
    }

    public LoadBalancerListenerOverrideFluent.BootstrapNested<A> editBootstrap() {
        return withNewBootstrapLike(getBootstrap());
    }

    public LoadBalancerListenerOverrideFluent.BootstrapNested<A> editOrNewBootstrap() {
        return withNewBootstrapLike(getBootstrap() != null ? getBootstrap(): new LoadBalancerListenerBootstrapOverrideBuilder().build());
    }

    public LoadBalancerListenerOverrideFluent.BootstrapNested<A> editOrNewBootstrapLike(LoadBalancerListenerBootstrapOverride item) {
        return withNewBootstrapLike(getBootstrap() != null ? getBootstrap(): item);
    }

    public A addToBrokers(int index,LoadBalancerListenerBrokerOverride item) {
        if (this.brokers == null) {this.brokers = new ArrayList<LoadBalancerListenerBrokerOverrideBuilder>();}
        LoadBalancerListenerBrokerOverrideBuilder builder = new LoadBalancerListenerBrokerOverrideBuilder(item);_visitables.get("brokers").add(index >= 0 ? index : _visitables.get("brokers").size(), builder);this.brokers.add(index >= 0 ? index : brokers.size(), builder); return (A)this;
    }

    public A setToBrokers(int index,LoadBalancerListenerBrokerOverride item) {
        if (this.brokers == null) {this.brokers = new ArrayList<LoadBalancerListenerBrokerOverrideBuilder>();}
        LoadBalancerListenerBrokerOverrideBuilder builder = new LoadBalancerListenerBrokerOverrideBuilder(item);
        if (index < 0 || index >= _visitables.get("brokers").size()) { _visitables.get("brokers").add(builder); } else { _visitables.get("brokers").set(index, builder);}
        if (index < 0 || index >= brokers.size()) { brokers.add(builder); } else { brokers.set(index, builder);}
         return (A)this;
    }

    public A addToBrokers(LoadBalancerListenerBrokerOverride... items) {
        if (this.brokers == null) {this.brokers = new ArrayList<LoadBalancerListenerBrokerOverrideBuilder>();}
        for (LoadBalancerListenerBrokerOverride item : items) {LoadBalancerListenerBrokerOverrideBuilder builder = new LoadBalancerListenerBrokerOverrideBuilder(item);_visitables.get("brokers").add(builder);this.brokers.add(builder);} return (A)this;
    }

    public A addAllToBrokers(Collection<LoadBalancerListenerBrokerOverride> items) {
        if (this.brokers == null) {this.brokers = new ArrayList<LoadBalancerListenerBrokerOverrideBuilder>();}
        for (LoadBalancerListenerBrokerOverride item : items) {LoadBalancerListenerBrokerOverrideBuilder builder = new LoadBalancerListenerBrokerOverrideBuilder(item);_visitables.get("brokers").add(builder);this.brokers.add(builder);} return (A)this;
    }

    public A removeFromBrokers(LoadBalancerListenerBrokerOverride... items) {
        for (LoadBalancerListenerBrokerOverride item : items) {LoadBalancerListenerBrokerOverrideBuilder builder = new LoadBalancerListenerBrokerOverrideBuilder(item);_visitables.get("brokers").remove(builder);if (this.brokers != null) {this.brokers.remove(builder);}} return (A)this;
    }

    public A removeAllFromBrokers(Collection<LoadBalancerListenerBrokerOverride> items) {
        for (LoadBalancerListenerBrokerOverride item : items) {LoadBalancerListenerBrokerOverrideBuilder builder = new LoadBalancerListenerBrokerOverrideBuilder(item);_visitables.get("brokers").remove(builder);if (this.brokers != null) {this.brokers.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromBrokers(Predicate<LoadBalancerListenerBrokerOverrideBuilder> predicate) {
        if (brokers == null) return (A) this;
        final Iterator<LoadBalancerListenerBrokerOverrideBuilder> each = brokers.iterator();
        final List visitables = _visitables.get("brokers");
        while (each.hasNext()) {
          LoadBalancerListenerBrokerOverrideBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildBrokers instead.
 * @return The buildable object.
 */
@Deprecated public java.util.List<LoadBalancerListenerBrokerOverride> getBrokers() {
        return build(brokers);
    }

    public java.util.List<LoadBalancerListenerBrokerOverride> buildBrokers() {
        return build(brokers);
    }

    public LoadBalancerListenerBrokerOverride buildBroker(int index) {
        return this.brokers.get(index).build();
    }

    public LoadBalancerListenerBrokerOverride buildFirstBroker() {
        return this.brokers.get(0).build();
    }

    public LoadBalancerListenerBrokerOverride buildLastBroker() {
        return this.brokers.get(brokers.size() - 1).build();
    }

    public LoadBalancerListenerBrokerOverride buildMatchingBroker(Predicate<LoadBalancerListenerBrokerOverrideBuilder> predicate) {
        for (LoadBalancerListenerBrokerOverrideBuilder item: brokers) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingBroker(Predicate<LoadBalancerListenerBrokerOverrideBuilder> predicate) {
        for (LoadBalancerListenerBrokerOverrideBuilder item: brokers) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withBrokers(java.util.List<LoadBalancerListenerBrokerOverride> brokers) {
        if (this.brokers != null) { _visitables.get("brokers").removeAll(this.brokers);}
        if (brokers != null) {this.brokers = new ArrayList<LoadBalancerListenerBrokerOverrideBuilder>(); for (LoadBalancerListenerBrokerOverride item : brokers){this.addToBrokers(item);}} else { this.brokers = null;} return (A) this;
    }

    public A withBrokers(LoadBalancerListenerBrokerOverride... brokers) {
        if (this.brokers != null) {this.brokers.clear();}
        if (brokers != null) {for (LoadBalancerListenerBrokerOverride item :brokers){ this.addToBrokers(item);}} return (A) this;
    }

    public Boolean hasBrokers() {
        return brokers != null && !brokers.isEmpty();
    }

    public LoadBalancerListenerOverrideFluent.BrokersNested<A> addNewBroker() {
        return new BrokersNestedImpl();
    }

    public LoadBalancerListenerOverrideFluent.BrokersNested<A> addNewBrokerLike(LoadBalancerListenerBrokerOverride item) {
        return new BrokersNestedImpl(-1, item);
    }

    public LoadBalancerListenerOverrideFluent.BrokersNested<A> setNewBrokerLike(int index,LoadBalancerListenerBrokerOverride item) {
        return new BrokersNestedImpl(index, item);
    }

    public LoadBalancerListenerOverrideFluent.BrokersNested<A> editBroker(int index) {
        if (brokers.size() <= index) throw new RuntimeException("Can't edit brokers. Index exceeds size.");
        return setNewBrokerLike(index, buildBroker(index));
    }

    public LoadBalancerListenerOverrideFluent.BrokersNested<A> editFirstBroker() {
        if (brokers.size() == 0) throw new RuntimeException("Can't edit first brokers. The list is empty.");
        return setNewBrokerLike(0, buildBroker(0));
    }

    public LoadBalancerListenerOverrideFluent.BrokersNested<A> editLastBroker() {
        int index = brokers.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last brokers. The list is empty.");
        return setNewBrokerLike(index, buildBroker(index));
    }

    public LoadBalancerListenerOverrideFluent.BrokersNested<A> editMatchingBroker(Predicate<LoadBalancerListenerBrokerOverrideBuilder> predicate) {
        int index = -1;
        for (int i=0;i<brokers.size();i++) { 
        if (predicate.test(brokers.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching brokers. No match found.");
        return setNewBrokerLike(index, buildBroker(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        LoadBalancerListenerOverrideFluentImpl that = (LoadBalancerListenerOverrideFluentImpl) o;
        if (bootstrap != null ? !bootstrap.equals(that.bootstrap) :that.bootstrap != null) return false;
        if (brokers != null ? !brokers.equals(that.brokers) :that.brokers != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(bootstrap,  brokers,  super.hashCode());
    }

    public class BootstrapNestedImpl<N> extends LoadBalancerListenerBootstrapOverrideFluentImpl<LoadBalancerListenerOverrideFluent.BootstrapNested<N>> implements LoadBalancerListenerOverrideFluent.BootstrapNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LoadBalancerListenerBootstrapOverrideBuilder builder;

            BootstrapNestedImpl(LoadBalancerListenerBootstrapOverride item) {
                this.builder = new LoadBalancerListenerBootstrapOverrideBuilder(this, item);
                        
            }

            BootstrapNestedImpl() {
                this.builder = new LoadBalancerListenerBootstrapOverrideBuilder(this);
                        
            }

            public N and() {
                return (N) LoadBalancerListenerOverrideFluentImpl.this.withBootstrap(builder.build());
            }

            public N endBootstrap() {
                return and();
            }
    }


    public class BrokersNestedImpl<N> extends LoadBalancerListenerBrokerOverrideFluentImpl<LoadBalancerListenerOverrideFluent.BrokersNested<N>> implements LoadBalancerListenerOverrideFluent.BrokersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LoadBalancerListenerBrokerOverrideBuilder builder;
        private final int index;

            BrokersNestedImpl(int index,LoadBalancerListenerBrokerOverride item) {
                this.index = index;
                this.builder = new LoadBalancerListenerBrokerOverrideBuilder(this, item);
                        
            }

            BrokersNestedImpl() {
                this.index = -1;
                this.builder = new LoadBalancerListenerBrokerOverrideBuilder(this);
                        
            }

            public N and() {
                return (N) LoadBalancerListenerOverrideFluentImpl.this.setToBrokers(index,builder.build());
            }

            public N endBroker() {
                return and();
            }
    }


}
