package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class LoadBalancerListenerOverrideBuilder extends LoadBalancerListenerOverrideFluentImpl<LoadBalancerListenerOverrideBuilder> implements VisitableBuilder<LoadBalancerListenerOverride,LoadBalancerListenerOverrideBuilder> {

    LoadBalancerListenerOverrideFluent<?> fluent;
    Boolean validationEnabled;

    public LoadBalancerListenerOverrideBuilder() {
        this(true);
    }

    public LoadBalancerListenerOverrideBuilder(Boolean validationEnabled) {
        this(new LoadBalancerListenerOverride(), validationEnabled);
    }

    public LoadBalancerListenerOverrideBuilder(LoadBalancerListenerOverrideFluent<?> fluent) {
        this(fluent, true);
    }

    public LoadBalancerListenerOverrideBuilder(LoadBalancerListenerOverrideFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new LoadBalancerListenerOverride(), validationEnabled);
    }

    public LoadBalancerListenerOverrideBuilder(LoadBalancerListenerOverrideFluent<?> fluent,LoadBalancerListenerOverride instance) {
        this(fluent, instance, true);
    }

    public LoadBalancerListenerOverrideBuilder(LoadBalancerListenerOverrideFluent<?> fluent,LoadBalancerListenerOverride instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withBootstrap(instance.getBootstrap());
        
        fluent.withBrokers(instance.getBrokers());
        
        this.validationEnabled = validationEnabled; 
    }

    public LoadBalancerListenerOverrideBuilder(LoadBalancerListenerOverride instance) {
        this(instance,true);
    }

    public LoadBalancerListenerOverrideBuilder(LoadBalancerListenerOverride instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withBootstrap(instance.getBootstrap());
        
        this.withBrokers(instance.getBrokers());
        
        this.validationEnabled = validationEnabled; 
    }

    public LoadBalancerListenerOverride build() {
        LoadBalancerListenerOverride buildable = new LoadBalancerListenerOverride();
        buildable.setBootstrap(fluent.getBootstrap());
        buildable.setBrokers(fluent.getBrokers());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        LoadBalancerListenerOverrideBuilder that = (LoadBalancerListenerOverrideBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
