package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaListenerTlsBuilder extends KafkaListenerTlsFluentImpl<KafkaListenerTlsBuilder> implements VisitableBuilder<KafkaListenerTls,KafkaListenerTlsBuilder> {

    KafkaListenerTlsFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaListenerTlsBuilder() {
        this(true);
    }

    public KafkaListenerTlsBuilder(Boolean validationEnabled) {
        this(new KafkaListenerTls(), validationEnabled);
    }

    public KafkaListenerTlsBuilder(KafkaListenerTlsFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaListenerTlsBuilder(KafkaListenerTlsFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KafkaListenerTls(), validationEnabled);
    }

    public KafkaListenerTlsBuilder(KafkaListenerTlsFluent<?> fluent,KafkaListenerTls instance) {
        this(fluent, instance, true);
    }

    public KafkaListenerTlsBuilder(KafkaListenerTlsFluent<?> fluent,KafkaListenerTls instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAuth(instance.getAuth());
        
        fluent.withNetworkPolicyPeers(instance.getNetworkPolicyPeers());
        
        fluent.withConfiguration(instance.getConfiguration());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaListenerTlsBuilder(KafkaListenerTls instance) {
        this(instance,true);
    }

    public KafkaListenerTlsBuilder(KafkaListenerTls instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAuth(instance.getAuth());
        
        this.withNetworkPolicyPeers(instance.getNetworkPolicyPeers());
        
        this.withConfiguration(instance.getConfiguration());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaListenerTls build() {
        KafkaListenerTls buildable = new KafkaListenerTls();
        buildable.setAuth(fluent.getAuth());
        buildable.setNetworkPolicyPeers(fluent.getNetworkPolicyPeers());
        buildable.setConfiguration(fluent.getConfiguration());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaListenerTlsBuilder that = (KafkaListenerTlsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
