package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaListenerExternalRouteBuilder extends KafkaListenerExternalRouteFluentImpl<KafkaListenerExternalRouteBuilder> implements VisitableBuilder<KafkaListenerExternalRoute,KafkaListenerExternalRouteBuilder> {

    KafkaListenerExternalRouteFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaListenerExternalRouteBuilder() {
        this(true);
    }

    public KafkaListenerExternalRouteBuilder(Boolean validationEnabled) {
        this(new KafkaListenerExternalRoute(), validationEnabled);
    }

    public KafkaListenerExternalRouteBuilder(KafkaListenerExternalRouteFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaListenerExternalRouteBuilder(KafkaListenerExternalRouteFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KafkaListenerExternalRoute(), validationEnabled);
    }

    public KafkaListenerExternalRouteBuilder(KafkaListenerExternalRouteFluent<?> fluent,KafkaListenerExternalRoute instance) {
        this(fluent, instance, true);
    }

    public KafkaListenerExternalRouteBuilder(KafkaListenerExternalRouteFluent<?> fluent,KafkaListenerExternalRoute instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAuth(instance.getAuth());
        
        fluent.withNetworkPolicyPeers(instance.getNetworkPolicyPeers());
        
        fluent.withOverrides(instance.getOverrides());
        
        fluent.withConfiguration(instance.getConfiguration());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaListenerExternalRouteBuilder(KafkaListenerExternalRoute instance) {
        this(instance,true);
    }

    public KafkaListenerExternalRouteBuilder(KafkaListenerExternalRoute instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAuth(instance.getAuth());
        
        this.withNetworkPolicyPeers(instance.getNetworkPolicyPeers());
        
        this.withOverrides(instance.getOverrides());
        
        this.withConfiguration(instance.getConfiguration());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaListenerExternalRoute build() {
        KafkaListenerExternalRoute buildable = new KafkaListenerExternalRoute();
        buildable.setAuth(fluent.getAuth());
        buildable.setNetworkPolicyPeers(fluent.getNetworkPolicyPeers());
        buildable.setOverrides(fluent.getOverrides());
        buildable.setConfiguration(fluent.getConfiguration());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaListenerExternalRouteBuilder that = (KafkaListenerExternalRouteBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
