package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

public class KafkaListenerExternalNodePortFluentImpl<A extends KafkaListenerExternalNodePortFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KafkaListenerExternalNodePortFluent<A> {

    private VisitableBuilder<? extends KafkaListenerAuthentication,?> auth;
    private boolean tls;
    private java.util.List<NetworkPolicyPeer> networkPolicyPeers;
    private NodePortListenerOverrideBuilder overrides;
    private NodePortListenerConfigurationBuilder configuration;

    public KafkaListenerExternalNodePortFluentImpl() {
    }

    public KafkaListenerExternalNodePortFluentImpl(KafkaListenerExternalNodePort instance) {
        this.withAuth(instance.getAuth());
        
        this.withTls(instance.isTls());
        
        this.withNetworkPolicyPeers(instance.getNetworkPolicyPeers());
        
        this.withOverrides(instance.getOverrides());
        
        this.withConfiguration(instance.getConfiguration());
    }

    
/**
 * This method has been deprecated, please use method buildAuth instead.
 * @return The buildable object.
 */
@Deprecated public KafkaListenerAuthentication getAuth() {
        return this.auth!=null?this.auth.build():null;
    }

    public KafkaListenerAuthentication buildAuth() {
        return this.auth!=null?this.auth.build():null;
    }

    public A withAuth(KafkaListenerAuthentication auth) {
        _visitables.get("auth").remove(this.auth);
        if (auth instanceof KafkaListenerAuthenticationOAuth){ this.auth= new KafkaListenerAuthenticationOAuthBuilder((KafkaListenerAuthenticationOAuth)auth); _visitables.get("auth").add(this.auth);}
        if (auth instanceof KafkaListenerAuthenticationTls){ this.auth= new KafkaListenerAuthenticationTlsBuilder((KafkaListenerAuthenticationTls)auth); _visitables.get("auth").add(this.auth);}
        if (auth instanceof KafkaListenerAuthenticationScramSha512){ this.auth= new KafkaListenerAuthenticationScramSha512Builder((KafkaListenerAuthenticationScramSha512)auth); _visitables.get("auth").add(this.auth);}
        return (A) this;
    }

    public Boolean hasAuth() {
        return this.auth != null;
    }

    public A withKafkaListenerAuthenticationOAuth(KafkaListenerAuthenticationOAuth kafkaListenerAuthenticationOAuth) {
        _visitables.get("auth").remove(this.auth);
        if (kafkaListenerAuthenticationOAuth!=null){ this.auth= new KafkaListenerAuthenticationOAuthBuilder(kafkaListenerAuthenticationOAuth); _visitables.get("auth").add(this.auth);} return (A) this;
    }

    public KafkaListenerExternalNodePortFluent.KafkaListenerAuthenticationOAuthNested<A> withNewKafkaListenerAuthenticationOAuth() {
        return new KafkaListenerAuthenticationOAuthNestedImpl();
    }

    public KafkaListenerExternalNodePortFluent.KafkaListenerAuthenticationOAuthNested<A> withNewKafkaListenerAuthenticationOAuthLike(KafkaListenerAuthenticationOAuth item) {
        return new KafkaListenerAuthenticationOAuthNestedImpl(item);
    }

    public A withKafkaListenerAuthenticationTlsAuth(KafkaListenerAuthenticationTls kafkaListenerAuthenticationTlsAuth) {
        _visitables.get("auth").remove(this.auth);
        if (kafkaListenerAuthenticationTlsAuth!=null){ this.auth= new KafkaListenerAuthenticationTlsBuilder(kafkaListenerAuthenticationTlsAuth); _visitables.get("auth").add(this.auth);} return (A) this;
    }

    public KafkaListenerExternalNodePortFluent.KafkaListenerAuthenticationTlsAuthNested<A> withNewKafkaListenerAuthenticationTlsAuth() {
        return new KafkaListenerAuthenticationTlsAuthNestedImpl();
    }

    public KafkaListenerExternalNodePortFluent.KafkaListenerAuthenticationTlsAuthNested<A> withNewKafkaListenerAuthenticationTlsAuthLike(KafkaListenerAuthenticationTls item) {
        return new KafkaListenerAuthenticationTlsAuthNestedImpl(item);
    }

    public A withKafkaListenerAuthenticationScramSha512Auth(KafkaListenerAuthenticationScramSha512 kafkaListenerAuthenticationScramSha512Auth) {
        _visitables.get("auth").remove(this.auth);
        if (kafkaListenerAuthenticationScramSha512Auth!=null){ this.auth= new KafkaListenerAuthenticationScramSha512Builder(kafkaListenerAuthenticationScramSha512Auth); _visitables.get("auth").add(this.auth);} return (A) this;
    }

    public KafkaListenerExternalNodePortFluent.KafkaListenerAuthenticationScramSha512AuthNested<A> withNewKafkaListenerAuthenticationScramSha512Auth() {
        return new KafkaListenerAuthenticationScramSha512AuthNestedImpl();
    }

    public KafkaListenerExternalNodePortFluent.KafkaListenerAuthenticationScramSha512AuthNested<A> withNewKafkaListenerAuthenticationScramSha512AuthLike(KafkaListenerAuthenticationScramSha512 item) {
        return new KafkaListenerAuthenticationScramSha512AuthNestedImpl(item);
    }

    public boolean isTls() {
        return this.tls;
    }

    public A withTls(boolean tls) {
        this.tls=tls; return (A) this;
    }

    public Boolean hasTls() {
        return true;
    }

    public A addToNetworkPolicyPeers(int index,NetworkPolicyPeer item) {
        if (this.networkPolicyPeers == null) {this.networkPolicyPeers = new ArrayList<NetworkPolicyPeer>();}
        this.networkPolicyPeers.add(index, item);
        return (A)this;
    }

    public A setToNetworkPolicyPeers(int index,NetworkPolicyPeer item) {
        if (this.networkPolicyPeers == null) {this.networkPolicyPeers = new ArrayList<NetworkPolicyPeer>();}
        this.networkPolicyPeers.set(index, item); return (A)this;
    }

    public A addToNetworkPolicyPeers(NetworkPolicyPeer... items) {
        if (this.networkPolicyPeers == null) {this.networkPolicyPeers = new ArrayList<NetworkPolicyPeer>();}
        for (NetworkPolicyPeer item : items) {this.networkPolicyPeers.add(item);} return (A)this;
    }

    public A addAllToNetworkPolicyPeers(Collection<NetworkPolicyPeer> items) {
        if (this.networkPolicyPeers == null) {this.networkPolicyPeers = new ArrayList<NetworkPolicyPeer>();}
        for (NetworkPolicyPeer item : items) {this.networkPolicyPeers.add(item);} return (A)this;
    }

    public A removeFromNetworkPolicyPeers(NetworkPolicyPeer... items) {
        for (NetworkPolicyPeer item : items) {if (this.networkPolicyPeers!= null){ this.networkPolicyPeers.remove(item);}} return (A)this;
    }

    public A removeAllFromNetworkPolicyPeers(Collection<NetworkPolicyPeer> items) {
        for (NetworkPolicyPeer item : items) {if (this.networkPolicyPeers!= null){ this.networkPolicyPeers.remove(item);}} return (A)this;
    }

    public java.util.List<NetworkPolicyPeer> getNetworkPolicyPeers() {
        return this.networkPolicyPeers;
    }

    public NetworkPolicyPeer getNetworkPolicyPeer(int index) {
        return this.networkPolicyPeers.get(index);
    }

    public NetworkPolicyPeer getFirstNetworkPolicyPeer() {
        return this.networkPolicyPeers.get(0);
    }

    public NetworkPolicyPeer getLastNetworkPolicyPeer() {
        return this.networkPolicyPeers.get(networkPolicyPeers.size() - 1);
    }

    public NetworkPolicyPeer getMatchingNetworkPolicyPeer(Predicate<NetworkPolicyPeer> predicate) {
        for (NetworkPolicyPeer item: networkPolicyPeers) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingNetworkPolicyPeer(Predicate<NetworkPolicyPeer> predicate) {
        for (NetworkPolicyPeer item: networkPolicyPeers) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withNetworkPolicyPeers(java.util.List<NetworkPolicyPeer> networkPolicyPeers) {
        if (this.networkPolicyPeers != null) { _visitables.get("networkPolicyPeers").removeAll(this.networkPolicyPeers);}
        if (networkPolicyPeers != null) {this.networkPolicyPeers = new ArrayList<NetworkPolicyPeer>(); for (NetworkPolicyPeer item : networkPolicyPeers){this.addToNetworkPolicyPeers(item);}} else { this.networkPolicyPeers = null;} return (A) this;
    }

    public A withNetworkPolicyPeers(NetworkPolicyPeer... networkPolicyPeers) {
        if (this.networkPolicyPeers != null) {this.networkPolicyPeers.clear();}
        if (networkPolicyPeers != null) {for (NetworkPolicyPeer item :networkPolicyPeers){ this.addToNetworkPolicyPeers(item);}} return (A) this;
    }

    public Boolean hasNetworkPolicyPeers() {
        return networkPolicyPeers != null && !networkPolicyPeers.isEmpty();
    }

    
/**
 * This method has been deprecated, please use method buildOverrides instead.
 * @return The buildable object.
 */
@Deprecated public NodePortListenerOverride getOverrides() {
        return this.overrides!=null?this.overrides.build():null;
    }

    public NodePortListenerOverride buildOverrides() {
        return this.overrides!=null?this.overrides.build():null;
    }

    public A withOverrides(NodePortListenerOverride overrides) {
        _visitables.get("overrides").remove(this.overrides);
        if (overrides!=null){ this.overrides= new NodePortListenerOverrideBuilder(overrides); _visitables.get("overrides").add(this.overrides);} return (A) this;
    }

    public Boolean hasOverrides() {
        return this.overrides != null;
    }

    public KafkaListenerExternalNodePortFluent.OverridesNested<A> withNewOverrides() {
        return new OverridesNestedImpl();
    }

    public KafkaListenerExternalNodePortFluent.OverridesNested<A> withNewOverridesLike(NodePortListenerOverride item) {
        return new OverridesNestedImpl(item);
    }

    public KafkaListenerExternalNodePortFluent.OverridesNested<A> editOverrides() {
        return withNewOverridesLike(getOverrides());
    }

    public KafkaListenerExternalNodePortFluent.OverridesNested<A> editOrNewOverrides() {
        return withNewOverridesLike(getOverrides() != null ? getOverrides(): new NodePortListenerOverrideBuilder().build());
    }

    public KafkaListenerExternalNodePortFluent.OverridesNested<A> editOrNewOverridesLike(NodePortListenerOverride item) {
        return withNewOverridesLike(getOverrides() != null ? getOverrides(): item);
    }

    
/**
 * This method has been deprecated, please use method buildConfiguration instead.
 * @return The buildable object.
 */
@Deprecated public NodePortListenerConfiguration getConfiguration() {
        return this.configuration!=null?this.configuration.build():null;
    }

    public NodePortListenerConfiguration buildConfiguration() {
        return this.configuration!=null?this.configuration.build():null;
    }

    public A withConfiguration(NodePortListenerConfiguration configuration) {
        _visitables.get("configuration").remove(this.configuration);
        if (configuration!=null){ this.configuration= new NodePortListenerConfigurationBuilder(configuration); _visitables.get("configuration").add(this.configuration);} return (A) this;
    }

    public Boolean hasConfiguration() {
        return this.configuration != null;
    }

    public KafkaListenerExternalNodePortFluent.ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNestedImpl();
    }

    public KafkaListenerExternalNodePortFluent.ConfigurationNested<A> withNewConfigurationLike(NodePortListenerConfiguration item) {
        return new ConfigurationNestedImpl(item);
    }

    public KafkaListenerExternalNodePortFluent.ConfigurationNested<A> editConfiguration() {
        return withNewConfigurationLike(getConfiguration());
    }

    public KafkaListenerExternalNodePortFluent.ConfigurationNested<A> editOrNewConfiguration() {
        return withNewConfigurationLike(getConfiguration() != null ? getConfiguration(): new NodePortListenerConfigurationBuilder().build());
    }

    public KafkaListenerExternalNodePortFluent.ConfigurationNested<A> editOrNewConfigurationLike(NodePortListenerConfiguration item) {
        return withNewConfigurationLike(getConfiguration() != null ? getConfiguration(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KafkaListenerExternalNodePortFluentImpl that = (KafkaListenerExternalNodePortFluentImpl) o;
        if (auth != null ? !auth.equals(that.auth) :that.auth != null) return false;
        if (tls != that.tls) return false;
        if (networkPolicyPeers != null ? !networkPolicyPeers.equals(that.networkPolicyPeers) :that.networkPolicyPeers != null) return false;
        if (overrides != null ? !overrides.equals(that.overrides) :that.overrides != null) return false;
        if (configuration != null ? !configuration.equals(that.configuration) :that.configuration != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(auth,  tls,  networkPolicyPeers,  overrides,  configuration,  super.hashCode());
    }

    public class KafkaListenerAuthenticationOAuthNestedImpl<N> extends KafkaListenerAuthenticationOAuthFluentImpl<KafkaListenerExternalNodePortFluent.KafkaListenerAuthenticationOAuthNested<N>> implements KafkaListenerExternalNodePortFluent.KafkaListenerAuthenticationOAuthNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KafkaListenerAuthenticationOAuthBuilder builder;

            KafkaListenerAuthenticationOAuthNestedImpl(KafkaListenerAuthenticationOAuth item) {
                this.builder = new KafkaListenerAuthenticationOAuthBuilder(this, item);
                        
            }

            KafkaListenerAuthenticationOAuthNestedImpl() {
                this.builder = new KafkaListenerAuthenticationOAuthBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaListenerExternalNodePortFluentImpl.this.withAuth(builder.build());
            }

            public N endKafkaListenerAuthenticationOAuth() {
                return and();
            }
    }


    public class KafkaListenerAuthenticationTlsAuthNestedImpl<N> extends KafkaListenerAuthenticationTlsFluentImpl<KafkaListenerExternalNodePortFluent.KafkaListenerAuthenticationTlsAuthNested<N>> implements KafkaListenerExternalNodePortFluent.KafkaListenerAuthenticationTlsAuthNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KafkaListenerAuthenticationTlsBuilder builder;

            KafkaListenerAuthenticationTlsAuthNestedImpl(KafkaListenerAuthenticationTls item) {
                this.builder = new KafkaListenerAuthenticationTlsBuilder(this, item);
                        
            }

            KafkaListenerAuthenticationTlsAuthNestedImpl() {
                this.builder = new KafkaListenerAuthenticationTlsBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaListenerExternalNodePortFluentImpl.this.withAuth(builder.build());
            }

            public N endKafkaListenerAuthenticationTlsAuth() {
                return and();
            }
    }


    public class KafkaListenerAuthenticationScramSha512AuthNestedImpl<N> extends KafkaListenerAuthenticationScramSha512FluentImpl<KafkaListenerExternalNodePortFluent.KafkaListenerAuthenticationScramSha512AuthNested<N>> implements KafkaListenerExternalNodePortFluent.KafkaListenerAuthenticationScramSha512AuthNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KafkaListenerAuthenticationScramSha512Builder builder;

            KafkaListenerAuthenticationScramSha512AuthNestedImpl(KafkaListenerAuthenticationScramSha512 item) {
                this.builder = new KafkaListenerAuthenticationScramSha512Builder(this, item);
                        
            }

            KafkaListenerAuthenticationScramSha512AuthNestedImpl() {
                this.builder = new KafkaListenerAuthenticationScramSha512Builder(this);
                        
            }

            public N and() {
                return (N) KafkaListenerExternalNodePortFluentImpl.this.withAuth(builder.build());
            }

            public N endKafkaListenerAuthenticationScramSha512Auth() {
                return and();
            }
    }


    public class OverridesNestedImpl<N> extends NodePortListenerOverrideFluentImpl<KafkaListenerExternalNodePortFluent.OverridesNested<N>> implements KafkaListenerExternalNodePortFluent.OverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NodePortListenerOverrideBuilder builder;

            OverridesNestedImpl(NodePortListenerOverride item) {
                this.builder = new NodePortListenerOverrideBuilder(this, item);
                        
            }

            OverridesNestedImpl() {
                this.builder = new NodePortListenerOverrideBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaListenerExternalNodePortFluentImpl.this.withOverrides(builder.build());
            }

            public N endOverrides() {
                return and();
            }
    }


    public class ConfigurationNestedImpl<N> extends NodePortListenerConfigurationFluentImpl<KafkaListenerExternalNodePortFluent.ConfigurationNested<N>> implements KafkaListenerExternalNodePortFluent.ConfigurationNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NodePortListenerConfigurationBuilder builder;

            ConfigurationNestedImpl(NodePortListenerConfiguration item) {
                this.builder = new NodePortListenerConfigurationBuilder(this, item);
                        
            }

            ConfigurationNestedImpl() {
                this.builder = new NodePortListenerConfigurationBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaListenerExternalNodePortFluentImpl.this.withConfiguration(builder.build());
            }

            public N endConfiguration() {
                return and();
            }
    }


}
