package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaListenerAuthenticationTlsBuilder extends KafkaListenerAuthenticationTlsFluentImpl<KafkaListenerAuthenticationTlsBuilder> implements VisitableBuilder<KafkaListenerAuthenticationTls,KafkaListenerAuthenticationTlsBuilder> {

    KafkaListenerAuthenticationTlsFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaListenerAuthenticationTlsBuilder() {
        this(true);
    }

    public KafkaListenerAuthenticationTlsBuilder(Boolean validationEnabled) {
        this(new KafkaListenerAuthenticationTls(), validationEnabled);
    }

    public KafkaListenerAuthenticationTlsBuilder(KafkaListenerAuthenticationTlsFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaListenerAuthenticationTlsBuilder(KafkaListenerAuthenticationTlsFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KafkaListenerAuthenticationTls(), validationEnabled);
    }

    public KafkaListenerAuthenticationTlsBuilder(KafkaListenerAuthenticationTlsFluent<?> fluent,KafkaListenerAuthenticationTls instance) {
        this(fluent, instance, true);
    }

    public KafkaListenerAuthenticationTlsBuilder(KafkaListenerAuthenticationTlsFluent<?> fluent,KafkaListenerAuthenticationTls instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        this.validationEnabled = validationEnabled; 
    }

    public KafkaListenerAuthenticationTlsBuilder(KafkaListenerAuthenticationTls instance) {
        this(instance,true);
    }

    public KafkaListenerAuthenticationTlsBuilder(KafkaListenerAuthenticationTls instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.validationEnabled = validationEnabled; 
    }

    public KafkaListenerAuthenticationTls build() {
        KafkaListenerAuthenticationTls buildable = new KafkaListenerAuthenticationTls();
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaListenerAuthenticationTlsBuilder that = (KafkaListenerAuthenticationTlsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
