package io.strimzi.api.kafka.model.listener;

import io.strimzi.api.kafka.model.GenericSecretSource;
import io.strimzi.api.kafka.model.GenericSecretSourceBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.strimzi.api.kafka.model.GenericSecretSourceFluent;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.StringBuffer;
import io.strimzi.api.kafka.model.CertSecretSourceBuilder;
import io.strimzi.api.kafka.model.CertSecretSourceFluent;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.CertSecretSource;

public interface KafkaListenerAuthenticationOAuthFluent<A extends KafkaListenerAuthenticationOAuthFluent<A>> extends KafkaListenerAuthenticationFluent<A> {


    public String getClientId();
    public A withClientId(String clientId);
    public Boolean hasClientId();
    public A withNewClientId(StringBuilder arg1);
    public A withNewClientId(int[] arg1,int arg2,int arg3);
    public A withNewClientId(char[] arg1);
    public A withNewClientId(StringBuffer arg1);
    public A withNewClientId(byte[] arg1,int arg2);
    public A withNewClientId(byte[] arg1);
    public A withNewClientId(char[] arg1,int arg2,int arg3);
    public A withNewClientId(byte[] arg1,int arg2,int arg3);
    public A withNewClientId(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewClientId(String arg1);
    
/**
 * This method has been deprecated, please use method buildClientSecret instead.
 * @return The buildable object.
 */
@Deprecated public GenericSecretSource getClientSecret();
    public GenericSecretSource buildClientSecret();
    public A withClientSecret(GenericSecretSource clientSecret);
    public Boolean hasClientSecret();
    public KafkaListenerAuthenticationOAuthFluent.ClientSecretNested<A> withNewClientSecret();
    public KafkaListenerAuthenticationOAuthFluent.ClientSecretNested<A> withNewClientSecretLike(GenericSecretSource item);
    public KafkaListenerAuthenticationOAuthFluent.ClientSecretNested<A> editClientSecret();
    public KafkaListenerAuthenticationOAuthFluent.ClientSecretNested<A> editOrNewClientSecret();
    public KafkaListenerAuthenticationOAuthFluent.ClientSecretNested<A> editOrNewClientSecretLike(GenericSecretSource item);
    public String getValidIssuerUri();
    public A withValidIssuerUri(String validIssuerUri);
    public Boolean hasValidIssuerUri();
    public A withNewValidIssuerUri(StringBuilder arg1);
    public A withNewValidIssuerUri(int[] arg1,int arg2,int arg3);
    public A withNewValidIssuerUri(char[] arg1);
    public A withNewValidIssuerUri(StringBuffer arg1);
    public A withNewValidIssuerUri(byte[] arg1,int arg2);
    public A withNewValidIssuerUri(byte[] arg1);
    public A withNewValidIssuerUri(char[] arg1,int arg2,int arg3);
    public A withNewValidIssuerUri(byte[] arg1,int arg2,int arg3);
    public A withNewValidIssuerUri(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewValidIssuerUri(String arg1);
    public boolean isCheckIssuer();
    public A withCheckIssuer(boolean checkIssuer);
    public Boolean hasCheckIssuer();
    public boolean isCheckAudience();
    public A withCheckAudience(boolean checkAudience);
    public Boolean hasCheckAudience();
    public String getJwksEndpointUri();
    public A withJwksEndpointUri(String jwksEndpointUri);
    public Boolean hasJwksEndpointUri();
    public A withNewJwksEndpointUri(StringBuilder arg1);
    public A withNewJwksEndpointUri(int[] arg1,int arg2,int arg3);
    public A withNewJwksEndpointUri(char[] arg1);
    public A withNewJwksEndpointUri(StringBuffer arg1);
    public A withNewJwksEndpointUri(byte[] arg1,int arg2);
    public A withNewJwksEndpointUri(byte[] arg1);
    public A withNewJwksEndpointUri(char[] arg1,int arg2,int arg3);
    public A withNewJwksEndpointUri(byte[] arg1,int arg2,int arg3);
    public A withNewJwksEndpointUri(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewJwksEndpointUri(String arg1);
    public Integer getJwksRefreshSeconds();
    public A withJwksRefreshSeconds(Integer jwksRefreshSeconds);
    public Boolean hasJwksRefreshSeconds();
    public Integer getJwksMinRefreshPauseSeconds();
    public A withJwksMinRefreshPauseSeconds(Integer jwksMinRefreshPauseSeconds);
    public Boolean hasJwksMinRefreshPauseSeconds();
    public Integer getJwksExpirySeconds();
    public A withJwksExpirySeconds(Integer jwksExpirySeconds);
    public Boolean hasJwksExpirySeconds();
    public String getIntrospectionEndpointUri();
    public A withIntrospectionEndpointUri(String introspectionEndpointUri);
    public Boolean hasIntrospectionEndpointUri();
    public A withNewIntrospectionEndpointUri(StringBuilder arg1);
    public A withNewIntrospectionEndpointUri(int[] arg1,int arg2,int arg3);
    public A withNewIntrospectionEndpointUri(char[] arg1);
    public A withNewIntrospectionEndpointUri(StringBuffer arg1);
    public A withNewIntrospectionEndpointUri(byte[] arg1,int arg2);
    public A withNewIntrospectionEndpointUri(byte[] arg1);
    public A withNewIntrospectionEndpointUri(char[] arg1,int arg2,int arg3);
    public A withNewIntrospectionEndpointUri(byte[] arg1,int arg2,int arg3);
    public A withNewIntrospectionEndpointUri(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewIntrospectionEndpointUri(String arg1);
    public String getUserNameClaim();
    public A withUserNameClaim(String userNameClaim);
    public Boolean hasUserNameClaim();
    public A withNewUserNameClaim(StringBuilder arg1);
    public A withNewUserNameClaim(int[] arg1,int arg2,int arg3);
    public A withNewUserNameClaim(char[] arg1);
    public A withNewUserNameClaim(StringBuffer arg1);
    public A withNewUserNameClaim(byte[] arg1,int arg2);
    public A withNewUserNameClaim(byte[] arg1);
    public A withNewUserNameClaim(char[] arg1,int arg2,int arg3);
    public A withNewUserNameClaim(byte[] arg1,int arg2,int arg3);
    public A withNewUserNameClaim(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewUserNameClaim(String arg1);
    public String getFallbackUserNameClaim();
    public A withFallbackUserNameClaim(String fallbackUserNameClaim);
    public Boolean hasFallbackUserNameClaim();
    public A withNewFallbackUserNameClaim(StringBuilder arg1);
    public A withNewFallbackUserNameClaim(int[] arg1,int arg2,int arg3);
    public A withNewFallbackUserNameClaim(char[] arg1);
    public A withNewFallbackUserNameClaim(StringBuffer arg1);
    public A withNewFallbackUserNameClaim(byte[] arg1,int arg2);
    public A withNewFallbackUserNameClaim(byte[] arg1);
    public A withNewFallbackUserNameClaim(char[] arg1,int arg2,int arg3);
    public A withNewFallbackUserNameClaim(byte[] arg1,int arg2,int arg3);
    public A withNewFallbackUserNameClaim(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewFallbackUserNameClaim(String arg1);
    public String getFallbackUserNamePrefix();
    public A withFallbackUserNamePrefix(String fallbackUserNamePrefix);
    public Boolean hasFallbackUserNamePrefix();
    public A withNewFallbackUserNamePrefix(StringBuilder arg1);
    public A withNewFallbackUserNamePrefix(int[] arg1,int arg2,int arg3);
    public A withNewFallbackUserNamePrefix(char[] arg1);
    public A withNewFallbackUserNamePrefix(StringBuffer arg1);
    public A withNewFallbackUserNamePrefix(byte[] arg1,int arg2);
    public A withNewFallbackUserNamePrefix(byte[] arg1);
    public A withNewFallbackUserNamePrefix(char[] arg1,int arg2,int arg3);
    public A withNewFallbackUserNamePrefix(byte[] arg1,int arg2,int arg3);
    public A withNewFallbackUserNamePrefix(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewFallbackUserNamePrefix(String arg1);
    public String getUserInfoEndpointUri();
    public A withUserInfoEndpointUri(String userInfoEndpointUri);
    public Boolean hasUserInfoEndpointUri();
    public A withNewUserInfoEndpointUri(StringBuilder arg1);
    public A withNewUserInfoEndpointUri(int[] arg1,int arg2,int arg3);
    public A withNewUserInfoEndpointUri(char[] arg1);
    public A withNewUserInfoEndpointUri(StringBuffer arg1);
    public A withNewUserInfoEndpointUri(byte[] arg1,int arg2);
    public A withNewUserInfoEndpointUri(byte[] arg1);
    public A withNewUserInfoEndpointUri(char[] arg1,int arg2,int arg3);
    public A withNewUserInfoEndpointUri(byte[] arg1,int arg2,int arg3);
    public A withNewUserInfoEndpointUri(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewUserInfoEndpointUri(String arg1);
    public boolean isCheckAccessTokenType();
    public A withCheckAccessTokenType(boolean checkAccessTokenType);
    public Boolean hasCheckAccessTokenType();
    public String getValidTokenType();
    public A withValidTokenType(String validTokenType);
    public Boolean hasValidTokenType();
    public A withNewValidTokenType(StringBuilder arg1);
    public A withNewValidTokenType(int[] arg1,int arg2,int arg3);
    public A withNewValidTokenType(char[] arg1);
    public A withNewValidTokenType(StringBuffer arg1);
    public A withNewValidTokenType(byte[] arg1,int arg2);
    public A withNewValidTokenType(byte[] arg1);
    public A withNewValidTokenType(char[] arg1,int arg2,int arg3);
    public A withNewValidTokenType(byte[] arg1,int arg2,int arg3);
    public A withNewValidTokenType(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewValidTokenType(String arg1);
    public boolean isAccessTokenIsJwt();
    public A withAccessTokenIsJwt(boolean accessTokenIsJwt);
    public Boolean hasAccessTokenIsJwt();
    public A addToTlsTrustedCertificates(int index,CertSecretSource item);
    public A setToTlsTrustedCertificates(int index,CertSecretSource item);
    public A addToTlsTrustedCertificates(CertSecretSource... items);
    public A addAllToTlsTrustedCertificates(Collection<CertSecretSource> items);
    public A removeFromTlsTrustedCertificates(CertSecretSource... items);
    public A removeAllFromTlsTrustedCertificates(Collection<CertSecretSource> items);
    public A removeMatchingFromTlsTrustedCertificates(Predicate<CertSecretSourceBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildTlsTrustedCertificates instead.
 * @return The buildable object.
 */
@Deprecated public java.util.List<CertSecretSource> getTlsTrustedCertificates();
    public java.util.List<CertSecretSource> buildTlsTrustedCertificates();
    public CertSecretSource buildTlsTrustedCertificate(int index);
    public CertSecretSource buildFirstTlsTrustedCertificate();
    public CertSecretSource buildLastTlsTrustedCertificate();
    public CertSecretSource buildMatchingTlsTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate);
    public Boolean hasMatchingTlsTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate);
    public A withTlsTrustedCertificates(java.util.List<CertSecretSource> tlsTrustedCertificates);
    public A withTlsTrustedCertificates(CertSecretSource... tlsTrustedCertificates);
    public Boolean hasTlsTrustedCertificates();
    public KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificate();
    public KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificateLike(CertSecretSource item);
    public KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> setNewTlsTrustedCertificateLike(int index,CertSecretSource item);
    public KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editTlsTrustedCertificate(int index);
    public KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editFirstTlsTrustedCertificate();
    public KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editLastTlsTrustedCertificate();
    public KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editMatchingTlsTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate);
    public boolean isDisableTlsHostnameVerification();
    public A withDisableTlsHostnameVerification(boolean disableTlsHostnameVerification);
    public Boolean hasDisableTlsHostnameVerification();
    public boolean isEnableECDSA();
    public A withEnableECDSA(boolean enableECDSA);
    public Boolean hasEnableECDSA();
    public Integer getMaxSecondsWithoutReauthentication();
    public A withMaxSecondsWithoutReauthentication(Integer maxSecondsWithoutReauthentication);
    public Boolean hasMaxSecondsWithoutReauthentication();
    public boolean isEnablePlain();
    public A withEnablePlain(boolean enablePlain);
    public Boolean hasEnablePlain();
    public String getTokenEndpointUri();
    public A withTokenEndpointUri(String tokenEndpointUri);
    public Boolean hasTokenEndpointUri();
    public A withNewTokenEndpointUri(StringBuilder arg1);
    public A withNewTokenEndpointUri(int[] arg1,int arg2,int arg3);
    public A withNewTokenEndpointUri(char[] arg1);
    public A withNewTokenEndpointUri(StringBuffer arg1);
    public A withNewTokenEndpointUri(byte[] arg1,int arg2);
    public A withNewTokenEndpointUri(byte[] arg1);
    public A withNewTokenEndpointUri(char[] arg1,int arg2,int arg3);
    public A withNewTokenEndpointUri(byte[] arg1,int arg2,int arg3);
    public A withNewTokenEndpointUri(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewTokenEndpointUri(String arg1);
    public boolean isEnableOauthBearer();
    public A withEnableOauthBearer(boolean enableOauthBearer);
    public Boolean hasEnableOauthBearer();
    public String getCustomClaimCheck();
    public A withCustomClaimCheck(String customClaimCheck);
    public Boolean hasCustomClaimCheck();
    public A withNewCustomClaimCheck(StringBuilder arg1);
    public A withNewCustomClaimCheck(int[] arg1,int arg2,int arg3);
    public A withNewCustomClaimCheck(char[] arg1);
    public A withNewCustomClaimCheck(StringBuffer arg1);
    public A withNewCustomClaimCheck(byte[] arg1,int arg2);
    public A withNewCustomClaimCheck(byte[] arg1);
    public A withNewCustomClaimCheck(char[] arg1,int arg2,int arg3);
    public A withNewCustomClaimCheck(byte[] arg1,int arg2,int arg3);
    public A withNewCustomClaimCheck(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewCustomClaimCheck(String arg1);
    public interface ClientSecretNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,GenericSecretSourceFluent<KafkaListenerAuthenticationOAuthFluent.ClientSecretNested<N>> {

            public N and();
            public N endClientSecret();    }


    public interface TlsTrustedCertificatesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CertSecretSourceFluent<KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<N>> {

            public N and();
            public N endTlsTrustedCertificate();    }


}
