package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IngressListenerBrokerConfigurationBuilder extends IngressListenerBrokerConfigurationFluentImpl<IngressListenerBrokerConfigurationBuilder> implements VisitableBuilder<IngressListenerBrokerConfiguration,IngressListenerBrokerConfigurationBuilder> {

    IngressListenerBrokerConfigurationFluent<?> fluent;
    Boolean validationEnabled;

    public IngressListenerBrokerConfigurationBuilder() {
        this(true);
    }

    public IngressListenerBrokerConfigurationBuilder(Boolean validationEnabled) {
        this(new IngressListenerBrokerConfiguration(), validationEnabled);
    }

    public IngressListenerBrokerConfigurationBuilder(IngressListenerBrokerConfigurationFluent<?> fluent) {
        this(fluent, true);
    }

    public IngressListenerBrokerConfigurationBuilder(IngressListenerBrokerConfigurationFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new IngressListenerBrokerConfiguration(), validationEnabled);
    }

    public IngressListenerBrokerConfigurationBuilder(IngressListenerBrokerConfigurationFluent<?> fluent,IngressListenerBrokerConfiguration instance) {
        this(fluent, instance, true);
    }

    public IngressListenerBrokerConfigurationBuilder(IngressListenerBrokerConfigurationFluent<?> fluent,IngressListenerBrokerConfiguration instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withHost(instance.getHost());
        
        fluent.withDnsAnnotations(instance.getDnsAnnotations());
        
        fluent.withBroker(instance.getBroker());
        
        fluent.withAdvertisedHost(instance.getAdvertisedHost());
        
        fluent.withAdvertisedPort(instance.getAdvertisedPort());
        
        this.validationEnabled = validationEnabled; 
    }

    public IngressListenerBrokerConfigurationBuilder(IngressListenerBrokerConfiguration instance) {
        this(instance,true);
    }

    public IngressListenerBrokerConfigurationBuilder(IngressListenerBrokerConfiguration instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withHost(instance.getHost());
        
        this.withDnsAnnotations(instance.getDnsAnnotations());
        
        this.withBroker(instance.getBroker());
        
        this.withAdvertisedHost(instance.getAdvertisedHost());
        
        this.withAdvertisedPort(instance.getAdvertisedPort());
        
        this.validationEnabled = validationEnabled; 
    }

    public IngressListenerBrokerConfiguration build() {
        IngressListenerBrokerConfiguration buildable = new IngressListenerBrokerConfiguration();
        buildable.setBroker(fluent.getBroker());
        buildable.setAdvertisedHost(fluent.getAdvertisedHost());
        buildable.setAdvertisedPort(fluent.getAdvertisedPort());
        buildable.setHost(fluent.getHost());
        buildable.setDnsAnnotations(fluent.getDnsAnnotations());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IngressListenerBrokerConfigurationBuilder that = (IngressListenerBrokerConfigurationBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
