package io.strimzi.api.kafka.model.listener;

import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class ExternalListenerBrokerOverrideFluentImpl<A extends ExternalListenerBrokerOverrideFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ExternalListenerBrokerOverrideFluent<A> {

    private Integer broker;
    private String advertisedHost;
    private Integer advertisedPort;

    public ExternalListenerBrokerOverrideFluentImpl() {
    }

    public ExternalListenerBrokerOverrideFluentImpl(ExternalListenerBrokerOverride instance) {
        this.withBroker(instance.getBroker());
        
        this.withAdvertisedHost(instance.getAdvertisedHost());
        
        this.withAdvertisedPort(instance.getAdvertisedPort());
    }

    public Integer getBroker() {
        return this.broker;
    }

    public A withBroker(Integer broker) {
        this.broker=broker; return (A) this;
    }

    public Boolean hasBroker() {
        return this.broker != null;
    }

    public String getAdvertisedHost() {
        return this.advertisedHost;
    }

    public A withAdvertisedHost(String advertisedHost) {
        this.advertisedHost=advertisedHost; return (A) this;
    }

    public Boolean hasAdvertisedHost() {
        return this.advertisedHost != null;
    }

    public A withNewAdvertisedHost(StringBuilder arg1) {
        return (A)withAdvertisedHost(new String(arg1));
    }

    public A withNewAdvertisedHost(int[] arg1,int arg2,int arg3) {
        return (A)withAdvertisedHost(new String(arg1, arg2, arg3));
    }

    public A withNewAdvertisedHost(char[] arg1) {
        return (A)withAdvertisedHost(new String(arg1));
    }

    public A withNewAdvertisedHost(StringBuffer arg1) {
        return (A)withAdvertisedHost(new String(arg1));
    }

    public A withNewAdvertisedHost(byte[] arg1,int arg2) {
        return (A)withAdvertisedHost(new String(arg1, arg2));
    }

    public A withNewAdvertisedHost(byte[] arg1) {
        return (A)withAdvertisedHost(new String(arg1));
    }

    public A withNewAdvertisedHost(char[] arg1,int arg2,int arg3) {
        return (A)withAdvertisedHost(new String(arg1, arg2, arg3));
    }

    public A withNewAdvertisedHost(byte[] arg1,int arg2,int arg3) {
        return (A)withAdvertisedHost(new String(arg1, arg2, arg3));
    }

    public A withNewAdvertisedHost(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withAdvertisedHost(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewAdvertisedHost(String arg1) {
        return (A)withAdvertisedHost(new String(arg1));
    }

    public Integer getAdvertisedPort() {
        return this.advertisedPort;
    }

    public A withAdvertisedPort(Integer advertisedPort) {
        this.advertisedPort=advertisedPort; return (A) this;
    }

    public Boolean hasAdvertisedPort() {
        return this.advertisedPort != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ExternalListenerBrokerOverrideFluentImpl that = (ExternalListenerBrokerOverrideFluentImpl) o;
        if (broker != null ? !broker.equals(that.broker) :that.broker != null) return false;
        if (advertisedHost != null ? !advertisedHost.equals(that.advertisedHost) :that.advertisedHost != null) return false;
        if (advertisedPort != null ? !advertisedPort.equals(that.advertisedPort) :that.advertisedPort != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(broker,  advertisedHost,  advertisedPort,  super.hashCode());
    }

}
