package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ZipArtifactBuilder extends ZipArtifactFluentImpl<ZipArtifactBuilder> implements VisitableBuilder<ZipArtifact,ZipArtifactBuilder> {

    ZipArtifactFluent<?> fluent;
    Boolean validationEnabled;

    public ZipArtifactBuilder() {
        this(true);
    }

    public ZipArtifactBuilder(Boolean validationEnabled) {
        this(new ZipArtifact(), validationEnabled);
    }

    public ZipArtifactBuilder(ZipArtifactFluent<?> fluent) {
        this(fluent, true);
    }

    public ZipArtifactBuilder(ZipArtifactFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ZipArtifact(), validationEnabled);
    }

    public ZipArtifactBuilder(ZipArtifactFluent<?> fluent,ZipArtifact instance) {
        this(fluent, instance, true);
    }

    public ZipArtifactBuilder(ZipArtifactFluent<?> fluent,ZipArtifact instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withUrl(instance.getUrl());
        
        fluent.withSha512sum(instance.getSha512sum());
        
        this.validationEnabled = validationEnabled; 
    }

    public ZipArtifactBuilder(ZipArtifact instance) {
        this(instance,true);
    }

    public ZipArtifactBuilder(ZipArtifact instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withUrl(instance.getUrl());
        
        this.withSha512sum(instance.getSha512sum());
        
        this.validationEnabled = validationEnabled; 
    }

    public ZipArtifact build() {
        ZipArtifact buildable = new ZipArtifact();
        buildable.setUrl(fluent.getUrl());
        buildable.setSha512sum(fluent.getSha512sum());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ZipArtifactBuilder that = (ZipArtifactBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
