package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

public class BuildFluentImpl<A extends BuildFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements BuildFluent<A> {

    private VisitableBuilder<? extends Output,?> output;
    private java.util.List<PluginBuilder> plugins;
    private ResourceRequirements resources;

    public BuildFluentImpl() {
    }

    public BuildFluentImpl(Build instance) {
        this.withOutput(instance.getOutput());
        
        this.withPlugins(instance.getPlugins());
        
        this.withResources(instance.getResources());
    }

    
/**
 * This method has been deprecated, please use method buildOutput instead.
 * @return The buildable object.
 */
@Deprecated public Output getOutput() {
        return this.output!=null?this.output.build():null;
    }

    public Output buildOutput() {
        return this.output!=null?this.output.build():null;
    }

    public A withOutput(Output output) {
        if (output instanceof ImageStreamOutput){ this.output= new ImageStreamOutputBuilder((ImageStreamOutput)output); _visitables.get("output").add(this.output);}
        if (output instanceof DockerOutput){ this.output= new DockerOutputBuilder((DockerOutput)output); _visitables.get("output").add(this.output);}
        return (A) this;
    }

    public Boolean hasOutput() {
        return this.output != null;
    }

    public A withImageStreamOutput(ImageStreamOutput imageStreamOutput) {
        _visitables.get("output").remove(this.output);
        if (imageStreamOutput!=null){ this.output= new ImageStreamOutputBuilder(imageStreamOutput); _visitables.get("output").add(this.output);} return (A) this;
    }

    public BuildFluent.ImageStreamOutputNested<A> withNewImageStreamOutput() {
        return new ImageStreamOutputNestedImpl();
    }

    public BuildFluent.ImageStreamOutputNested<A> withNewImageStreamOutputLike(ImageStreamOutput item) {
        return new ImageStreamOutputNestedImpl(item);
    }

    public A withDockerOutput(DockerOutput dockerOutput) {
        _visitables.get("output").remove(this.output);
        if (dockerOutput!=null){ this.output= new DockerOutputBuilder(dockerOutput); _visitables.get("output").add(this.output);} return (A) this;
    }

    public BuildFluent.DockerOutputNested<A> withNewDockerOutput() {
        return new DockerOutputNestedImpl();
    }

    public BuildFluent.DockerOutputNested<A> withNewDockerOutputLike(DockerOutput item) {
        return new DockerOutputNestedImpl(item);
    }

    public A addToPlugins(int index,Plugin item) {
        if (this.plugins == null) {this.plugins = new ArrayList<PluginBuilder>();}
        PluginBuilder builder = new PluginBuilder(item);_visitables.get("plugins").add(index >= 0 ? index : _visitables.get("plugins").size(), builder);this.plugins.add(index >= 0 ? index : plugins.size(), builder); return (A)this;
    }

    public A setToPlugins(int index,Plugin item) {
        if (this.plugins == null) {this.plugins = new ArrayList<PluginBuilder>();}
        PluginBuilder builder = new PluginBuilder(item);
        if (index < 0 || index >= _visitables.get("plugins").size()) { _visitables.get("plugins").add(builder); } else { _visitables.get("plugins").set(index, builder);}
        if (index < 0 || index >= plugins.size()) { plugins.add(builder); } else { plugins.set(index, builder);}
         return (A)this;
    }

    public A addToPlugins(Plugin... items) {
        if (this.plugins == null) {this.plugins = new ArrayList<PluginBuilder>();}
        for (Plugin item : items) {PluginBuilder builder = new PluginBuilder(item);_visitables.get("plugins").add(builder);this.plugins.add(builder);} return (A)this;
    }

    public A addAllToPlugins(Collection<Plugin> items) {
        if (this.plugins == null) {this.plugins = new ArrayList<PluginBuilder>();}
        for (Plugin item : items) {PluginBuilder builder = new PluginBuilder(item);_visitables.get("plugins").add(builder);this.plugins.add(builder);} return (A)this;
    }

    public A removeFromPlugins(Plugin... items) {
        for (Plugin item : items) {PluginBuilder builder = new PluginBuilder(item);_visitables.get("plugins").remove(builder);if (this.plugins != null) {this.plugins.remove(builder);}} return (A)this;
    }

    public A removeAllFromPlugins(Collection<Plugin> items) {
        for (Plugin item : items) {PluginBuilder builder = new PluginBuilder(item);_visitables.get("plugins").remove(builder);if (this.plugins != null) {this.plugins.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromPlugins(Predicate<PluginBuilder> predicate) {
        if (plugins == null) return (A) this;
        final Iterator<PluginBuilder> each = plugins.iterator();
        final List visitables = _visitables.get("plugins");
        while (each.hasNext()) {
          PluginBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildPlugins instead.
 * @return The buildable object.
 */
@Deprecated public java.util.List<Plugin> getPlugins() {
        return build(plugins);
    }

    public java.util.List<Plugin> buildPlugins() {
        return build(plugins);
    }

    public Plugin buildPlugin(int index) {
        return this.plugins.get(index).build();
    }

    public Plugin buildFirstPlugin() {
        return this.plugins.get(0).build();
    }

    public Plugin buildLastPlugin() {
        return this.plugins.get(plugins.size() - 1).build();
    }

    public Plugin buildMatchingPlugin(Predicate<PluginBuilder> predicate) {
        for (PluginBuilder item: plugins) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingPlugin(Predicate<PluginBuilder> predicate) {
        for (PluginBuilder item: plugins) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withPlugins(java.util.List<Plugin> plugins) {
        if (this.plugins != null) { _visitables.get("plugins").removeAll(this.plugins);}
        if (plugins != null) {this.plugins = new ArrayList<PluginBuilder>(); for (Plugin item : plugins){this.addToPlugins(item);}} else { this.plugins = null;} return (A) this;
    }

    public A withPlugins(Plugin... plugins) {
        if (this.plugins != null) {this.plugins.clear();}
        if (plugins != null) {for (Plugin item :plugins){ this.addToPlugins(item);}} return (A) this;
    }

    public Boolean hasPlugins() {
        return plugins != null && !plugins.isEmpty();
    }

    public BuildFluent.PluginsNested<A> addNewPlugin() {
        return new PluginsNestedImpl();
    }

    public BuildFluent.PluginsNested<A> addNewPluginLike(Plugin item) {
        return new PluginsNestedImpl(-1, item);
    }

    public BuildFluent.PluginsNested<A> setNewPluginLike(int index,Plugin item) {
        return new PluginsNestedImpl(index, item);
    }

    public BuildFluent.PluginsNested<A> editPlugin(int index) {
        if (plugins.size() <= index) throw new RuntimeException("Can't edit plugins. Index exceeds size.");
        return setNewPluginLike(index, buildPlugin(index));
    }

    public BuildFluent.PluginsNested<A> editFirstPlugin() {
        if (plugins.size() == 0) throw new RuntimeException("Can't edit first plugins. The list is empty.");
        return setNewPluginLike(0, buildPlugin(0));
    }

    public BuildFluent.PluginsNested<A> editLastPlugin() {
        int index = plugins.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last plugins. The list is empty.");
        return setNewPluginLike(index, buildPlugin(index));
    }

    public BuildFluent.PluginsNested<A> editMatchingPlugin(Predicate<PluginBuilder> predicate) {
        int index = -1;
        for (int i=0;i<plugins.size();i++) { 
        if (predicate.test(plugins.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching plugins. No match found.");
        return setNewPluginLike(index, buildPlugin(index));
    }

    public ResourceRequirements getResources() {
        return this.resources;
    }

    public A withResources(ResourceRequirements resources) {
        this.resources=resources; return (A) this;
    }

    public Boolean hasResources() {
        return this.resources != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        BuildFluentImpl that = (BuildFluentImpl) o;
        if (output != null ? !output.equals(that.output) :that.output != null) return false;
        if (plugins != null ? !plugins.equals(that.plugins) :that.plugins != null) return false;
        if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(output,  plugins,  resources,  super.hashCode());
    }

    public class ImageStreamOutputNestedImpl<N> extends ImageStreamOutputFluentImpl<BuildFluent.ImageStreamOutputNested<N>> implements BuildFluent.ImageStreamOutputNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ImageStreamOutputBuilder builder;

            ImageStreamOutputNestedImpl(ImageStreamOutput item) {
                this.builder = new ImageStreamOutputBuilder(this, item);
                        
            }

            ImageStreamOutputNestedImpl() {
                this.builder = new ImageStreamOutputBuilder(this);
                        
            }

            public N and() {
                return (N) BuildFluentImpl.this.withOutput(builder.build());
            }

            public N endImageStreamOutput() {
                return and();
            }
    }


    public class DockerOutputNestedImpl<N> extends DockerOutputFluentImpl<BuildFluent.DockerOutputNested<N>> implements BuildFluent.DockerOutputNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DockerOutputBuilder builder;

            DockerOutputNestedImpl(DockerOutput item) {
                this.builder = new DockerOutputBuilder(this, item);
                        
            }

            DockerOutputNestedImpl() {
                this.builder = new DockerOutputBuilder(this);
                        
            }

            public N and() {
                return (N) BuildFluentImpl.this.withOutput(builder.build());
            }

            public N endDockerOutput() {
                return and();
            }
    }


    public class PluginsNestedImpl<N> extends PluginFluentImpl<BuildFluent.PluginsNested<N>> implements BuildFluent.PluginsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PluginBuilder builder;
        private final int index;

            PluginsNestedImpl(int index,Plugin item) {
                this.index = index;
                this.builder = new PluginBuilder(this, item);
                        
            }

            PluginsNestedImpl() {
                this.index = -1;
                this.builder = new PluginBuilder(this);
                        
            }

            public N and() {
                return (N) BuildFluentImpl.this.setToPlugins(index,builder.build());
            }

            public N endPlugin() {
                return and();
            }
    }


}
