package io.strimzi.api.kafka.model.connect;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ExternalConfigurationEnvBuilder extends ExternalConfigurationEnvFluentImpl<ExternalConfigurationEnvBuilder> implements VisitableBuilder<ExternalConfigurationEnv,ExternalConfigurationEnvBuilder> {

    ExternalConfigurationEnvFluent<?> fluent;
    Boolean validationEnabled;

    public ExternalConfigurationEnvBuilder() {
        this(true);
    }

    public ExternalConfigurationEnvBuilder(Boolean validationEnabled) {
        this(new ExternalConfigurationEnv(), validationEnabled);
    }

    public ExternalConfigurationEnvBuilder(ExternalConfigurationEnvFluent<?> fluent) {
        this(fluent, true);
    }

    public ExternalConfigurationEnvBuilder(ExternalConfigurationEnvFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ExternalConfigurationEnv(), validationEnabled);
    }

    public ExternalConfigurationEnvBuilder(ExternalConfigurationEnvFluent<?> fluent,ExternalConfigurationEnv instance) {
        this(fluent, instance, true);
    }

    public ExternalConfigurationEnvBuilder(ExternalConfigurationEnvFluent<?> fluent,ExternalConfigurationEnv instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withName(instance.getName());
        
        fluent.withValueFrom(instance.getValueFrom());
        
        this.validationEnabled = validationEnabled; 
    }

    public ExternalConfigurationEnvBuilder(ExternalConfigurationEnv instance) {
        this(instance,true);
    }

    public ExternalConfigurationEnvBuilder(ExternalConfigurationEnv instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withName(instance.getName());
        
        this.withValueFrom(instance.getValueFrom());
        
        this.validationEnabled = validationEnabled; 
    }

    public ExternalConfigurationEnv build() {
        ExternalConfigurationEnv buildable = new ExternalConfigurationEnv();
        buildable.setName(fluent.getName());
        buildable.setValueFrom(fluent.getValueFrom());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ExternalConfigurationEnvBuilder that = (ExternalConfigurationEnvBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
