package io.strimzi.api.kafka.model.authentication;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaClientAuthenticationOAuthBuilder extends KafkaClientAuthenticationOAuthFluentImpl<KafkaClientAuthenticationOAuthBuilder> implements VisitableBuilder<KafkaClientAuthenticationOAuth,KafkaClientAuthenticationOAuthBuilder> {

    KafkaClientAuthenticationOAuthFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaClientAuthenticationOAuthBuilder() {
        this(true);
    }

    public KafkaClientAuthenticationOAuthBuilder(Boolean validationEnabled) {
        this(new KafkaClientAuthenticationOAuth(), validationEnabled);
    }

    public KafkaClientAuthenticationOAuthBuilder(KafkaClientAuthenticationOAuthFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaClientAuthenticationOAuthBuilder(KafkaClientAuthenticationOAuthFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KafkaClientAuthenticationOAuth(), validationEnabled);
    }

    public KafkaClientAuthenticationOAuthBuilder(KafkaClientAuthenticationOAuthFluent<?> fluent,KafkaClientAuthenticationOAuth instance) {
        this(fluent, instance, true);
    }

    public KafkaClientAuthenticationOAuthBuilder(KafkaClientAuthenticationOAuthFluent<?> fluent,KafkaClientAuthenticationOAuth instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withClientId(instance.getClientId());
        
        fluent.withScope(instance.getScope());
        
        fluent.withTokenEndpointUri(instance.getTokenEndpointUri());
        
        fluent.withClientSecret(instance.getClientSecret());
        
        fluent.withAccessToken(instance.getAccessToken());
        
        fluent.withRefreshToken(instance.getRefreshToken());
        
        fluent.withTlsTrustedCertificates(instance.getTlsTrustedCertificates());
        
        fluent.withDisableTlsHostnameVerification(instance.isDisableTlsHostnameVerification());
        
        fluent.withMaxTokenExpirySeconds(instance.getMaxTokenExpirySeconds());
        
        fluent.withAccessTokenIsJwt(instance.isAccessTokenIsJwt());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaClientAuthenticationOAuthBuilder(KafkaClientAuthenticationOAuth instance) {
        this(instance,true);
    }

    public KafkaClientAuthenticationOAuthBuilder(KafkaClientAuthenticationOAuth instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withClientId(instance.getClientId());
        
        this.withScope(instance.getScope());
        
        this.withTokenEndpointUri(instance.getTokenEndpointUri());
        
        this.withClientSecret(instance.getClientSecret());
        
        this.withAccessToken(instance.getAccessToken());
        
        this.withRefreshToken(instance.getRefreshToken());
        
        this.withTlsTrustedCertificates(instance.getTlsTrustedCertificates());
        
        this.withDisableTlsHostnameVerification(instance.isDisableTlsHostnameVerification());
        
        this.withMaxTokenExpirySeconds(instance.getMaxTokenExpirySeconds());
        
        this.withAccessTokenIsJwt(instance.isAccessTokenIsJwt());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaClientAuthenticationOAuth build() {
        KafkaClientAuthenticationOAuth buildable = new KafkaClientAuthenticationOAuth();
        buildable.setClientId(fluent.getClientId());
        buildable.setScope(fluent.getScope());
        buildable.setTokenEndpointUri(fluent.getTokenEndpointUri());
        buildable.setClientSecret(fluent.getClientSecret());
        buildable.setAccessToken(fluent.getAccessToken());
        buildable.setRefreshToken(fluent.getRefreshToken());
        buildable.setTlsTrustedCertificates(fluent.getTlsTrustedCertificates());
        buildable.setDisableTlsHostnameVerification(fluent.isDisableTlsHostnameVerification());
        buildable.setMaxTokenExpirySeconds(fluent.getMaxTokenExpirySeconds());
        buildable.setAccessTokenIsJwt(fluent.isAccessTokenIsJwt());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaClientAuthenticationOAuthBuilder that = (KafkaClientAuthenticationOAuthBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
