package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import io.strimzi.api.kafka.model.storage.EphemeralStorageFluentImpl;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorage;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.storage.SingleVolumeStorage;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.Affinity;
import java.util.Collection;
import io.strimzi.api.kafka.model.storage.EphemeralStorageBuilder;
import java.lang.Object;
import io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateBuilder;
import io.strimzi.api.kafka.model.storage.EphemeralStorage;
import java.util.Map;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorageBuilder;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluentImpl;
import java.lang.Deprecated;
import io.strimzi.api.kafka.model.template.ZookeeperClusterTemplate;
import io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluentImpl;
import java.lang.StringBuffer;

public class ZookeeperClusterSpecFluentImpl<A extends ZookeeperClusterSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ZookeeperClusterSpecFluent<A> {

    private VisitableBuilder<? extends SingleVolumeStorage,?> storage;
    private Map<String,Object> config;
    private VisitableBuilder<? extends Logging,?> logging;
    private TlsSidecarBuilder tlsSidecar;
    private int replicas;
    private String image;
    private ResourceRequirements resources;
    private ProbeBuilder livenessProbe;
    private ProbeBuilder readinessProbe;
    private JvmOptionsBuilder jvmOptions;
    private VisitableBuilder<? extends MetricsConfig,?> metricsConfig;
    private Map<String,Object> metrics;
    private Affinity affinity;
    private java.util.List<Toleration> tolerations;
    private ZookeeperClusterTemplateBuilder template;

    public ZookeeperClusterSpecFluentImpl() {
    }

    public ZookeeperClusterSpecFluentImpl(ZookeeperClusterSpec instance) {
        this.withStorage(instance.getStorage());
        
        this.withConfig(instance.getConfig());
        
        this.withLogging(instance.getLogging());
        
        this.withTlsSidecar(instance.getTlsSidecar());
        
        this.withReplicas(instance.getReplicas());
        
        this.withImage(instance.getImage());
        
        this.withResources(instance.getResources());
        
        this.withLivenessProbe(instance.getLivenessProbe());
        
        this.withReadinessProbe(instance.getReadinessProbe());
        
        this.withJvmOptions(instance.getJvmOptions());
        
        this.withMetricsConfig(instance.getMetricsConfig());
        
        this.withMetrics(instance.getMetrics());
        
        this.withAffinity(instance.getAffinity());
        
        this.withTolerations(instance.getTolerations());
        
        this.withTemplate(instance.getTemplate());
    }

    
/**
 * This method has been deprecated, please use method buildStorage instead.
 * @return The buildable object.
 */
@Deprecated public SingleVolumeStorage getStorage() {
        return this.storage!=null?this.storage.build():null;
    }

    public SingleVolumeStorage buildStorage() {
        return this.storage!=null?this.storage.build():null;
    }

    public A withStorage(SingleVolumeStorage storage) {
        if (storage instanceof PersistentClaimStorage){ this.storage= new PersistentClaimStorageBuilder((PersistentClaimStorage)storage); _visitables.get("storage").add(this.storage);}
        if (storage instanceof EphemeralStorage){ this.storage= new EphemeralStorageBuilder((EphemeralStorage)storage); _visitables.get("storage").add(this.storage);}
        return (A) this;
    }

    public Boolean hasStorage() {
        return this.storage != null;
    }

    public A withPersistentClaimStorage(PersistentClaimStorage persistentClaimStorage) {
        _visitables.get("storage").remove(this.storage);
        if (persistentClaimStorage!=null){ this.storage= new PersistentClaimStorageBuilder(persistentClaimStorage); _visitables.get("storage").add(this.storage);} return (A) this;
    }

    public ZookeeperClusterSpecFluent.PersistentClaimStorageNested<A> withNewPersistentClaimStorage() {
        return new PersistentClaimStorageNestedImpl();
    }

    public ZookeeperClusterSpecFluent.PersistentClaimStorageNested<A> withNewPersistentClaimStorageLike(PersistentClaimStorage item) {
        return new PersistentClaimStorageNestedImpl(item);
    }

    public A withEphemeralStorage(EphemeralStorage ephemeralStorage) {
        _visitables.get("storage").remove(this.storage);
        if (ephemeralStorage!=null){ this.storage= new EphemeralStorageBuilder(ephemeralStorage); _visitables.get("storage").add(this.storage);} return (A) this;
    }

    public ZookeeperClusterSpecFluent.EphemeralStorageNested<A> withNewEphemeralStorage() {
        return new EphemeralStorageNestedImpl();
    }

    public ZookeeperClusterSpecFluent.EphemeralStorageNested<A> withNewEphemeralStorageLike(EphemeralStorage item) {
        return new EphemeralStorageNestedImpl(item);
    }

    public A addToConfig(String key,Object value) {
        if(this.config == null && key != null && value != null) { this.config = new LinkedHashMap<String,Object>(); }
        if(key != null && value != null) {this.config.put(key, value);} return (A)this;
    }

    public A addToConfig(Map<String,Object> map) {
        if(this.config == null && map != null) { this.config = new LinkedHashMap<String,Object>(); }
        if(map != null) { this.config.putAll(map);} return (A)this;
    }

    public A removeFromConfig(String key) {
        if(this.config == null) { return (A) this; }
        if(key != null && this.config != null) {this.config.remove(key);} return (A)this;
    }

    public A removeFromConfig(Map<String,Object> map) {
        if(this.config == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.config != null){this.config.remove(key);}}} return (A)this;
    }

    public Map<String,Object> getConfig() {
        return this.config;
    }

    public <K extends Object,V extends Object>A withConfig(Map<String,Object> config) {
        if (config == null) { this.config =  null;} else {this.config = new LinkedHashMap<String,Object>(config);} return (A) this;
    }

    public Boolean hasConfig() {
        return this.config != null;
    }

    
/**
 * This method has been deprecated, please use method buildLogging instead.
 * @return The buildable object.
 */
@Deprecated public Logging getLogging() {
        return this.logging!=null?this.logging.build():null;
    }

    public Logging buildLogging() {
        return this.logging!=null?this.logging.build():null;
    }

    public A withLogging(Logging logging) {
        if (logging instanceof ExternalLogging){ this.logging= new ExternalLoggingBuilder((ExternalLogging)logging); _visitables.get("logging").add(this.logging);}
        if (logging instanceof InlineLogging){ this.logging= new InlineLoggingBuilder((InlineLogging)logging); _visitables.get("logging").add(this.logging);}
        return (A) this;
    }

    public Boolean hasLogging() {
        return this.logging != null;
    }

    public A withExternalLogging(ExternalLogging externalLogging) {
        _visitables.get("logging").remove(this.logging);
        if (externalLogging!=null){ this.logging= new ExternalLoggingBuilder(externalLogging); _visitables.get("logging").add(this.logging);} return (A) this;
    }

    public ZookeeperClusterSpecFluent.ExternalLoggingNested<A> withNewExternalLogging() {
        return new ExternalLoggingNestedImpl();
    }

    public ZookeeperClusterSpecFluent.ExternalLoggingNested<A> withNewExternalLoggingLike(ExternalLogging item) {
        return new ExternalLoggingNestedImpl(item);
    }

    public A withInlineLogging(InlineLogging inlineLogging) {
        _visitables.get("logging").remove(this.logging);
        if (inlineLogging!=null){ this.logging= new InlineLoggingBuilder(inlineLogging); _visitables.get("logging").add(this.logging);} return (A) this;
    }

    public ZookeeperClusterSpecFluent.InlineLoggingNested<A> withNewInlineLogging() {
        return new InlineLoggingNestedImpl();
    }

    public ZookeeperClusterSpecFluent.InlineLoggingNested<A> withNewInlineLoggingLike(InlineLogging item) {
        return new InlineLoggingNestedImpl(item);
    }

    
/**
 * This method has been deprecated, please use method buildTlsSidecar instead.
 * @return The buildable object.
 */
@Deprecated public TlsSidecar getTlsSidecar() {
        return this.tlsSidecar!=null?this.tlsSidecar.build():null;
    }

    public TlsSidecar buildTlsSidecar() {
        return this.tlsSidecar!=null?this.tlsSidecar.build():null;
    }

    public A withTlsSidecar(TlsSidecar tlsSidecar) {
        _visitables.get("tlsSidecar").remove(this.tlsSidecar);
        if (tlsSidecar!=null){ this.tlsSidecar= new TlsSidecarBuilder(tlsSidecar); _visitables.get("tlsSidecar").add(this.tlsSidecar);} return (A) this;
    }

    public Boolean hasTlsSidecar() {
        return this.tlsSidecar != null;
    }

    public ZookeeperClusterSpecFluent.TlsSidecarNested<A> withNewTlsSidecar() {
        return new TlsSidecarNestedImpl();
    }

    public ZookeeperClusterSpecFluent.TlsSidecarNested<A> withNewTlsSidecarLike(TlsSidecar item) {
        return new TlsSidecarNestedImpl(item);
    }

    public ZookeeperClusterSpecFluent.TlsSidecarNested<A> editTlsSidecar() {
        return withNewTlsSidecarLike(getTlsSidecar());
    }

    public ZookeeperClusterSpecFluent.TlsSidecarNested<A> editOrNewTlsSidecar() {
        return withNewTlsSidecarLike(getTlsSidecar() != null ? getTlsSidecar(): new TlsSidecarBuilder().build());
    }

    public ZookeeperClusterSpecFluent.TlsSidecarNested<A> editOrNewTlsSidecarLike(TlsSidecar item) {
        return withNewTlsSidecarLike(getTlsSidecar() != null ? getTlsSidecar(): item);
    }

    public int getReplicas() {
        return this.replicas;
    }

    public A withReplicas(int replicas) {
        this.replicas=replicas; return (A) this;
    }

    public Boolean hasReplicas() {
        return true;
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image=image; return (A) this;
    }

    public Boolean hasImage() {
        return this.image != null;
    }

    public A withNewImage(StringBuilder arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(int[] arg1,int arg2,int arg3) {
        return (A)withImage(new String(arg1, arg2, arg3));
    }

    public A withNewImage(char[] arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuffer arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(byte[] arg1,int arg2) {
        return (A)withImage(new String(arg1, arg2));
    }

    public A withNewImage(byte[] arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(char[] arg1,int arg2,int arg3) {
        return (A)withImage(new String(arg1, arg2, arg3));
    }

    public A withNewImage(byte[] arg1,int arg2,int arg3) {
        return (A)withImage(new String(arg1, arg2, arg3));
    }

    public A withNewImage(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withImage(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewImage(String arg1) {
        return (A)withImage(new String(arg1));
    }

    public ResourceRequirements getResources() {
        return this.resources;
    }

    public A withResources(ResourceRequirements resources) {
        this.resources=resources; return (A) this;
    }

    public Boolean hasResources() {
        return this.resources != null;
    }

    
/**
 * This method has been deprecated, please use method buildLivenessProbe instead.
 * @return The buildable object.
 */
@Deprecated public Probe getLivenessProbe() {
        return this.livenessProbe!=null?this.livenessProbe.build():null;
    }

    public Probe buildLivenessProbe() {
        return this.livenessProbe!=null?this.livenessProbe.build():null;
    }

    public A withLivenessProbe(Probe livenessProbe) {
        _visitables.get("livenessProbe").remove(this.livenessProbe);
        if (livenessProbe!=null){ this.livenessProbe= new ProbeBuilder(livenessProbe); _visitables.get("livenessProbe").add(this.livenessProbe);} return (A) this;
    }

    public Boolean hasLivenessProbe() {
        return this.livenessProbe != null;
    }

    public A withNewLivenessProbe(int initialDelaySeconds,int timeoutSeconds) {
        return (A)withLivenessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public ZookeeperClusterSpecFluent.LivenessProbeNested<A> withNewLivenessProbe() {
        return new LivenessProbeNestedImpl();
    }

    public ZookeeperClusterSpecFluent.LivenessProbeNested<A> withNewLivenessProbeLike(Probe item) {
        return new LivenessProbeNestedImpl(item);
    }

    public ZookeeperClusterSpecFluent.LivenessProbeNested<A> editLivenessProbe() {
        return withNewLivenessProbeLike(getLivenessProbe());
    }

    public ZookeeperClusterSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbe() {
        return withNewLivenessProbeLike(getLivenessProbe() != null ? getLivenessProbe(): new ProbeBuilder().build());
    }

    public ZookeeperClusterSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item) {
        return withNewLivenessProbeLike(getLivenessProbe() != null ? getLivenessProbe(): item);
    }

    
/**
 * This method has been deprecated, please use method buildReadinessProbe instead.
 * @return The buildable object.
 */
@Deprecated public Probe getReadinessProbe() {
        return this.readinessProbe!=null?this.readinessProbe.build():null;
    }

    public Probe buildReadinessProbe() {
        return this.readinessProbe!=null?this.readinessProbe.build():null;
    }

    public A withReadinessProbe(Probe readinessProbe) {
        _visitables.get("readinessProbe").remove(this.readinessProbe);
        if (readinessProbe!=null){ this.readinessProbe= new ProbeBuilder(readinessProbe); _visitables.get("readinessProbe").add(this.readinessProbe);} return (A) this;
    }

    public Boolean hasReadinessProbe() {
        return this.readinessProbe != null;
    }

    public A withNewReadinessProbe(int initialDelaySeconds,int timeoutSeconds) {
        return (A)withReadinessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public ZookeeperClusterSpecFluent.ReadinessProbeNested<A> withNewReadinessProbe() {
        return new ReadinessProbeNestedImpl();
    }

    public ZookeeperClusterSpecFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item) {
        return new ReadinessProbeNestedImpl(item);
    }

    public ZookeeperClusterSpecFluent.ReadinessProbeNested<A> editReadinessProbe() {
        return withNewReadinessProbeLike(getReadinessProbe());
    }

    public ZookeeperClusterSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbe() {
        return withNewReadinessProbeLike(getReadinessProbe() != null ? getReadinessProbe(): new ProbeBuilder().build());
    }

    public ZookeeperClusterSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item) {
        return withNewReadinessProbeLike(getReadinessProbe() != null ? getReadinessProbe(): item);
    }

    
/**
 * This method has been deprecated, please use method buildJvmOptions instead.
 * @return The buildable object.
 */
@Deprecated public JvmOptions getJvmOptions() {
        return this.jvmOptions!=null?this.jvmOptions.build():null;
    }

    public JvmOptions buildJvmOptions() {
        return this.jvmOptions!=null?this.jvmOptions.build():null;
    }

    public A withJvmOptions(JvmOptions jvmOptions) {
        _visitables.get("jvmOptions").remove(this.jvmOptions);
        if (jvmOptions!=null){ this.jvmOptions= new JvmOptionsBuilder(jvmOptions); _visitables.get("jvmOptions").add(this.jvmOptions);} return (A) this;
    }

    public Boolean hasJvmOptions() {
        return this.jvmOptions != null;
    }

    public ZookeeperClusterSpecFluent.JvmOptionsNested<A> withNewJvmOptions() {
        return new JvmOptionsNestedImpl();
    }

    public ZookeeperClusterSpecFluent.JvmOptionsNested<A> withNewJvmOptionsLike(JvmOptions item) {
        return new JvmOptionsNestedImpl(item);
    }

    public ZookeeperClusterSpecFluent.JvmOptionsNested<A> editJvmOptions() {
        return withNewJvmOptionsLike(getJvmOptions());
    }

    public ZookeeperClusterSpecFluent.JvmOptionsNested<A> editOrNewJvmOptions() {
        return withNewJvmOptionsLike(getJvmOptions() != null ? getJvmOptions(): new JvmOptionsBuilder().build());
    }

    public ZookeeperClusterSpecFluent.JvmOptionsNested<A> editOrNewJvmOptionsLike(JvmOptions item) {
        return withNewJvmOptionsLike(getJvmOptions() != null ? getJvmOptions(): item);
    }

    
/**
 * This method has been deprecated, please use method buildMetricsConfig instead.
 * @return The buildable object.
 */
@Deprecated public MetricsConfig getMetricsConfig() {
        return this.metricsConfig!=null?this.metricsConfig.build():null;
    }

    public MetricsConfig buildMetricsConfig() {
        return this.metricsConfig!=null?this.metricsConfig.build():null;
    }

    public A withMetricsConfig(MetricsConfig metricsConfig) {
        if (metricsConfig instanceof JmxPrometheusExporterMetrics){ this.metricsConfig= new JmxPrometheusExporterMetricsBuilder((JmxPrometheusExporterMetrics)metricsConfig); _visitables.get("metricsConfig").add(this.metricsConfig);}
        return (A) this;
    }

    public Boolean hasMetricsConfig() {
        return this.metricsConfig != null;
    }

    public A withJmxPrometheusExporterMetricsConfig(JmxPrometheusExporterMetrics jmxPrometheusExporterMetricsConfig) {
        _visitables.get("metricsConfig").remove(this.metricsConfig);
        if (jmxPrometheusExporterMetricsConfig!=null){ this.metricsConfig= new JmxPrometheusExporterMetricsBuilder(jmxPrometheusExporterMetricsConfig); _visitables.get("metricsConfig").add(this.metricsConfig);} return (A) this;
    }

    public ZookeeperClusterSpecFluent.JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfig() {
        return new JmxPrometheusExporterMetricsConfigNestedImpl();
    }

    public ZookeeperClusterSpecFluent.JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfigLike(JmxPrometheusExporterMetrics item) {
        return new JmxPrometheusExporterMetricsConfigNestedImpl(item);
    }

    public A addToMetrics(String key,Object value) {
        if(this.metrics == null && key != null && value != null) { this.metrics = new LinkedHashMap<String,Object>(); }
        if(key != null && value != null) {this.metrics.put(key, value);} return (A)this;
    }

    public A addToMetrics(Map<String,Object> map) {
        if(this.metrics == null && map != null) { this.metrics = new LinkedHashMap<String,Object>(); }
        if(map != null) { this.metrics.putAll(map);} return (A)this;
    }

    public A removeFromMetrics(String key) {
        if(this.metrics == null) { return (A) this; }
        if(key != null && this.metrics != null) {this.metrics.remove(key);} return (A)this;
    }

    public A removeFromMetrics(Map<String,Object> map) {
        if(this.metrics == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.metrics != null){this.metrics.remove(key);}}} return (A)this;
    }

    public Map<String,Object> getMetrics() {
        return this.metrics;
    }

    public <K extends Object,V extends Object>A withMetrics(Map<String,Object> metrics) {
        if (metrics == null) { this.metrics =  null;} else {this.metrics = new LinkedHashMap<String,Object>(metrics);} return (A) this;
    }

    public Boolean hasMetrics() {
        return this.metrics != null;
    }

    public Affinity getAffinity() {
        return this.affinity;
    }

    public A withAffinity(Affinity affinity) {
        this.affinity=affinity; return (A) this;
    }

    public Boolean hasAffinity() {
        return this.affinity != null;
    }

    public A addToTolerations(int index,Toleration item) {
        if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
        this.tolerations.add(index, item);
        return (A)this;
    }

    public A setToTolerations(int index,Toleration item) {
        if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
        this.tolerations.set(index, item); return (A)this;
    }

    public A addToTolerations(Toleration... items) {
        if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
        for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
    }

    public A addAllToTolerations(Collection<Toleration> items) {
        if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
        for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
    }

    public A removeFromTolerations(Toleration... items) {
        for (Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
    }

    public A removeAllFromTolerations(Collection<Toleration> items) {
        for (Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
    }

    public java.util.List<Toleration> getTolerations() {
        return this.tolerations;
    }

    public Toleration getToleration(int index) {
        return this.tolerations.get(index);
    }

    public Toleration getFirstToleration() {
        return this.tolerations.get(0);
    }

    public Toleration getLastToleration() {
        return this.tolerations.get(tolerations.size() - 1);
    }

    public Toleration getMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item: tolerations) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item: tolerations) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withTolerations(java.util.List<Toleration> tolerations) {
        if (this.tolerations != null) { _visitables.get("tolerations").removeAll(this.tolerations);}
        if (tolerations != null) {this.tolerations = new ArrayList<Toleration>(); for (Toleration item : tolerations){this.addToTolerations(item);}} else { this.tolerations = null;} return (A) this;
    }

    public A withTolerations(Toleration... tolerations) {
        if (this.tolerations != null) {this.tolerations.clear();}
        if (tolerations != null) {for (Toleration item :tolerations){ this.addToTolerations(item);}} return (A) this;
    }

    public Boolean hasTolerations() {
        return tolerations != null && !tolerations.isEmpty();
    }

    public A addNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value) {
        return (A)addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
    }

    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@Deprecated public ZookeeperClusterTemplate getTemplate() {
        return this.template!=null?this.template.build():null;
    }

    public ZookeeperClusterTemplate buildTemplate() {
        return this.template!=null?this.template.build():null;
    }

    public A withTemplate(ZookeeperClusterTemplate template) {
        _visitables.get("template").remove(this.template);
        if (template!=null){ this.template= new ZookeeperClusterTemplateBuilder(template); _visitables.get("template").add(this.template);} return (A) this;
    }

    public Boolean hasTemplate() {
        return this.template != null;
    }

    public ZookeeperClusterSpecFluent.TemplateNested<A> withNewTemplate() {
        return new TemplateNestedImpl();
    }

    public ZookeeperClusterSpecFluent.TemplateNested<A> withNewTemplateLike(ZookeeperClusterTemplate item) {
        return new TemplateNestedImpl(item);
    }

    public ZookeeperClusterSpecFluent.TemplateNested<A> editTemplate() {
        return withNewTemplateLike(getTemplate());
    }

    public ZookeeperClusterSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return withNewTemplateLike(getTemplate() != null ? getTemplate(): new ZookeeperClusterTemplateBuilder().build());
    }

    public ZookeeperClusterSpecFluent.TemplateNested<A> editOrNewTemplateLike(ZookeeperClusterTemplate item) {
        return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ZookeeperClusterSpecFluentImpl that = (ZookeeperClusterSpecFluentImpl) o;
        if (storage != null ? !storage.equals(that.storage) :that.storage != null) return false;
        if (config != null ? !config.equals(that.config) :that.config != null) return false;
        if (logging != null ? !logging.equals(that.logging) :that.logging != null) return false;
        if (tlsSidecar != null ? !tlsSidecar.equals(that.tlsSidecar) :that.tlsSidecar != null) return false;
        if (replicas != that.replicas) return false;
        if (image != null ? !image.equals(that.image) :that.image != null) return false;
        if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
        if (livenessProbe != null ? !livenessProbe.equals(that.livenessProbe) :that.livenessProbe != null) return false;
        if (readinessProbe != null ? !readinessProbe.equals(that.readinessProbe) :that.readinessProbe != null) return false;
        if (jvmOptions != null ? !jvmOptions.equals(that.jvmOptions) :that.jvmOptions != null) return false;
        if (metricsConfig != null ? !metricsConfig.equals(that.metricsConfig) :that.metricsConfig != null) return false;
        if (metrics != null ? !metrics.equals(that.metrics) :that.metrics != null) return false;
        if (affinity != null ? !affinity.equals(that.affinity) :that.affinity != null) return false;
        if (tolerations != null ? !tolerations.equals(that.tolerations) :that.tolerations != null) return false;
        if (template != null ? !template.equals(that.template) :that.template != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(storage,  config,  logging,  tlsSidecar,  replicas,  image,  resources,  livenessProbe,  readinessProbe,  jvmOptions,  metricsConfig,  metrics,  affinity,  tolerations,  template,  super.hashCode());
    }

    public class PersistentClaimStorageNestedImpl<N> extends PersistentClaimStorageFluentImpl<ZookeeperClusterSpecFluent.PersistentClaimStorageNested<N>> implements ZookeeperClusterSpecFluent.PersistentClaimStorageNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PersistentClaimStorageBuilder builder;

            PersistentClaimStorageNestedImpl(PersistentClaimStorage item) {
                this.builder = new PersistentClaimStorageBuilder(this, item);
                        
            }

            PersistentClaimStorageNestedImpl() {
                this.builder = new PersistentClaimStorageBuilder(this);
                        
            }

            public N and() {
                return (N) ZookeeperClusterSpecFluentImpl.this.withStorage(builder.build());
            }

            public N endPersistentClaimStorage() {
                return and();
            }
    }


    public class EphemeralStorageNestedImpl<N> extends EphemeralStorageFluentImpl<ZookeeperClusterSpecFluent.EphemeralStorageNested<N>> implements ZookeeperClusterSpecFluent.EphemeralStorageNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EphemeralStorageBuilder builder;

            EphemeralStorageNestedImpl(EphemeralStorage item) {
                this.builder = new EphemeralStorageBuilder(this, item);
                        
            }

            EphemeralStorageNestedImpl() {
                this.builder = new EphemeralStorageBuilder(this);
                        
            }

            public N and() {
                return (N) ZookeeperClusterSpecFluentImpl.this.withStorage(builder.build());
            }

            public N endEphemeralStorage() {
                return and();
            }
    }


    public class ExternalLoggingNestedImpl<N> extends ExternalLoggingFluentImpl<ZookeeperClusterSpecFluent.ExternalLoggingNested<N>> implements ZookeeperClusterSpecFluent.ExternalLoggingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ExternalLoggingBuilder builder;

            ExternalLoggingNestedImpl(ExternalLogging item) {
                this.builder = new ExternalLoggingBuilder(this, item);
                        
            }

            ExternalLoggingNestedImpl() {
                this.builder = new ExternalLoggingBuilder(this);
                        
            }

            public N and() {
                return (N) ZookeeperClusterSpecFluentImpl.this.withLogging(builder.build());
            }

            public N endExternalLogging() {
                return and();
            }
    }


    public class InlineLoggingNestedImpl<N> extends InlineLoggingFluentImpl<ZookeeperClusterSpecFluent.InlineLoggingNested<N>> implements ZookeeperClusterSpecFluent.InlineLoggingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final InlineLoggingBuilder builder;

            InlineLoggingNestedImpl(InlineLogging item) {
                this.builder = new InlineLoggingBuilder(this, item);
                        
            }

            InlineLoggingNestedImpl() {
                this.builder = new InlineLoggingBuilder(this);
                        
            }

            public N and() {
                return (N) ZookeeperClusterSpecFluentImpl.this.withLogging(builder.build());
            }

            public N endInlineLogging() {
                return and();
            }
    }


    public class TlsSidecarNestedImpl<N> extends TlsSidecarFluentImpl<ZookeeperClusterSpecFluent.TlsSidecarNested<N>> implements ZookeeperClusterSpecFluent.TlsSidecarNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final TlsSidecarBuilder builder;

            TlsSidecarNestedImpl(TlsSidecar item) {
                this.builder = new TlsSidecarBuilder(this, item);
                        
            }

            TlsSidecarNestedImpl() {
                this.builder = new TlsSidecarBuilder(this);
                        
            }

            public N and() {
                return (N) ZookeeperClusterSpecFluentImpl.this.withTlsSidecar(builder.build());
            }

            public N endTlsSidecar() {
                return and();
            }
    }


    public class LivenessProbeNestedImpl<N> extends ProbeFluentImpl<ZookeeperClusterSpecFluent.LivenessProbeNested<N>> implements ZookeeperClusterSpecFluent.LivenessProbeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ProbeBuilder builder;

            LivenessProbeNestedImpl(Probe item) {
                this.builder = new ProbeBuilder(this, item);
                        
            }

            LivenessProbeNestedImpl() {
                this.builder = new ProbeBuilder(this);
                        
            }

            public N and() {
                return (N) ZookeeperClusterSpecFluentImpl.this.withLivenessProbe(builder.build());
            }

            public N endLivenessProbe() {
                return and();
            }
    }


    public class ReadinessProbeNestedImpl<N> extends ProbeFluentImpl<ZookeeperClusterSpecFluent.ReadinessProbeNested<N>> implements ZookeeperClusterSpecFluent.ReadinessProbeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ProbeBuilder builder;

            ReadinessProbeNestedImpl(Probe item) {
                this.builder = new ProbeBuilder(this, item);
                        
            }

            ReadinessProbeNestedImpl() {
                this.builder = new ProbeBuilder(this);
                        
            }

            public N and() {
                return (N) ZookeeperClusterSpecFluentImpl.this.withReadinessProbe(builder.build());
            }

            public N endReadinessProbe() {
                return and();
            }
    }


    public class JvmOptionsNestedImpl<N> extends JvmOptionsFluentImpl<ZookeeperClusterSpecFluent.JvmOptionsNested<N>> implements ZookeeperClusterSpecFluent.JvmOptionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final JvmOptionsBuilder builder;

            JvmOptionsNestedImpl(JvmOptions item) {
                this.builder = new JvmOptionsBuilder(this, item);
                        
            }

            JvmOptionsNestedImpl() {
                this.builder = new JvmOptionsBuilder(this);
                        
            }

            public N and() {
                return (N) ZookeeperClusterSpecFluentImpl.this.withJvmOptions(builder.build());
            }

            public N endJvmOptions() {
                return and();
            }
    }


    public class JmxPrometheusExporterMetricsConfigNestedImpl<N> extends JmxPrometheusExporterMetricsFluentImpl<ZookeeperClusterSpecFluent.JmxPrometheusExporterMetricsConfigNested<N>> implements ZookeeperClusterSpecFluent.JmxPrometheusExporterMetricsConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final JmxPrometheusExporterMetricsBuilder builder;

            JmxPrometheusExporterMetricsConfigNestedImpl(JmxPrometheusExporterMetrics item) {
                this.builder = new JmxPrometheusExporterMetricsBuilder(this, item);
                        
            }

            JmxPrometheusExporterMetricsConfigNestedImpl() {
                this.builder = new JmxPrometheusExporterMetricsBuilder(this);
                        
            }

            public N and() {
                return (N) ZookeeperClusterSpecFluentImpl.this.withMetricsConfig(builder.build());
            }

            public N endJmxPrometheusExporterMetricsConfig() {
                return and();
            }
    }


    public class TemplateNestedImpl<N> extends ZookeeperClusterTemplateFluentImpl<ZookeeperClusterSpecFluent.TemplateNested<N>> implements ZookeeperClusterSpecFluent.TemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ZookeeperClusterTemplateBuilder builder;

            TemplateNestedImpl(ZookeeperClusterTemplate item) {
                this.builder = new ZookeeperClusterTemplateBuilder(this, item);
                        
            }

            TemplateNestedImpl() {
                this.builder = new ZookeeperClusterTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) ZookeeperClusterSpecFluentImpl.this.withTemplate(builder.build());
            }

            public N endTemplate() {
                return and();
            }
    }


}
