package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SystemPropertyBuilder extends SystemPropertyFluentImpl<SystemPropertyBuilder> implements VisitableBuilder<SystemProperty,SystemPropertyBuilder> {

    SystemPropertyFluent<?> fluent;
    Boolean validationEnabled;

    public SystemPropertyBuilder() {
        this(true);
    }

    public SystemPropertyBuilder(Boolean validationEnabled) {
        this(new SystemProperty(), validationEnabled);
    }

    public SystemPropertyBuilder(SystemPropertyFluent<?> fluent) {
        this(fluent, true);
    }

    public SystemPropertyBuilder(SystemPropertyFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new SystemProperty(), validationEnabled);
    }

    public SystemPropertyBuilder(SystemPropertyFluent<?> fluent,SystemProperty instance) {
        this(fluent, instance, true);
    }

    public SystemPropertyBuilder(SystemPropertyFluent<?> fluent,SystemProperty instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withName(instance.getName());
        
        fluent.withValue(instance.getValue());
        
        this.validationEnabled = validationEnabled; 
    }

    public SystemPropertyBuilder(SystemProperty instance) {
        this(instance,true);
    }

    public SystemPropertyBuilder(SystemProperty instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withName(instance.getName());
        
        this.withValue(instance.getValue());
        
        this.validationEnabled = validationEnabled; 
    }

    public SystemProperty build() {
        SystemProperty buildable = new SystemProperty();
        buildable.setName(fluent.getName());
        buildable.setValue(fluent.getValue());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        SystemPropertyBuilder that = (SystemPropertyBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
