package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RackBuilder extends RackFluentImpl<RackBuilder> implements VisitableBuilder<Rack,RackBuilder> {

    RackFluent<?> fluent;
    Boolean validationEnabled;

    public RackBuilder() {
        this(true);
    }

    public RackBuilder(Boolean validationEnabled) {
        this(new Rack(), validationEnabled);
    }

    public RackBuilder(RackFluent<?> fluent) {
        this(fluent, true);
    }

    public RackBuilder(RackFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new Rack(), validationEnabled);
    }

    public RackBuilder(RackFluent<?> fluent,Rack instance) {
        this(fluent, instance, true);
    }

    public RackBuilder(RackFluent<?> fluent,Rack instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withTopologyKey(instance.getTopologyKey()); 
        this.validationEnabled = validationEnabled; 
    }

    public RackBuilder(Rack instance) {
        this(instance,true);
    }

    public RackBuilder(Rack instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withTopologyKey(instance.getTopologyKey()); 
        this.validationEnabled = validationEnabled; 
    }

    public Rack build() {
        Rack buildable = new Rack(fluent.getTopologyKey());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        RackBuilder that = (RackBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
