package io.strimzi.api.kafka.model;

import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class ProbeFluentImpl<A extends ProbeFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ProbeFluent<A> {

    private int initialDelaySeconds;
    private int timeoutSeconds;
    private Integer periodSeconds;
    private Integer successThreshold;
    private Integer failureThreshold;

    public ProbeFluentImpl() {
    }

    public ProbeFluentImpl(Probe instance) {
        this.withInitialDelaySeconds(instance.getInitialDelaySeconds()); 
        this.withTimeoutSeconds(instance.getTimeoutSeconds()); 
        this.withPeriodSeconds(instance.getPeriodSeconds());
        
        this.withSuccessThreshold(instance.getSuccessThreshold());
        
        this.withFailureThreshold(instance.getFailureThreshold());
    }

    public int getInitialDelaySeconds() {
        return this.initialDelaySeconds;
    }

    public A withInitialDelaySeconds(int initialDelaySeconds) {
        this.initialDelaySeconds=initialDelaySeconds; return (A) this;
    }

    public Boolean hasInitialDelaySeconds() {
        return true;
    }

    public int getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public A withTimeoutSeconds(int timeoutSeconds) {
        this.timeoutSeconds=timeoutSeconds; return (A) this;
    }

    public Boolean hasTimeoutSeconds() {
        return true;
    }

    public Integer getPeriodSeconds() {
        return this.periodSeconds;
    }

    public A withPeriodSeconds(Integer periodSeconds) {
        this.periodSeconds=periodSeconds; return (A) this;
    }

    public Boolean hasPeriodSeconds() {
        return this.periodSeconds != null;
    }

    public Integer getSuccessThreshold() {
        return this.successThreshold;
    }

    public A withSuccessThreshold(Integer successThreshold) {
        this.successThreshold=successThreshold; return (A) this;
    }

    public Boolean hasSuccessThreshold() {
        return this.successThreshold != null;
    }

    public Integer getFailureThreshold() {
        return this.failureThreshold;
    }

    public A withFailureThreshold(Integer failureThreshold) {
        this.failureThreshold=failureThreshold; return (A) this;
    }

    public Boolean hasFailureThreshold() {
        return this.failureThreshold != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ProbeFluentImpl that = (ProbeFluentImpl) o;
        if (initialDelaySeconds != that.initialDelaySeconds) return false;
        if (timeoutSeconds != that.timeoutSeconds) return false;
        if (periodSeconds != null ? !periodSeconds.equals(that.periodSeconds) :that.periodSeconds != null) return false;
        if (successThreshold != null ? !successThreshold.equals(that.successThreshold) :that.successThreshold != null) return false;
        if (failureThreshold != null ? !failureThreshold.equals(that.failureThreshold) :that.failureThreshold != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(initialDelaySeconds,  timeoutSeconds,  periodSeconds,  successThreshold,  failureThreshold,  super.hashCode());
    }

}
