package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ProbeBuilder extends ProbeFluentImpl<ProbeBuilder> implements VisitableBuilder<Probe,ProbeBuilder> {

    ProbeFluent<?> fluent;
    Boolean validationEnabled;

    public ProbeBuilder() {
        this(true);
    }

    public ProbeBuilder(Boolean validationEnabled) {
        this(new Probe(), validationEnabled);
    }

    public ProbeBuilder(ProbeFluent<?> fluent) {
        this(fluent, true);
    }

    public ProbeBuilder(ProbeFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new Probe(), validationEnabled);
    }

    public ProbeBuilder(ProbeFluent<?> fluent,Probe instance) {
        this(fluent, instance, true);
    }

    public ProbeBuilder(ProbeFluent<?> fluent,Probe instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withInitialDelaySeconds(instance.getInitialDelaySeconds()); 
        fluent.withTimeoutSeconds(instance.getTimeoutSeconds()); 
        fluent.withPeriodSeconds(instance.getPeriodSeconds());
        
        fluent.withSuccessThreshold(instance.getSuccessThreshold());
        
        fluent.withFailureThreshold(instance.getFailureThreshold());
        
        this.validationEnabled = validationEnabled; 
    }

    public ProbeBuilder(Probe instance) {
        this(instance,true);
    }

    public ProbeBuilder(Probe instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withInitialDelaySeconds(instance.getInitialDelaySeconds()); 
        this.withTimeoutSeconds(instance.getTimeoutSeconds()); 
        this.withPeriodSeconds(instance.getPeriodSeconds());
        
        this.withSuccessThreshold(instance.getSuccessThreshold());
        
        this.withFailureThreshold(instance.getFailureThreshold());
        
        this.validationEnabled = validationEnabled; 
    }

    public Probe build() {
        Probe buildable = new Probe(fluent.getInitialDelaySeconds(),fluent.getTimeoutSeconds());
        buildable.setPeriodSeconds(fluent.getPeriodSeconds());
        buildable.setSuccessThreshold(fluent.getSuccessThreshold());
        buildable.setFailureThreshold(fluent.getFailureThreshold());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ProbeBuilder that = (ProbeBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
