package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaUserScramSha512ClientAuthenticationBuilder extends KafkaUserScramSha512ClientAuthenticationFluentImpl<KafkaUserScramSha512ClientAuthenticationBuilder> implements VisitableBuilder<KafkaUserScramSha512ClientAuthentication,KafkaUserScramSha512ClientAuthenticationBuilder> {

    KafkaUserScramSha512ClientAuthenticationFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaUserScramSha512ClientAuthenticationBuilder() {
        this(true);
    }

    public KafkaUserScramSha512ClientAuthenticationBuilder(Boolean validationEnabled) {
        this(new KafkaUserScramSha512ClientAuthentication(), validationEnabled);
    }

    public KafkaUserScramSha512ClientAuthenticationBuilder(KafkaUserScramSha512ClientAuthenticationFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaUserScramSha512ClientAuthenticationBuilder(KafkaUserScramSha512ClientAuthenticationFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KafkaUserScramSha512ClientAuthentication(), validationEnabled);
    }

    public KafkaUserScramSha512ClientAuthenticationBuilder(KafkaUserScramSha512ClientAuthenticationFluent<?> fluent,KafkaUserScramSha512ClientAuthentication instance) {
        this(fluent, instance, true);
    }

    public KafkaUserScramSha512ClientAuthenticationBuilder(KafkaUserScramSha512ClientAuthenticationFluent<?> fluent,KafkaUserScramSha512ClientAuthentication instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        this.validationEnabled = validationEnabled; 
    }

    public KafkaUserScramSha512ClientAuthenticationBuilder(KafkaUserScramSha512ClientAuthentication instance) {
        this(instance,true);
    }

    public KafkaUserScramSha512ClientAuthenticationBuilder(KafkaUserScramSha512ClientAuthentication instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.validationEnabled = validationEnabled; 
    }

    public KafkaUserScramSha512ClientAuthentication build() {
        KafkaUserScramSha512ClientAuthentication buildable = new KafkaUserScramSha512ClientAuthentication();
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaUserScramSha512ClientAuthenticationBuilder that = (KafkaUserScramSha512ClientAuthenticationBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
